/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import java.time.Instant;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TypeConvertingVisitor;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class InstantAsStringAttributeConverter
implements AttributeConverter<Instant> {
    private static final Visitor VISITOR = new Visitor();

    private InstantAsStringAttributeConverter() {
    }

    public static InstantAsStringAttributeConverter create() {
        return new InstantAsStringAttributeConverter();
    }

    @Override
    public EnhancedType<Instant> type() {
        return EnhancedType.of(Instant.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.S;
    }

    @Override
    public AttributeValue transformFrom(Instant input) {
        return (AttributeValue)AttributeValue.builder().s(input.toString()).build();
    }

    @Override
    public Instant transformTo(AttributeValue input) {
        try {
            if (input.s() != null) {
                return EnhancedAttributeValue.fromString(input.s()).convert(VISITOR);
            }
            return EnhancedAttributeValue.fromAttributeValue(input).convert(VISITOR);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static final class Visitor
    extends TypeConvertingVisitor<Instant> {
        private Visitor() {
            super(Instant.class, InstantAsStringAttributeConverter.class);
        }

        @Override
        public Instant convertString(String value) {
            return Instant.parse(value);
        }
    }
}

