/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.transport.experiment;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.searchrelevance.dao.EvaluationResultDao;
import org.opensearch.searchrelevance.dao.ExperimentDao;
import org.opensearch.searchrelevance.dao.ExperimentVariantDao;
import org.opensearch.searchrelevance.dao.ScheduledExperimentHistoryDao;
import org.opensearch.searchrelevance.dao.ScheduledJobsDao;
import org.opensearch.searchrelevance.exception.SearchRelevanceException;
import org.opensearch.searchrelevance.transport.OpenSearchDocRequest;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class DeleteExperimentTransportAction
extends HandledTransportAction<OpenSearchDocRequest, DeleteResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(DeleteExperimentTransportAction.class);
    private final ClusterService clusterService;
    private final ExperimentDao experimentDao;
    private final ExperimentVariantDao experimentVariantDao;
    private final EvaluationResultDao evaluationResultDao;
    private final ScheduledJobsDao scheduledJobsDao;
    private final ScheduledExperimentHistoryDao scheduledExperimentHistoryDao;

    @Inject
    public DeleteExperimentTransportAction(ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, ExperimentDao experimentDao, EvaluationResultDao evaluationResultDao, ExperimentVariantDao experimentVariantDao, ScheduledJobsDao scheduledJobsDao, ScheduledExperimentHistoryDao scheduledExperimentHistoryDao) {
        super("cluster:admin/opensearch/search_relevance/experiment/delete", transportService, actionFilters, OpenSearchDocRequest::new);
        this.clusterService = clusterService;
        this.experimentDao = experimentDao;
        this.experimentVariantDao = experimentVariantDao;
        this.evaluationResultDao = evaluationResultDao;
        this.scheduledJobsDao = scheduledJobsDao;
        this.scheduledExperimentHistoryDao = scheduledExperimentHistoryDao;
    }

    protected void doExecute(Task task, OpenSearchDocRequest request, final ActionListener<DeleteResponse> listener) {
        try {
            final String experimentId = request.getId();
            if (experimentId == null || experimentId.trim().isEmpty()) {
                listener.onFailure((Exception)((Object)new SearchRelevanceException("Experiment ID cannot be null or empty", RestStatus.BAD_REQUEST)));
                return;
            }
            this.experimentDao.deleteExperiment(experimentId, listener);
            this.evaluationResultDao.deleteEvaluationResultByExperimentId(experimentId, new ActionListener<BulkByScrollResponse>(this){
                final /* synthetic */ DeleteExperimentTransportAction this$0;
                {
                    this.this$0 = this$0;
                }

                public void onResponse(BulkByScrollResponse bulkByScrollResponse) {
                    if (this.this$0.hasBulkFailures(bulkByScrollResponse)) {
                        listener.onFailure((Exception)((Object)new SearchRelevanceException("Failed to delete the evaluation results of the experiment, due to failures in deleting evaluation results " + String.valueOf(bulkByScrollResponse.getBulkFailures()), RestStatus.INTERNAL_SERVER_ERROR)));
                    }
                    if (this.this$0.hasSearchFailures(bulkByScrollResponse)) {
                        listener.onFailure((Exception)((Object)new SearchRelevanceException("Failed to delete the evaluation results of the experiment, due to failures in deleting evaluation results " + String.valueOf(bulkByScrollResponse.getSearchFailures()), RestStatus.INTERNAL_SERVER_ERROR)));
                    }
                }

                public void onFailure(Exception e) {
                    log.error("Failed to delete evaluation results for experiment [{}]", (Object)experimentId, (Object)e);
                }
            });
            this.experimentVariantDao.deleteExperimentVariantByExperimentId(experimentId, new ActionListener<BulkByScrollResponse>(this){
                final /* synthetic */ DeleteExperimentTransportAction this$0;
                {
                    this.this$0 = this$0;
                }

                public void onResponse(BulkByScrollResponse bulkByScrollResponse) {
                    if (this.this$0.hasBulkFailures(bulkByScrollResponse)) {
                        listener.onFailure((Exception)((Object)new SearchRelevanceException("Failed to delete experiment, due to failures in deleting experiment variants " + String.valueOf(bulkByScrollResponse.getBulkFailures()), RestStatus.INTERNAL_SERVER_ERROR)));
                    }
                    if (this.this$0.hasSearchFailures(bulkByScrollResponse)) {
                        listener.onFailure((Exception)((Object)new SearchRelevanceException("Failed to delete experiment, due to failures in deleting experiment variants " + String.valueOf(bulkByScrollResponse.getSearchFailures()), RestStatus.INTERNAL_SERVER_ERROR)));
                    }
                }

                public void onFailure(Exception e) {
                    log.error("Failed to delete experiment variants results for experiment [{}]", (Object)experimentId, (Object)e);
                }
            });
            this.scheduledJobsDao.deleteScheduledJob(experimentId, new ActionListener<DeleteResponse>(this){

                public void onResponse(DeleteResponse deleteResponse) {
                }

                public void onFailure(Exception e) {
                    log.error("Failed to delete schedule job for the experiment [{}]", (Object)experimentId, (Object)e);
                }
            });
            this.scheduledExperimentHistoryDao.deleteScheduledExperimentHistoryByExperimentId(experimentId, new ActionListener<BulkByScrollResponse>(this){

                public void onResponse(BulkByScrollResponse bulkByScrollResponse) {
                }

                public void onFailure(Exception e) {
                    log.error("Failed to delete schedule experiment history for the experiment [{}]", (Object)experimentId, (Object)e);
                }
            });
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private boolean hasBulkFailures(BulkByScrollResponse bulkByScrollResponse) {
        return bulkByScrollResponse.getBulkFailures() != null && !bulkByScrollResponse.getBulkFailures().isEmpty();
    }

    private boolean hasSearchFailures(BulkByScrollResponse bulkByScrollResponse) {
        return bulkByScrollResponse.getSearchFailures() != null && !bulkByScrollResponse.getSearchFailures().isEmpty();
    }
}

