/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types;

import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.util.Objects;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.AuthenticateAction;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.PathSegment;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.StructuredDataTerminal;

public class AuthItem {
    public DafnySequence<? extends PathSegment> _key;
    public StructuredDataTerminal _data;
    public AuthenticateAction _action;
    private static final TypeDescriptor<AuthItem> _TYPE = TypeDescriptor.referenceWithInitializer(AuthItem.class, () -> AuthItem.Default());
    private static final AuthItem theDefault = AuthItem.create((DafnySequence<? extends PathSegment>)DafnySequence.empty(PathSegment._typeDescriptor()), StructuredDataTerminal.Default(), AuthenticateAction.Default());

    public AuthItem(DafnySequence<? extends PathSegment> key, StructuredDataTerminal data, AuthenticateAction action) {
        this._key = key;
        this._data = data;
        this._action = action;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        AuthItem o = (AuthItem)other;
        return Objects.equals(this._key, o._key) && Objects.equals(this._data, o._data) && Objects.equals(this._action, o._action);
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._key);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._data);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._action);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("AwsCryptographyDbEncryptionSdkStructuredEncryptionTypes.AuthItem.AuthItem");
        s.append("(");
        s.append(Helpers.toString(this._key));
        s.append(", ");
        s.append(Helpers.toString((Object)this._data));
        s.append(", ");
        s.append(Helpers.toString((Object)this._action));
        s.append(")");
        return s.toString();
    }

    public static TypeDescriptor<AuthItem> _typeDescriptor() {
        return _TYPE;
    }

    public static AuthItem Default() {
        return theDefault;
    }

    public static AuthItem create(DafnySequence<? extends PathSegment> key, StructuredDataTerminal data, AuthenticateAction action) {
        return new AuthItem(key, data, action);
    }

    public static AuthItem create_AuthItem(DafnySequence<? extends PathSegment> key, StructuredDataTerminal data, AuthenticateAction action) {
        return AuthItem.create(key, data, action);
    }

    public boolean is_AuthItem() {
        return true;
    }

    public DafnySequence<? extends PathSegment> dtor_key() {
        return this._key;
    }

    public StructuredDataTerminal dtor_data() {
        return this._data;
    }

    public AuthenticateAction dtor_action() {
        return this._action;
    }
}

