/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.dynamodb.model;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.LegacyOverride;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.PlaintextOverride;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.SearchConfig;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.CryptoAction;
import software.amazon.cryptography.materialproviders.CryptographicMaterialsManager;
import software.amazon.cryptography.materialproviders.ICryptographicMaterialsManager;
import software.amazon.cryptography.materialproviders.IKeyring;
import software.amazon.cryptography.materialproviders.Keyring;
import software.amazon.cryptography.materialproviders.model.DBEAlgorithmSuiteId;

public class DynamoDbTableEncryptionConfig {
    private final String logicalTableName;
    private final String partitionKeyName;
    private final String sortKeyName;
    private final SearchConfig search;
    private final Map<String, CryptoAction> attributeActionsOnEncrypt;
    private final List<String> allowedUnsignedAttributes;
    private final String allowedUnsignedAttributePrefix;
    private final DBEAlgorithmSuiteId algorithmSuiteId;
    private final IKeyring keyring;
    private final ICryptographicMaterialsManager cmm;
    private final LegacyOverride legacyOverride;
    private final PlaintextOverride plaintextOverride;

    protected DynamoDbTableEncryptionConfig(BuilderImpl builder) {
        this.logicalTableName = builder.logicalTableName();
        this.partitionKeyName = builder.partitionKeyName();
        this.sortKeyName = builder.sortKeyName();
        this.search = builder.search();
        this.attributeActionsOnEncrypt = builder.attributeActionsOnEncrypt();
        this.allowedUnsignedAttributes = builder.allowedUnsignedAttributes();
        this.allowedUnsignedAttributePrefix = builder.allowedUnsignedAttributePrefix();
        this.algorithmSuiteId = builder.algorithmSuiteId();
        this.keyring = builder.keyring();
        this.cmm = builder.cmm();
        this.legacyOverride = builder.legacyOverride();
        this.plaintextOverride = builder.plaintextOverride();
    }

    public String logicalTableName() {
        return this.logicalTableName;
    }

    public String partitionKeyName() {
        return this.partitionKeyName;
    }

    public String sortKeyName() {
        return this.sortKeyName;
    }

    public SearchConfig search() {
        return this.search;
    }

    public Map<String, CryptoAction> attributeActionsOnEncrypt() {
        return this.attributeActionsOnEncrypt;
    }

    public List<String> allowedUnsignedAttributes() {
        return this.allowedUnsignedAttributes;
    }

    public String allowedUnsignedAttributePrefix() {
        return this.allowedUnsignedAttributePrefix;
    }

    public DBEAlgorithmSuiteId algorithmSuiteId() {
        return this.algorithmSuiteId;
    }

    public IKeyring keyring() {
        return this.keyring;
    }

    public ICryptographicMaterialsManager cmm() {
        return this.cmm;
    }

    public LegacyOverride legacyOverride() {
        return this.legacyOverride;
    }

    public PlaintextOverride plaintextOverride() {
        return this.plaintextOverride;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String logicalTableName;
        protected String partitionKeyName;
        protected String sortKeyName;
        protected SearchConfig search;
        protected Map<String, CryptoAction> attributeActionsOnEncrypt;
        protected List<String> allowedUnsignedAttributes;
        protected String allowedUnsignedAttributePrefix;
        protected DBEAlgorithmSuiteId algorithmSuiteId;
        protected IKeyring keyring;
        protected ICryptographicMaterialsManager cmm;
        protected LegacyOverride legacyOverride;
        protected PlaintextOverride plaintextOverride;

        protected BuilderImpl() {
        }

        protected BuilderImpl(DynamoDbTableEncryptionConfig model) {
            this.logicalTableName = model.logicalTableName();
            this.partitionKeyName = model.partitionKeyName();
            this.sortKeyName = model.sortKeyName();
            this.search = model.search();
            this.attributeActionsOnEncrypt = model.attributeActionsOnEncrypt();
            this.allowedUnsignedAttributes = model.allowedUnsignedAttributes();
            this.allowedUnsignedAttributePrefix = model.allowedUnsignedAttributePrefix();
            this.algorithmSuiteId = model.algorithmSuiteId();
            this.keyring = model.keyring();
            this.cmm = model.cmm();
            this.legacyOverride = model.legacyOverride();
            this.plaintextOverride = model.plaintextOverride();
        }

        @Override
        public Builder logicalTableName(String logicalTableName) {
            this.logicalTableName = logicalTableName;
            return this;
        }

        @Override
        public String logicalTableName() {
            return this.logicalTableName;
        }

        @Override
        public Builder partitionKeyName(String partitionKeyName) {
            this.partitionKeyName = partitionKeyName;
            return this;
        }

        @Override
        public String partitionKeyName() {
            return this.partitionKeyName;
        }

        @Override
        public Builder sortKeyName(String sortKeyName) {
            this.sortKeyName = sortKeyName;
            return this;
        }

        @Override
        public String sortKeyName() {
            return this.sortKeyName;
        }

        @Override
        public Builder search(SearchConfig search) {
            this.search = search;
            return this;
        }

        @Override
        public SearchConfig search() {
            return this.search;
        }

        @Override
        public Builder attributeActionsOnEncrypt(Map<String, CryptoAction> attributeActionsOnEncrypt) {
            this.attributeActionsOnEncrypt = attributeActionsOnEncrypt;
            return this;
        }

        @Override
        public Map<String, CryptoAction> attributeActionsOnEncrypt() {
            return this.attributeActionsOnEncrypt;
        }

        @Override
        public Builder allowedUnsignedAttributes(List<String> allowedUnsignedAttributes) {
            this.allowedUnsignedAttributes = allowedUnsignedAttributes;
            return this;
        }

        @Override
        public List<String> allowedUnsignedAttributes() {
            return this.allowedUnsignedAttributes;
        }

        @Override
        public Builder allowedUnsignedAttributePrefix(String allowedUnsignedAttributePrefix) {
            this.allowedUnsignedAttributePrefix = allowedUnsignedAttributePrefix;
            return this;
        }

        @Override
        public String allowedUnsignedAttributePrefix() {
            return this.allowedUnsignedAttributePrefix;
        }

        @Override
        public Builder algorithmSuiteId(DBEAlgorithmSuiteId algorithmSuiteId) {
            this.algorithmSuiteId = algorithmSuiteId;
            return this;
        }

        @Override
        public DBEAlgorithmSuiteId algorithmSuiteId() {
            return this.algorithmSuiteId;
        }

        @Override
        public Builder keyring(IKeyring keyring) {
            this.keyring = Keyring.wrap((IKeyring)keyring);
            return this;
        }

        @Override
        public IKeyring keyring() {
            return this.keyring;
        }

        @Override
        public Builder cmm(ICryptographicMaterialsManager cmm) {
            this.cmm = CryptographicMaterialsManager.wrap((ICryptographicMaterialsManager)cmm);
            return this;
        }

        @Override
        public ICryptographicMaterialsManager cmm() {
            return this.cmm;
        }

        @Override
        public Builder legacyOverride(LegacyOverride legacyOverride) {
            this.legacyOverride = legacyOverride;
            return this;
        }

        @Override
        public LegacyOverride legacyOverride() {
            return this.legacyOverride;
        }

        @Override
        public Builder plaintextOverride(PlaintextOverride plaintextOverride) {
            this.plaintextOverride = plaintextOverride;
            return this;
        }

        @Override
        public PlaintextOverride plaintextOverride() {
            return this.plaintextOverride;
        }

        @Override
        public DynamoDbTableEncryptionConfig build() {
            if (Objects.isNull(this.logicalTableName())) {
                throw new IllegalArgumentException("Missing value for required field `logicalTableName`");
            }
            if (Objects.isNull(this.partitionKeyName())) {
                throw new IllegalArgumentException("Missing value for required field `partitionKeyName`");
            }
            if (Objects.nonNull(this.partitionKeyName()) && this.partitionKeyName().length() < 1) {
                throw new IllegalArgumentException("The size of `partitionKeyName` must be greater than or equal to 1");
            }
            if (Objects.nonNull(this.partitionKeyName()) && this.partitionKeyName().length() > 255) {
                throw new IllegalArgumentException("The size of `partitionKeyName` must be less than or equal to 255");
            }
            if (Objects.nonNull(this.sortKeyName()) && this.sortKeyName().length() < 1) {
                throw new IllegalArgumentException("The size of `sortKeyName` must be greater than or equal to 1");
            }
            if (Objects.nonNull(this.sortKeyName()) && this.sortKeyName().length() > 255) {
                throw new IllegalArgumentException("The size of `sortKeyName` must be less than or equal to 255");
            }
            if (Objects.isNull(this.attributeActionsOnEncrypt())) {
                throw new IllegalArgumentException("Missing value for required field `attributeActionsOnEncrypt`");
            }
            if (Objects.nonNull(this.allowedUnsignedAttributes()) && this.allowedUnsignedAttributes().size() < 1) {
                throw new IllegalArgumentException("The size of `allowedUnsignedAttributes` must be greater than or equal to 1");
            }
            return new DynamoDbTableEncryptionConfig(this);
        }
    }

    public static interface Builder {
        public Builder logicalTableName(String var1);

        public String logicalTableName();

        public Builder partitionKeyName(String var1);

        public String partitionKeyName();

        public Builder sortKeyName(String var1);

        public String sortKeyName();

        public Builder search(SearchConfig var1);

        public SearchConfig search();

        public Builder attributeActionsOnEncrypt(Map<String, CryptoAction> var1);

        public Map<String, CryptoAction> attributeActionsOnEncrypt();

        public Builder allowedUnsignedAttributes(List<String> var1);

        public List<String> allowedUnsignedAttributes();

        public Builder allowedUnsignedAttributePrefix(String var1);

        public String allowedUnsignedAttributePrefix();

        public Builder algorithmSuiteId(DBEAlgorithmSuiteId var1);

        public DBEAlgorithmSuiteId algorithmSuiteId();

        public Builder keyring(IKeyring var1);

        public IKeyring keyring();

        public Builder cmm(ICryptographicMaterialsManager var1);

        public ICryptographicMaterialsManager cmm();

        public Builder legacyOverride(LegacyOverride var1);

        public LegacyOverride legacyOverride();

        public Builder plaintextOverride(PlaintextOverride var1);

        public PlaintextOverride plaintextOverride();

        public DynamoDbTableEncryptionConfig build();
    }
}

