/*
 * Decompiled with CFR 0.152.
 */
package BaseBeacon_Compile;

import BaseBeacon_Compile.BeaconBase;
import BaseBeacon_Compile.StandardBeacon;
import TermLoc_Compile.Selector;
import TermLoc_Compile.TermLoc;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.Helpers;
import java.math.BigInteger;
import java.util.Objects;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;

public class __default {
    public static Result<StandardBeacon, Error> MakeStandardBeacon(AtomicPrimitivesClient client, DafnySequence<? extends Character> name, byte length, DafnySequence<? extends Character> loc, boolean partOnly, boolean asSet, Option<DafnySequence<? extends Character>> share) {
        Result<DafnySequence<? extends Selector>, Error> _0_valueOrError0 = TermLoc_Compile.__default.MakeTermLoc(loc);
        if (_0_valueOrError0.IsFailure(TermLoc._typeDescriptor(), Error._typeDescriptor())) {
            return _0_valueOrError0.PropagateFailure(TermLoc._typeDescriptor(), Error._typeDescriptor(), StandardBeacon._typeDescriptor());
        }
        DafnySequence _1_termLoc = (DafnySequence)_0_valueOrError0.Extract(TermLoc._typeDescriptor(), Error._typeDescriptor());
        DafnySequence _2_beaconName = DafnySequence.concatenate(DynamoDbEncryptionUtil_Compile.__default.BeaconPrefix(), name);
        Outcome _3_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), (boolean)software.amazon.cryptography.services.dynamodb.internaldafny.types.__default.IsValid__AttributeName((DafnySequence)_2_beaconName), (Object)DynamoDbEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)_2_beaconName, (DafnySequence)DafnySequence.asString((String)" is not a valid attribute name."))));
        if (_3_valueOrError1.IsFailure(Error._typeDescriptor())) {
            return _3_valueOrError1.PropagateFailure(Error._typeDescriptor(), StandardBeacon._typeDescriptor());
        }
        return Result.create_Success(StandardBeacon._typeDescriptor(), Error._typeDescriptor(), (Object)StandardBeacon.create(BeaconBase.create(client, name, (DafnySequence<? extends Character>)_2_beaconName), length, (DafnySequence<? extends Selector>)_1_termLoc, partOnly, asSet, share));
    }

    public static BigInteger CharsFromBeaconLength(byte bits) {
        return Helpers.unsignedToBigInteger((byte)Helpers.divideUnsignedByte((byte)((byte)(bits + 3)), (byte)4));
    }

    public static byte TopBits(byte bits) {
        byte _0_x = Helpers.remainderUnsignedByte((byte)bits, (byte)4);
        if (!(_0_x != 0)) {
            return 4;
        }
        return _0_x;
    }

    public static BigInteger BytesFromBeaconLength(byte bits) {
        return Helpers.unsignedToBigInteger((byte)Helpers.divideUnsignedByte((byte)((byte)(bits + 7)), (byte)8));
    }

    public static byte TruncateNibble(byte nibble, byte length) {
        if (length == 4) {
            return nibble;
        }
        if (length == 3) {
            return Helpers.remainderUnsignedByte((byte)nibble, (byte)8);
        }
        if (length == 2) {
            return Helpers.remainderUnsignedByte((byte)nibble, (byte)4);
        }
        return Helpers.remainderUnsignedByte((byte)nibble, (byte)2);
    }

    public static DafnySequence<? extends Character> BytesToHex(DafnySequence<? extends Byte> bytes, byte bits) {
        BigInteger _0_numBytes = __default.BytesFromBeaconLength(bits);
        BigInteger _1_numChars = __default.CharsFromBeaconLength(bits);
        byte _2_topBits = __default.TopBits(bits);
        DafnySequence _3_bytes = bytes.drop(BigInteger.valueOf(8L).subtract(_0_numBytes));
        if (Objects.equals(_1_numChars, BigInteger.valueOf(2L).multiply(_0_numBytes))) {
            byte _4_topNibble = Helpers.divideUnsignedByte((byte)((Byte)_3_bytes.select(Helpers.toInt((BigInteger)BigInteger.ZERO))), (byte)16);
            byte _5_bottomNibble = Helpers.remainderUnsignedByte((byte)((Byte)_3_bytes.select(Helpers.toInt((BigInteger)BigInteger.ZERO))), (byte)16);
            return DafnySequence.concatenate((DafnySequence)DafnySequence.of((char[])new char[]{HexStrings_Compile.__default.HexChar((byte)__default.TruncateNibble(_4_topNibble, _2_topBits)), HexStrings_Compile.__default.HexChar((byte)_5_bottomNibble)}), (DafnySequence)HexStrings_Compile.__default.ToHexString((DafnySequence)_3_bytes.drop(BigInteger.ONE)));
        }
        return DafnySequence.concatenate((DafnySequence)DafnySequence.of((char[])new char[]{HexStrings_Compile.__default.HexChar((byte)__default.TruncateNibble(Helpers.remainderUnsignedByte((byte)((Byte)_3_bytes.select(Helpers.toInt((BigInteger)BigInteger.ZERO))), (byte)16), _2_topBits))}), (DafnySequence)HexStrings_Compile.__default.ToHexString((DafnySequence)_3_bytes.drop(BigInteger.ONE)));
    }

    public String toString() {
        return "BaseBeacon._default";
    }
}

