/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.ad.indices.ADIndex;
import org.opensearch.ad.model.ADTask;
import org.opensearch.ad.model.AnomalyResultBucket;
import org.opensearch.ad.transport.GetAnomalyDetectorAction;
import org.opensearch.ad.transport.SearchTopAnomalyResultAction;
import org.opensearch.ad.transport.SearchTopAnomalyResultRequest;
import org.opensearch.ad.transport.SearchTopAnomalyResultResponse;
import org.opensearch.ad.transport.handler.ADSearchHandler;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.ExistsQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.script.Script;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.PipelineAggregationBuilder;
import org.opensearch.search.aggregations.PipelineAggregatorBuilders;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.opensearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.composite.TermsValuesSourceBuilder;
import org.opensearch.search.aggregations.pipeline.BucketSortPipelineAggregationBuilder;
import org.opensearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.FieldSortBuilder;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.tasks.Task;
import org.opensearch.timeseries.common.exception.ResourceNotFoundException;
import org.opensearch.timeseries.common.exception.TimeSeriesException;
import org.opensearch.timeseries.transport.GetConfigRequest;
import org.opensearch.timeseries.util.QueryUtil;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class SearchTopAnomalyResultTransportAction
extends HandledTransportAction<SearchTopAnomalyResultRequest, SearchTopAnomalyResultResponse> {
    private ADSearchHandler searchHandler;
    private static final int PAGE_SIZE = 1000;
    private static final OrderType DEFAULT_ORDER_TYPE = OrderType.SEVERITY;
    private static final int DEFAULT_SIZE = 10;
    private static final int MAX_SIZE = 1000;
    private static final String defaultIndex = ".opendistro-anomaly-results*";
    private static final String COUNT_FIELD = "_count";
    private static final String BUCKET_SORT_FIELD = "bucket_sort";
    public static final String MULTI_BUCKETS_FIELD = "multi_buckets";
    private static final Logger logger = LogManager.getLogger(SearchTopAnomalyResultTransportAction.class);
    private final Client client;
    private Clock clock;

    @Inject
    public SearchTopAnomalyResultTransportAction(TransportService transportService, ActionFilters actionFilters, ADSearchHandler searchHandler, Client client) {
        super(SearchTopAnomalyResultAction.NAME, transportService, actionFilters, SearchTopAnomalyResultRequest::new);
        this.searchHandler = searchHandler;
        this.client = client;
        this.clock = Clock.systemUTC();
    }

    protected void doExecute(Task task, SearchTopAnomalyResultRequest request, ActionListener<SearchTopAnomalyResultResponse> listener) {
        GetConfigRequest getAdRequest = new GetConfigRequest(request.getId(), ADIndex.CONFIG.getIndexName(), -3L, false, true, "", "", false, null);
        this.client.execute((ActionType)GetAnomalyDetectorAction.INSTANCE, (ActionRequest)getAdRequest, ActionListener.wrap(getAdResponse -> {
            String customResultIndexPattern;
            OrderType orderType;
            String orderString;
            if (getAdResponse.getDetector() == null) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "No anomaly detector found with ID %s", request.getId()));
            }
            List<String> categoryFieldsFromResponse = getAdResponse.getDetector().getCategoryFields();
            if (categoryFieldsFromResponse == null || categoryFieldsFromResponse.isEmpty()) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "No category fields found for detector ID %s", request.getId()));
            }
            if (request.getCategoryFields() == null || request.getCategoryFields().isEmpty()) {
                request.setCategoryFields(categoryFieldsFromResponse);
            } else {
                for (String categoryField : request.getCategoryFields()) {
                    if (categoryFieldsFromResponse.contains(categoryField)) continue;
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Category field %s doesn't exist for detector ID %s", categoryField, request.getId()));
                }
            }
            if (request.getHistorical()) {
                ADTask historicalTask = getAdResponse.getHistoricalAdTask();
                if (historicalTask == null) {
                    throw new ResourceNotFoundException(String.format(Locale.ROOT, "No historical tasks found for detector ID %s", request.getId()));
                }
                if (Strings.isNullOrEmpty((String)request.getTaskId())) {
                    request.setTaskId(historicalTask.getTaskId());
                }
            }
            if (Strings.isNullOrEmpty((String)(orderString = request.getOrder()))) {
                orderType = DEFAULT_ORDER_TYPE;
            } else if (orderString.equals(OrderType.SEVERITY.getName())) {
                orderType = OrderType.SEVERITY;
            } else if (orderString.equals(OrderType.OCCURRENCE.getName())) {
                orderType = OrderType.OCCURRENCE;
            } else {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Ordering by %s is not a valid option", orderString));
            }
            request.setOrder(orderType.getName());
            if (request.getSize() == null) {
                request.setSize(10);
            } else {
                if (request.getSize() > 1000) {
                    throw new IllegalArgumentException("Size cannot exceed 1000");
                }
                if (request.getSize() <= 0) {
                    throw new IllegalArgumentException("Size must be a positive integer");
                }
            }
            SearchRequest searchRequest = this.generateSearchRequest(request);
            String rawCustomResultIndexPattern = getAdResponse.getDetector().getCustomResultIndexPattern();
            String string = customResultIndexPattern = rawCustomResultIndexPattern == null ? null : rawCustomResultIndexPattern.trim();
            if (!Strings.isNullOrEmpty((String)customResultIndexPattern)) {
                searchRequest.indices(new String[]{defaultIndex, customResultIndexPattern});
            }
            this.searchHandler.search(searchRequest, "anomaly-detector", new TopAnomalyResultListener(listener, searchRequest.source(), this.clock.millis() + 60000L, request.getSize(), orderType, customResultIndexPattern));
        }, exception -> {
            logger.error("Failed to get top anomaly results", (Throwable)exception);
            listener.onFailure(exception);
        }));
    }

    private SearchRequest generateSearchRequest(SearchTopAnomalyResultRequest request) {
        SearchRequest searchRequest = new SearchRequest().indices(new String[]{defaultIndex});
        QueryBuilder query = this.generateQuery(request);
        AggregationBuilder aggregation = this.generateAggregation(request);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query(query).aggregation(aggregation);
        searchRequest.source(searchSourceBuilder);
        return searchRequest;
    }

    private QueryBuilder generateQuery(SearchTopAnomalyResultRequest request) {
        BoolQueryBuilder query = new BoolQueryBuilder();
        RangeQueryBuilder dateRangeFilter = QueryBuilders.rangeQuery((String)"data_end_time").gte((Object)request.getStartTime().toEpochMilli()).lte((Object)request.getEndTime().toEpochMilli());
        RangeQueryBuilder anomalyGradeFilter = QueryBuilders.rangeQuery((String)"anomaly_grade").gt((Object)0);
        query.filter((QueryBuilder)dateRangeFilter).filter((QueryBuilder)anomalyGradeFilter);
        if (request.getHistorical()) {
            TermQueryBuilder taskIdFilter = QueryBuilders.termQuery((String)"task_id", (String)request.getTaskId());
            query.filter((QueryBuilder)taskIdFilter);
        } else {
            TermQueryBuilder detectorIdFilter = QueryBuilders.termQuery((String)"detector_id", (String)request.getId());
            ExistsQueryBuilder taskIdExistsFilter = QueryBuilders.existsQuery((String)"task_id");
            query.filter((QueryBuilder)detectorIdFilter).mustNot((QueryBuilder)taskIdExistsFilter);
        }
        return query;
    }

    private AggregationBuilder generateAggregation(SearchTopAnomalyResultRequest request) {
        ArrayList<CompositeValuesSourceBuilder> sources = new ArrayList<CompositeValuesSourceBuilder>();
        for (String categoryField : request.getCategoryFields()) {
            Script script = QueryUtil.getScriptForCategoryField(categoryField);
            sources.add(new TermsValuesSourceBuilder(categoryField).script(script));
        }
        ValuesSourceAggregationBuilder maxAnomalyGradeAggregation = AggregationBuilders.max((String)"max_anomaly_grade").field("anomaly_grade");
        String sortField = request.getOrder().equals(OrderType.SEVERITY.getName()) ? "max_anomaly_grade" : COUNT_FIELD;
        BucketSortPipelineAggregationBuilder bucketSort = PipelineAggregatorBuilders.bucketSort((String)BUCKET_SORT_FIELD, new ArrayList<FieldSortBuilder>(Arrays.asList((FieldSortBuilder)new FieldSortBuilder(sortField).order(SortOrder.DESC))));
        return ((CompositeAggregationBuilder)AggregationBuilders.composite((String)MULTI_BUCKETS_FIELD, sources).size(1000).subAggregation((AggregationBuilder)maxAnomalyGradeAggregation)).subAggregation((PipelineAggregationBuilder)bucketSort);
    }

    private List<AnomalyResultBucket> getDescendingOrderListFromHeap(PriorityQueue<AnomalyResultBucket> minHeap) {
        ArrayList<AnomalyResultBucket> topResultsHeapAsList = new ArrayList<AnomalyResultBucket>();
        while (!minHeap.isEmpty()) {
            topResultsHeapAsList.add(minHeap.poll());
        }
        Collections.reverse(topResultsHeapAsList);
        return topResultsHeapAsList;
    }

    public static enum OrderType {
        SEVERITY("severity"),
        OCCURRENCE("occurrence");

        private String name;

        private OrderType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    class TopAnomalyResultListener
    implements ActionListener<SearchResponse> {
        private ActionListener<SearchTopAnomalyResultResponse> listener;
        SearchSourceBuilder searchSourceBuilder;
        private long expirationEpochMs;
        private int maxResults;
        private PriorityQueue<AnomalyResultBucket> topResultsHeap;
        private String customResultIndex;

        TopAnomalyResultListener(ActionListener<SearchTopAnomalyResultResponse> listener, SearchSourceBuilder searchSourceBuilder, long expirationEpochMs, int maxResults, final OrderType orderType, String customResultIndex) {
            this.listener = listener;
            this.searchSourceBuilder = searchSourceBuilder;
            this.expirationEpochMs = expirationEpochMs;
            this.maxResults = maxResults;
            this.topResultsHeap = new PriorityQueue<AnomalyResultBucket>(maxResults, new Comparator<AnomalyResultBucket>(){

                @Override
                public int compare(AnomalyResultBucket bucket1, AnomalyResultBucket bucket2) {
                    if (orderType == OrderType.SEVERITY) {
                        return Double.compare(bucket1.getMaxAnomalyGrade(), bucket2.getMaxAnomalyGrade());
                    }
                    return Integer.compare(bucket1.getDocCount(), bucket2.getDocCount());
                }
            });
            this.customResultIndex = customResultIndex;
        }

        public void onResponse(SearchResponse response) {
            try {
                Aggregations aggs = response.getAggregations();
                if (aggs == null) {
                    logger.warn("Unexpected null aggregation.");
                    this.listener.onResponse((Object)new SearchTopAnomalyResultResponse(new ArrayList<AnomalyResultBucket>()));
                    return;
                }
                Aggregation aggResults = aggs.get(SearchTopAnomalyResultTransportAction.MULTI_BUCKETS_FIELD);
                if (aggResults == null) {
                    this.listener.onFailure((Exception)new IllegalArgumentException("Failed to find valid aggregation result"));
                    return;
                }
                CompositeAggregation compositeAgg = (CompositeAggregation)aggResults;
                List bucketResults = compositeAgg.getBuckets().stream().map(bucket -> AnomalyResultBucket.createAnomalyResultBucket(bucket)).collect(Collectors.toList());
                this.topResultsHeap.addAll(bucketResults);
                while (this.topResultsHeap.size() > this.maxResults) {
                    this.topResultsHeap.poll();
                }
                Map afterKey = compositeAgg.afterKey();
                if (afterKey == null) {
                    this.listener.onResponse((Object)new SearchTopAnomalyResultResponse(SearchTopAnomalyResultTransportAction.this.getDescendingOrderListFromHeap(this.topResultsHeap)));
                } else if (this.expirationEpochMs < SearchTopAnomalyResultTransportAction.this.clock.millis()) {
                    if (this.topResultsHeap.isEmpty()) {
                        this.listener.onFailure((Exception)new TimeSeriesException("Timed out getting all top anomaly results. Please retry later."));
                    } else {
                        logger.info("Timed out getting all top anomaly results. Sending back partial results.");
                        this.listener.onResponse((Object)new SearchTopAnomalyResultResponse(SearchTopAnomalyResultTransportAction.this.getDescendingOrderListFromHeap(this.topResultsHeap)));
                    }
                } else {
                    CompositeAggregationBuilder aggBuilder = (CompositeAggregationBuilder)this.searchSourceBuilder.aggregations().getAggregatorFactories().iterator().next();
                    aggBuilder.aggregateAfter(afterKey);
                    SearchRequest searchRequest = Strings.isNullOrEmpty((String)this.customResultIndex) ? new SearchRequest().indices(new String[]{SearchTopAnomalyResultTransportAction.defaultIndex}) : new SearchRequest().indices(new String[]{SearchTopAnomalyResultTransportAction.defaultIndex, this.customResultIndex});
                    SearchTopAnomalyResultTransportAction.this.searchHandler.search(searchRequest.source(this.searchSourceBuilder), "anomaly-detector", this);
                }
            }
            catch (Exception e) {
                this.onFailure(e);
            }
        }

        public void onFailure(Exception e) {
            logger.error("Failed to paginate top anomaly results", (Throwable)e);
            this.listener.onFailure(e);
        }
    }
}

