/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.script.expression;

import java.io.IOException;
import java.util.Calendar;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DoubleValues;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.fielddata.LeafNumericFieldData;
import org.opensearch.index.fielddata.NumericDoubleValues;
import org.opensearch.script.expression.FieldDataValueSource;
import org.opensearch.search.MultiValueMode;

class DateMethodValueSource
extends FieldDataValueSource {
    final String methodName;
    final int calendarType;

    DateMethodValueSource(IndexFieldData<?> indexFieldData, MultiValueMode multiValueMode, String methodName, int calendarType) {
        super(indexFieldData, multiValueMode);
        Objects.requireNonNull(methodName);
        this.methodName = methodName;
        this.calendarType = calendarType;
    }

    @Override
    public DoubleValues getValues(LeafReaderContext leaf, DoubleValues scores) {
        LeafNumericFieldData leafData = (LeafNumericFieldData)this.fieldData.load(leaf);
        final Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ROOT);
        final NumericDoubleValues docValues = this.multiValueMode.select(leafData.getDoubleValues());
        return new DoubleValues(this){
            final /* synthetic */ DateMethodValueSource this$0;
            {
                this.this$0 = this$0;
            }

            public double doubleValue() throws IOException {
                calendar.setTimeInMillis((long)docValues.doubleValue());
                return calendar.get(this.this$0.calendarType);
            }

            public boolean advanceExact(int doc) throws IOException {
                return docValues.advanceExact(doc);
            }
        };
    }

    @Override
    public String toString() {
        return this.methodName + ": field(" + this.fieldData.getFieldName() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DateMethodValueSource that = (DateMethodValueSource)((Object)o);
        if (this.calendarType != that.calendarType) {
            return false;
        }
        return this.methodName.equals(that.methodName);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.methodName.hashCode();
        result = 31 * result + this.calendarType;
        return result;
    }
}

