/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.alerting.action;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.opensearch.commons.alerting.model.Alert;
import org.opensearch.commons.notifications.action.BaseResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B3\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\b\u0010\fJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0004H\u0002J\u0018\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0007H\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lorg/opensearch/commons/alerting/action/AcknowledgeAlertResponse;", "Lorg/opensearch/commons/notifications/action/BaseResponse;", "acknowledged", "", "Lorg/opensearch/commons/alerting/model/Alert;", "failed", "missing", "", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getAcknowledged", "()Ljava/util/List;", "getFailed", "getMissing", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "buildFailedAlertAcknowledgeObject", "failedAlert", "buildMissingAlertAcknowledgeObject", "alertID", "common-utils"})
@SourceDebugExtension(value={"SMAP\nAcknowledgeAlertResponse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AcknowledgeAlertResponse.kt\norg/opensearch/commons/alerting/action/AcknowledgeAlertResponse\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n1869#2,2:79\n1869#2,2:81\n1869#2,2:83\n*S KotlinDebug\n*F\n+ 1 AcknowledgeAlertResponse.kt\norg/opensearch/commons/alerting/action/AcknowledgeAlertResponse\n*L\n49#1:79,2\n51#1:81,2\n52#1:83,2\n*E\n"})
public final class AcknowledgeAlertResponse
extends BaseResponse {
    @NotNull
    private final List<Alert> acknowledged;
    @NotNull
    private final List<Alert> failed;
    @NotNull
    private final List<String> missing;

    @NotNull
    public final List<Alert> getAcknowledged() {
        return this.acknowledged;
    }

    @NotNull
    public final List<Alert> getFailed() {
        return this.failed;
    }

    @NotNull
    public final List<String> getMissing() {
        return this.missing;
    }

    public AcknowledgeAlertResponse(@NotNull List<Alert> acknowledged, @NotNull List<Alert> failed, @NotNull List<String> missing) {
        Intrinsics.checkNotNullParameter(acknowledged, (String)"acknowledged");
        Intrinsics.checkNotNullParameter(failed, (String)"failed");
        Intrinsics.checkNotNullParameter(missing, (String)"missing");
        this.acknowledged = acknowledged;
        this.failed = failed;
        this.missing = missing;
    }

    public AcknowledgeAlertResponse(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        List<Alert> list = Collections.unmodifiableList(sin.readList(Alert::new));
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(...)");
        List<Alert> list2 = Collections.unmodifiableList(sin.readList(Alert::new));
        Intrinsics.checkNotNullExpressionValue(list2, (String)"unmodifiableList(...)");
        List<String> list3 = Collections.unmodifiableList(sin.readStringList());
        Intrinsics.checkNotNullExpressionValue(list3, (String)"unmodifiableList(...)");
        this(list, list2, list3);
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeCollection((Collection)this.acknowledged);
        out.writeCollection((Collection)this.failed);
        out.writeStringCollection((Collection)this.missing);
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) throws IOException {
        Object it;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        builder.startObject().startArray("success");
        Iterable $this$forEach$iv = this.acknowledged;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Alert)element$iv;
            boolean bl = false;
            builder.value(((Alert)it).getId());
        }
        builder.endArray().startArray("failed");
        $this$forEach$iv = this.failed;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Alert)element$iv;
            boolean bl = false;
            this.buildFailedAlertAcknowledgeObject(builder, (Alert)it);
        }
        $this$forEach$iv = this.missing;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            this.buildMissingAlertAcknowledgeObject(builder, (String)it);
        }
        XContentBuilder xContentBuilder = builder.endArray().endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"endObject(...)");
        return xContentBuilder;
    }

    private final void buildFailedAlertAcknowledgeObject(XContentBuilder builder, Alert failedAlert) {
        builder.startObject().startObject(failedAlert.getId());
        String reason = switch (WhenMappings.$EnumSwitchMapping$0[failedAlert.getState().ordinal()]) {
            case 1 -> "Alert is in an error state and can not be acknowledged.";
            case 2 -> "Alert has already completed and can not be acknowledged.";
            case 3 -> "Alert has already been acknowledged.";
            default -> "Alert state unknown and can not be acknowledged";
        };
        builder.field("failed_reason", reason).endObject().endObject();
    }

    private final void buildMissingAlertAcknowledgeObject(XContentBuilder builder, String alertID) {
        builder.startObject().startObject(alertID).field("failed_reason", "Alert: " + alertID + " does not exist (it may have already completed).").endObject().endObject();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Alert.State.values().length];
            try {
                nArray[Alert.State.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Alert.State.COMPLETED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Alert.State.ACKNOWLEDGED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

