/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.notifications.model;

import java.io.IOException;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.commons.notifications.model.BaseModel;
import org.opensearch.commons.notifications.model.DeliveryStatus;
import org.opensearch.commons.utils.HelpersKt;
import org.opensearch.commons.utils.ValidationHelpersKt;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001c\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006#"}, d2={"Lorg/opensearch/commons/notifications/model/EmailRecipientStatus;", "Lorg/opensearch/commons/notifications/model/BaseModel;", "recipient", "", "deliveryStatus", "Lorg/opensearch/commons/notifications/model/DeliveryStatus;", "<init>", "(Ljava/lang/String;Lorg/opensearch/commons/notifications/model/DeliveryStatus;)V", "input", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getRecipient", "()Ljava/lang/String;", "getDeliveryStatus", "()Lorg/opensearch/commons/notifications/model/DeliveryStatus;", "writeTo", "", "output", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "common-utils"})
public final class EmailRecipientStatus
implements BaseModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String recipient;
    @NotNull
    private final DeliveryStatus deliveryStatus;
    @NotNull
    private static final Lazy<Logger> log$delegate = HelpersKt.logger(EmailRecipientStatus.class);
    @NotNull
    private static final Writeable.Reader<EmailRecipientStatus> reader = EmailRecipientStatus::reader$lambda$0;

    public EmailRecipientStatus(@NotNull String recipient, @NotNull DeliveryStatus deliveryStatus) {
        Intrinsics.checkNotNullParameter((Object)recipient, (String)"recipient");
        Intrinsics.checkNotNullParameter((Object)deliveryStatus, (String)"deliveryStatus");
        this.recipient = recipient;
        this.deliveryStatus = deliveryStatus;
        ValidationHelpersKt.validateEmail(this.recipient);
    }

    @NotNull
    public final String getRecipient() {
        return this.recipient;
    }

    @NotNull
    public final DeliveryStatus getDeliveryStatus() {
        return this.deliveryStatus;
    }

    public EmailRecipientStatus(@NotNull StreamInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String string = input.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
        Object object = DeliveryStatus.Companion.getReader().read(input);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"read(...)");
        this(string, (DeliveryStatus)object);
    }

    public void writeTo(@NotNull StreamOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.writeString(this.recipient);
        this.deliveryStatus.writeTo(output);
    }

    @NotNull
    public XContentBuilder toXContent(@Nullable XContentBuilder builder, @Nullable ToXContent.Params params) {
        Intrinsics.checkNotNull((Object)builder);
        XContentBuilder xContentBuilder = builder.startObject().field("recipient", this.recipient).field("delivery_status", (ToXContent)this.deliveryStatus).endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"endObject(...)");
        return xContentBuilder;
    }

    @NotNull
    public final String component1() {
        return this.recipient;
    }

    @NotNull
    public final DeliveryStatus component2() {
        return this.deliveryStatus;
    }

    @NotNull
    public final EmailRecipientStatus copy(@NotNull String recipient, @NotNull DeliveryStatus deliveryStatus) {
        Intrinsics.checkNotNullParameter((Object)recipient, (String)"recipient");
        Intrinsics.checkNotNullParameter((Object)deliveryStatus, (String)"deliveryStatus");
        return new EmailRecipientStatus(recipient, deliveryStatus);
    }

    public static /* synthetic */ EmailRecipientStatus copy$default(EmailRecipientStatus emailRecipientStatus, String string, DeliveryStatus deliveryStatus, int n, Object object) {
        if ((n & 1) != 0) {
            string = emailRecipientStatus.recipient;
        }
        if ((n & 2) != 0) {
            deliveryStatus = emailRecipientStatus.deliveryStatus;
        }
        return emailRecipientStatus.copy(string, deliveryStatus);
    }

    @NotNull
    public String toString() {
        return "EmailRecipientStatus(recipient=" + this.recipient + ", deliveryStatus=" + this.deliveryStatus + ")";
    }

    public int hashCode() {
        int result = this.recipient.hashCode();
        result = result * 31 + this.deliveryStatus.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EmailRecipientStatus)) {
            return false;
        }
        EmailRecipientStatus emailRecipientStatus = (EmailRecipientStatus)other;
        if (!Intrinsics.areEqual((Object)this.recipient, (Object)emailRecipientStatus.recipient)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.deliveryStatus, (Object)emailRecipientStatus.deliveryStatus);
    }

    private static final EmailRecipientStatus reader$lambda$0(StreamInput it) {
        Intrinsics.checkNotNull((Object)it);
        return new EmailRecipientStatus(it);
    }

    @JvmStatic
    @NotNull
    public static final EmailRecipientStatus parse(@NotNull XContentParser parser) throws IOException {
        return Companion.parse(parser);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001f\u0010\n\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lorg/opensearch/commons/notifications/model/EmailRecipientStatus$Companion;", "", "<init>", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "reader", "Lorg/opensearch/core/common/io/stream/Writeable$Reader;", "Lorg/opensearch/commons/notifications/model/EmailRecipientStatus;", "kotlin.jvm.PlatformType", "getReader", "()Lorg/opensearch/core/common/io/stream/Writeable$Reader;", "parse", "parser", "Lorg/opensearch/core/xcontent/XContentParser;", "common-utils"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Lazy lazy = log$delegate;
            return (Logger)lazy.getValue();
        }

        @NotNull
        public final Writeable.Reader<EmailRecipientStatus> getReader() {
            return reader;
        }

        @JvmStatic
        @NotNull
        public final EmailRecipientStatus parse(@NotNull XContentParser parser) throws IOException {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            String recipient = null;
            DeliveryStatus deliveryStatus = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = parser.currentName();
                parser.nextToken();
                String string = fieldName;
                if (Intrinsics.areEqual((Object)string, (Object)"recipient")) {
                    recipient = parser.text();
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"delivery_status")) {
                    deliveryStatus = DeliveryStatus.Companion.parse(parser);
                    continue;
                }
                parser.skipChildren();
                this.getLog().info("Unexpected field: " + fieldName + ", while parsing Email Recipient Status");
            }
            if (recipient == null) {
                throw new IllegalArgumentException("recipient field absent");
            }
            if (deliveryStatus == null) {
                throw new IllegalArgumentException("delivery_status field absent");
            }
            return new EmailRecipientStatus(recipient, deliveryStatus);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

