/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.anomaly;

import com.oracle.labs.mlrg.olcut.util.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.Output;
import org.tribuo.anomaly.AnomalyFactory;
import org.tribuo.anomaly.AnomalyInfo;
import org.tribuo.anomaly.Event;

public final class ImmutableAnomalyInfo
extends AnomalyInfo
implements ImmutableOutputInfo<Event> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(ImmutableAnomalyInfo.class.getName());

    ImmutableAnomalyInfo(AnomalyInfo info) {
        super(info);
    }

    public int getID(Event output) {
        return output.getType().getID();
    }

    public Event getOutput(int id) {
        if (id == Event.EventType.ANOMALOUS.getID()) {
            return AnomalyFactory.ANOMALOUS_EVENT;
        }
        if (id == Event.EventType.EXPECTED.getID()) {
            return AnomalyFactory.EXPECTED_EVENT;
        }
        logger.log(Level.INFO, "No entry found for id " + id);
        return null;
    }

    public long getTotalObservations() {
        return this.anomalyCount + this.expectedCount;
    }

    @Override
    public ImmutableAnomalyInfo copy() {
        return new ImmutableAnomalyInfo(this);
    }

    public Iterator<Pair<Integer, Event>> iterator() {
        ArrayList<Pair> list = new ArrayList<Pair>();
        list.add(new Pair((Object)AnomalyFactory.ANOMALOUS_EVENT.getType().getID(), (Object)AnomalyFactory.ANOMALOUS_EVENT));
        list.add(new Pair((Object)AnomalyFactory.EXPECTED_EVENT.getType().getID(), (Object)AnomalyFactory.EXPECTED_EVENT));
        return list.iterator();
    }

    public boolean domainAndIDEquals(ImmutableOutputInfo<Event> other) {
        if (other instanceof ImmutableAnomalyInfo) {
            return true;
        }
        return other.size() == 2 && other.getID((Output)AnomalyFactory.ANOMALOUS_EVENT) == AnomalyFactory.ANOMALOUS_EVENT.getType().getID() && other.getID((Output)AnomalyFactory.EXPECTED_EVENT) == AnomalyFactory.EXPECTED_EVENT.getType().getID();
    }
}

