/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.search;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.index.mapper.DerivedField;
import org.opensearch.protobufs.FieldAndFormat;
import org.opensearch.protobufs.Rescore;
import org.opensearch.protobufs.ScriptField;
import org.opensearch.protobufs.SearchRequestBody;
import org.opensearch.protobufs.TrackHits;
import org.opensearch.script.Script;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.SortBuilder;
import org.opensearch.transport.grpc.proto.request.common.FetchSourceContextProtoUtils;
import org.opensearch.transport.grpc.proto.request.common.ScriptProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.CollapseBuilderProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.DerivedFieldProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.HighlightBuilderProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.PointInTimeBuilderProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.RescorerBuilderProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.SearchAfterBuilderProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.SliceBuilderProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.StoredFieldsContextProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.query.AbstractQueryBuilderProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.sort.SortBuilderProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.suggest.SuggestBuilderProtoUtils;
import org.opensearch.transport.grpc.spi.QueryBuilderProtoConverterRegistry;

public class SearchSourceBuilderProtoUtils {
    private SearchSourceBuilderProtoUtils() {
    }

    public static void parseProto(SearchSourceBuilder searchSourceBuilder, SearchRequestBody protoRequest, AbstractQueryBuilderProtoUtils queryUtils) throws IOException {
        SearchSourceBuilderProtoUtils.parseNonQueryFields(searchSourceBuilder, protoRequest, queryUtils.getRegistry());
        if (protoRequest.hasQuery()) {
            searchSourceBuilder.query(queryUtils.parseInnerQueryBuilderProto(protoRequest.getQuery()));
        }
        if (protoRequest.hasPostFilter()) {
            searchSourceBuilder.postFilter(queryUtils.parseInnerQueryBuilderProto(protoRequest.getPostFilter()));
        }
    }

    private static void parseNonQueryFields(SearchSourceBuilder searchSourceBuilder, SearchRequestBody protoRequest, QueryBuilderProtoConverterRegistry registry) throws IOException {
        String name;
        if (protoRequest.hasFrom()) {
            searchSourceBuilder.from(protoRequest.getFrom());
        }
        if (protoRequest.hasSize()) {
            searchSourceBuilder.size(protoRequest.getSize());
        }
        if (protoRequest.hasTimeout()) {
            searchSourceBuilder.timeout(TimeValue.parseTimeValue((String)protoRequest.getTimeout(), null, (String)SearchSourceBuilder.TIMEOUT_FIELD.getPreferredName()));
        }
        if (protoRequest.hasTerminateAfter()) {
            searchSourceBuilder.terminateAfter(protoRequest.getTerminateAfter());
        }
        if (protoRequest.hasMinScore()) {
            searchSourceBuilder.minScore(protoRequest.getMinScore());
        }
        if (protoRequest.hasVersion()) {
            searchSourceBuilder.version(Boolean.valueOf(protoRequest.getVersion()));
        }
        if (protoRequest.hasSeqNoPrimaryTerm()) {
            searchSourceBuilder.seqNoAndPrimaryTerm(Boolean.valueOf(protoRequest.getSeqNoPrimaryTerm()));
        }
        if (protoRequest.hasExplain()) {
            searchSourceBuilder.explain(Boolean.valueOf(protoRequest.getExplain()));
        }
        if (protoRequest.hasTrackScores()) {
            searchSourceBuilder.trackScores(protoRequest.getTrackScores());
        }
        if (protoRequest.hasIncludeNamedQueriesScore()) {
            searchSourceBuilder.includeNamedQueriesScores(protoRequest.getIncludeNamedQueriesScore());
        }
        if (protoRequest.hasTrackTotalHits()) {
            if (protoRequest.getTrackTotalHits().getTrackHitsCase() == TrackHits.TrackHitsCase.ENABLED) {
                searchSourceBuilder.trackTotalHitsUpTo(protoRequest.getTrackTotalHits().getEnabled() ? Integer.MAX_VALUE : -1);
            } else if (protoRequest.getTrackTotalHits().getTrackHitsCase() == TrackHits.TrackHitsCase.COUNT) {
                searchSourceBuilder.trackTotalHitsUpTo(protoRequest.getTrackTotalHits().getCount());
            }
        }
        if (protoRequest.hasXSource()) {
            searchSourceBuilder.fetchSource(FetchSourceContextProtoUtils.fromProto(protoRequest.getXSource()));
        }
        if (protoRequest.getStoredFieldsCount() > 0) {
            searchSourceBuilder.storedFields(StoredFieldsContextProtoUtils.fromProto((List<String>)protoRequest.getStoredFieldsList()));
        }
        if (protoRequest.getSortCount() > 0) {
            for (SortBuilder<?> sortBuilder : SortBuilderProtoUtils.fromProto(protoRequest.getSortList(), registry)) {
                searchSourceBuilder.sort(sortBuilder);
            }
        }
        if (protoRequest.hasProfile()) {
            searchSourceBuilder.profile(protoRequest.getProfile());
        }
        if (protoRequest.hasSearchPipeline()) {
            searchSourceBuilder.pipeline(protoRequest.getSearchPipeline());
        }
        if (protoRequest.hasVerbosePipeline()) {
            searchSourceBuilder.verbosePipeline(Boolean.valueOf(protoRequest.getVerbosePipeline()));
        }
        if (protoRequest.hasXSource()) {
            searchSourceBuilder.fetchSource(FetchSourceContextProtoUtils.fromProto(protoRequest.getXSource()));
        }
        if (protoRequest.getScriptFieldsCount() > 0) {
            for (Map.Entry entry : protoRequest.getScriptFieldsMap().entrySet()) {
                name = (String)entry.getKey();
                ScriptField scriptFieldProto = (ScriptField)entry.getValue();
                SearchSourceBuilder.ScriptField scriptField = ScriptFieldProtoUtils.fromProto(name, scriptFieldProto);
                searchSourceBuilder.scriptField(name, scriptField.script(), scriptField.ignoreFailure());
            }
        }
        if (protoRequest.getIndicesBoostCount() > 0) {
            for (Map.Entry entry : protoRequest.getIndicesBoostMap().entrySet()) {
                searchSourceBuilder.indexBoost((String)entry.getKey(), ((Float)entry.getValue()).floatValue());
            }
        }
        if (protoRequest.hasHighlight()) {
            searchSourceBuilder.highlighter(HighlightBuilderProtoUtils.fromProto(protoRequest.getHighlight(), registry));
        }
        if (protoRequest.hasSuggest()) {
            searchSourceBuilder.suggest(SuggestBuilderProtoUtils.fromProto(protoRequest.getSuggest()));
        }
        if (protoRequest.getRescoreCount() > 0) {
            for (Rescore rescore : protoRequest.getRescoreList()) {
                searchSourceBuilder.addRescorer(RescorerBuilderProtoUtils.parseFromProto(rescore));
            }
        }
        if (protoRequest.hasExt()) {
            throw new UnsupportedOperationException("ext param is not supported yet");
        }
        if (protoRequest.hasSlice()) {
            searchSourceBuilder.slice(SliceBuilderProtoUtils.fromProto(protoRequest.getSlice()));
        }
        if (protoRequest.hasCollapse()) {
            searchSourceBuilder.collapse(CollapseBuilderProtoUtils.fromProto(protoRequest.getCollapse(), registry));
        }
        if (protoRequest.hasPit()) {
            searchSourceBuilder.pointInTimeBuilder(PointInTimeBuilderProtoUtils.fromProto(protoRequest.getPit()));
        }
        if (protoRequest.getDerivedCount() > 0) {
            for (Map.Entry entry : protoRequest.getDerivedMap().entrySet()) {
                org.opensearch.protobufs.DerivedField derivedFieldProto;
                name = (String)entry.getKey();
                DerivedField derivedField = DerivedFieldProtoUtils.fromProto(name, derivedFieldProto = (org.opensearch.protobufs.DerivedField)entry.getValue());
                if (derivedField.getProperties() != null || derivedField.getPrefilterField() != null || derivedField.getFormat() != null || derivedField.getIgnoreMalformed()) {
                    searchSourceBuilder.derivedField(derivedField.getName(), derivedField.getType(), derivedField.getScript(), derivedField.getProperties(), derivedField.getPrefilterField(), derivedField.getFormat(), derivedField.getIgnoreMalformed() ? Boolean.TRUE : null);
                    continue;
                }
                searchSourceBuilder.derivedField(derivedField.getName(), derivedField.getType(), derivedField.getScript());
            }
        }
        if (protoRequest.getDocvalueFieldsCount() > 0) {
            for (FieldAndFormat fieldAndFormat : protoRequest.getDocvalueFieldsList()) {
                searchSourceBuilder.docValueField(fieldAndFormat.getField(), fieldAndFormat.getFormat());
            }
        }
        if (protoRequest.getFieldsCount() > 0) {
            for (FieldAndFormat fieldAndFormat : protoRequest.getFieldsList()) {
                searchSourceBuilder.fetchField(fieldAndFormat.getField(), fieldAndFormat.getFormat());
            }
        }
        if (protoRequest.getStatsCount() > 0) {
            searchSourceBuilder.stats((List)protoRequest.getStatsList());
        }
        if (protoRequest.getSearchAfterCount() > 0) {
            searchSourceBuilder.searchAfter(SearchAfterBuilderProtoUtils.fromProto(protoRequest.getSearchAfterList()));
        }
    }

    public static class ScriptFieldProtoUtils {
        private ScriptFieldProtoUtils() {
        }

        public static SearchSourceBuilder.ScriptField fromProto(String scriptFieldName, ScriptField scriptFieldProto) throws IOException {
            Script script = ScriptProtoUtils.parseFromProtoRequest(scriptFieldProto.getScript());
            boolean ignoreFailure = scriptFieldProto.hasIgnoreFailure() ? scriptFieldProto.getIgnoreFailure() : false;
            return new SearchSourceBuilder.ScriptField(scriptFieldName, script, ignoreFailure);
        }
    }
}

