/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.streaming;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.MultiCollector;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.settings.Setting;
import org.opensearch.search.aggregations.AggregatorBase;
import org.opensearch.search.aggregations.MultiBucketCollector;
import org.opensearch.search.profile.aggregation.ProfilingAggregator;
import org.opensearch.search.streaming.FlushMode;
import org.opensearch.search.streaming.Streamable;
import org.opensearch.search.streaming.StreamingCostMetrics;

@ExperimentalApi
public final class FlushModeResolver {
    private static final Logger logger = LogManager.getLogger(FlushModeResolver.class);
    public static final Setting<Long> STREAMING_MAX_ESTIMATED_BUCKET_COUNT = Setting.longSetting("search.aggregations.streaming.max_estimated_bucket_count", 100000L, 1L, Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<Double> STREAMING_MIN_CARDINALITY_RATIO = Setting.doubleSetting("search.aggregations.streaming.min_cardinality_ratio", 0.01, 0.0, 1.0, Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<Long> STREAMING_MIN_ESTIMATED_BUCKET_COUNT = Setting.longSetting("search.aggregations.streaming.min_estimated_bucket_count", 1000L, 1L, Setting.Property.NodeScope, Setting.Property.Dynamic);

    public static FlushMode resolve(Collector collector, FlushMode defaultMode, long maxBucketCount, double minCardinalityRatio, long minBucketCount) {
        StreamingCostMetrics metrics = FlushModeResolver.collectMetrics(collector);
        FlushMode decision = FlushModeResolver.decideFlushMode(metrics, defaultMode, maxBucketCount, minCardinalityRatio, minBucketCount);
        logger.debug("Streaming decision: {} - Metrics: buckets={}, docs={}, topN={}, segments={}, cardinality_ratio={}, thresholds: max_buckets={}, min_buckets={}, min_cardinality_ratio={}", (Object)decision, (Object)metrics.estimatedBucketCount(), (Object)metrics.estimatedDocCount(), (Object)metrics.topNSize(), (Object)metrics.segmentCount(), (Object)(metrics.estimatedDocCount() > 0L ? (double)metrics.estimatedBucketCount() / (double)metrics.estimatedDocCount() : 0.0), (Object)maxBucketCount, (Object)minBucketCount, (Object)minCardinalityRatio);
        return decision;
    }

    private static StreamingCostMetrics collectMetrics(Collector collector) {
        StreamingCostMetrics nodeMetrics;
        if (!(collector instanceof Streamable || collector instanceof MultiBucketCollector || collector instanceof MultiCollector)) {
            return StreamingCostMetrics.nonStreamable();
        }
        if (collector instanceof Streamable) {
            Streamable streamable = (Streamable)collector;
            nodeMetrics = streamable.getStreamingCostMetrics();
            if (!nodeMetrics.isStreamable()) {
                return StreamingCostMetrics.nonStreamable();
            }
        } else {
            return StreamingCostMetrics.nonStreamable();
        }
        StreamingCostMetrics childMetrics = null;
        for (Collector child : FlushModeResolver.getChildren(collector)) {
            StreamingCostMetrics childResult = FlushModeResolver.collectMetrics(child);
            if (!childResult.isStreamable()) {
                return StreamingCostMetrics.nonStreamable();
            }
            childMetrics = childMetrics == null ? childResult : childMetrics.combineWithSibling(childResult);
        }
        return childMetrics != null ? nodeMetrics.combineWithSubAggregation(childMetrics) : nodeMetrics;
    }

    private static Collector[] getChildren(Collector collector) {
        Collector collector2 = collector;
        Objects.requireNonNull(collector2);
        Collector collector3 = collector2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AggregatorBase.class, MultiCollector.class, MultiBucketCollector.class, ProfilingAggregator.class}, (Object)collector3, n)) {
            case 0 -> {
                AggregatorBase aggregatorBase = (AggregatorBase)collector3;
                yield aggregatorBase.subAggregators();
            }
            case 1 -> {
                MultiCollector multiCollector = (MultiCollector)collector3;
                yield multiCollector.getCollectors();
            }
            case 2 -> {
                MultiBucketCollector multiBucketCollector = (MultiBucketCollector)collector3;
                yield multiBucketCollector.getCollectors();
            }
            case 3 -> {
                ProfilingAggregator profilingAggregator = (ProfilingAggregator)collector3;
                yield FlushModeResolver.getChildren(profilingAggregator.unwrapAggregator());
            }
            default -> new Collector[]{};
        };
    }

    private static FlushMode decideFlushMode(StreamingCostMetrics metrics, FlushMode defaultMode, long maxBucketCount, double minCardinalityRatio, long minBucketCount) {
        double cardinalityRatio;
        if (!metrics.isStreamable()) {
            return defaultMode;
        }
        if (metrics.estimatedBucketCount() > maxBucketCount) {
            return defaultMode;
        }
        if (metrics.estimatedBucketCount() < minBucketCount) {
            return defaultMode;
        }
        if (metrics.estimatedDocCount() > 0L && (cardinalityRatio = (double)metrics.estimatedBucketCount() / (double)metrics.estimatedDocCount()) < minCardinalityRatio) {
            return defaultMode;
        }
        return FlushMode.PER_SEGMENT;
    }
}

