/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.MultiCollector;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.lucene.MinimumScoreCollector;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.BucketCollector;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.MultiBucketCollector;
import org.opensearch.search.profile.query.InternalProfileCollector;

@PublicApi(since="2.10.0")
public class BucketCollectorProcessor {
    public void processPostCollection(Collector collectorTree) throws IOException {
        LinkedList<Collector> collectors = new LinkedList<Collector>();
        collectors.offer(collectorTree);
        while (!collectors.isEmpty()) {
            Collector currentCollector = (Collector)collectors.poll();
            if (currentCollector instanceof InternalProfileCollector) {
                InternalProfileCollector internalProfileCollector = (InternalProfileCollector)currentCollector;
                collectors.offer(internalProfileCollector.getCollector());
                continue;
            }
            if (currentCollector instanceof MinimumScoreCollector) {
                MinimumScoreCollector minimumScoreCollector = (MinimumScoreCollector)currentCollector;
                collectors.offer(minimumScoreCollector.getCollector());
                continue;
            }
            if (currentCollector instanceof MultiCollector) {
                MultiCollector multiCollector = (MultiCollector)currentCollector;
                for (Collector innerCollector : multiCollector.getCollectors()) {
                    collectors.offer(innerCollector);
                }
                continue;
            }
            if (!(currentCollector instanceof BucketCollector)) continue;
            BucketCollector bucketCollector = (BucketCollector)currentCollector;
            if (currentCollector instanceof Aggregator) {
                Aggregator aggregator = (Aggregator)currentCollector;
                bucketCollector.postCollection();
                aggregator.buildTopLevel();
                continue;
            }
            if (!(currentCollector instanceof MultiBucketCollector)) continue;
            MultiBucketCollector multiBucketCollector = (MultiBucketCollector)currentCollector;
            for (BucketCollector innerCollector : multiBucketCollector.getCollectors()) {
                collectors.offer(innerCollector);
            }
        }
    }

    @ExperimentalApi
    public List<InternalAggregation> buildAggBatch(Collector collectorTree) throws IOException {
        ArrayList<InternalAggregation> aggregations = new ArrayList<InternalAggregation>();
        LinkedList<Collector> collectors = new LinkedList<Collector>();
        collectors.offer(collectorTree);
        while (!collectors.isEmpty()) {
            Collector currentCollector = (Collector)collectors.poll();
            if (currentCollector instanceof InternalProfileCollector) {
                InternalProfileCollector internalProfileCollector = (InternalProfileCollector)currentCollector;
                collectors.offer(internalProfileCollector.getCollector());
                continue;
            }
            if (currentCollector instanceof MinimumScoreCollector) {
                MinimumScoreCollector minimumScoreCollector = (MinimumScoreCollector)currentCollector;
                collectors.offer(minimumScoreCollector.getCollector());
                continue;
            }
            if (currentCollector instanceof MultiCollector) {
                MultiCollector multiCollector = (MultiCollector)currentCollector;
                for (Collector innerCollector : multiCollector.getCollectors()) {
                    collectors.offer(innerCollector);
                }
                continue;
            }
            if (!(currentCollector instanceof BucketCollector)) continue;
            BucketCollector bucketCollector = (BucketCollector)currentCollector;
            if (currentCollector instanceof Aggregator) {
                Aggregator aggregator = (Aggregator)currentCollector;
                bucketCollector.postCollection();
                aggregations.add(aggregator.buildTopLevelBatch());
                continue;
            }
            if (!(currentCollector instanceof MultiBucketCollector)) continue;
            MultiBucketCollector multiBucketCollector = (MultiBucketCollector)currentCollector;
            for (BucketCollector innerCollector : multiBucketCollector.getCollectors()) {
                collectors.offer(innerCollector);
            }
        }
        return aggregations;
    }

    public List<Aggregator> toAggregators(Collection<Collector> collectors) {
        ArrayList<Aggregator> aggregators = new ArrayList<Aggregator>();
        LinkedList<Collector> allCollectors = new LinkedList<Collector>(collectors);
        while (!allCollectors.isEmpty()) {
            Collector currentCollector = (Collector)allCollectors.pop();
            if (currentCollector instanceof Aggregator) {
                Aggregator aggregator = (Aggregator)currentCollector;
                aggregators.add(aggregator);
                continue;
            }
            if (currentCollector instanceof InternalProfileCollector) {
                InternalProfileCollector internalProfileCollector = (InternalProfileCollector)currentCollector;
                Collector collector = internalProfileCollector.getCollector();
                if (collector instanceof Aggregator) {
                    Aggregator aggregator = (Aggregator)collector;
                    aggregators.add(aggregator);
                    continue;
                }
                collector = internalProfileCollector.getCollector();
                if (!(collector instanceof MultiBucketCollector)) continue;
                MultiBucketCollector multiBucketCollector = (MultiBucketCollector)collector;
                allCollectors.addAll(Arrays.asList(multiBucketCollector.getCollectors()));
                continue;
            }
            if (!(currentCollector instanceof MultiBucketCollector)) continue;
            MultiBucketCollector multiBucketCollector = (MultiBucketCollector)currentCollector;
            allCollectors.addAll(Arrays.asList(multiBucketCollector.getCollectors()));
        }
        return aggregators;
    }

    public List<InternalAggregation> toInternalAggregations(Collection<Collector> collectors) throws IOException {
        ArrayList<InternalAggregation> internalAggregations = new ArrayList<InternalAggregation>();
        LinkedList<Collector> allCollectors = new LinkedList<Collector>(collectors);
        while (!allCollectors.isEmpty()) {
            Collector currentCollector = (Collector)allCollectors.pop();
            if (currentCollector instanceof InternalProfileCollector) {
                InternalProfileCollector internalProfileCollector = (InternalProfileCollector)currentCollector;
                currentCollector = internalProfileCollector.getCollector();
            }
            if (currentCollector instanceof Aggregator) {
                Aggregator aggregator = (Aggregator)currentCollector;
                internalAggregations.add(aggregator.getPostCollectionAggregation());
                continue;
            }
            if (!(currentCollector instanceof MultiBucketCollector)) continue;
            MultiBucketCollector multiBucketCollector = (MultiBucketCollector)currentCollector;
            allCollectors.addAll(Arrays.asList(multiBucketCollector.getCollectors()));
        }
        return internalAggregations;
    }
}

