/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.LatchedActionListener;
import org.opensearch.common.blobstore.AsyncMultiStreamBlobContainer;
import org.opensearch.common.blobstore.BlobContainer;
import org.opensearch.common.blobstore.BlobMetadata;
import org.opensearch.common.blobstore.exception.CorruptFileException;
import org.opensearch.common.blobstore.stream.write.WriteContext;
import org.opensearch.common.blobstore.stream.write.WritePriority;
import org.opensearch.common.blobstore.transfer.RemoteTransferContainer;
import org.opensearch.common.blobstore.transfer.stream.OffsetRangeIndexInputStream;
import org.opensearch.common.blobstore.transfer.stream.OffsetRangeInputStream;
import org.opensearch.common.lucene.store.ByteArrayIndexInput;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.unit.ByteSizeUnit;
import org.opensearch.index.store.RemoteIndexInput;
import org.opensearch.index.store.RemoteIndexOutput;
import org.opensearch.index.store.exception.ChecksumCombinationException;

public class RemoteDirectory
extends Directory {
    protected final BlobContainer blobContainer;
    private static final Logger logger = LogManager.getLogger(RemoteDirectory.class);
    private final UnaryOperator<OffsetRangeInputStream> uploadRateLimiter;
    private final UnaryOperator<OffsetRangeInputStream> lowPriorityUploadRateLimiter;
    private final DownloadRateLimiterProvider downloadRateLimiterProvider;
    final Map<String, String> pendingDownloadMergedSegments;
    private static final int SEGMENT_CHECKSUM_BYTES = 8;

    public BlobContainer getBlobContainer() {
        return this.blobContainer;
    }

    public RemoteDirectory(BlobContainer blobContainer) {
        this(blobContainer, UnaryOperator.identity(), UnaryOperator.identity(), UnaryOperator.identity(), UnaryOperator.identity(), null);
    }

    public RemoteDirectory(BlobContainer blobContainer, UnaryOperator<OffsetRangeInputStream> uploadRateLimiter, UnaryOperator<OffsetRangeInputStream> lowPriorityUploadRateLimiter, UnaryOperator<InputStream> downloadRateLimiter, UnaryOperator<InputStream> lowPriorityDownloadRateLimiter, Map<String, String> pendingDownloadMergedSegments) {
        this.blobContainer = blobContainer;
        this.lowPriorityUploadRateLimiter = lowPriorityUploadRateLimiter;
        this.uploadRateLimiter = uploadRateLimiter;
        this.downloadRateLimiterProvider = new DownloadRateLimiterProvider(downloadRateLimiter, lowPriorityDownloadRateLimiter);
        this.pendingDownloadMergedSegments = pendingDownloadMergedSegments;
    }

    public String[] listAll() throws IOException {
        return (String[])this.blobContainer.listBlobs().keySet().stream().sorted().toArray(String[]::new);
    }

    public Collection<String> listFilesByPrefix(String filenamePrefix) throws IOException {
        return this.blobContainer.listBlobsByPrefix(filenamePrefix).keySet();
    }

    public List<String> listFilesByPrefixInLexicographicOrder(String filenamePrefix, int limit) throws IOException {
        final ArrayList<String> sortedBlobList = new ArrayList<String>();
        final AtomicReference exception = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(1);
        LatchedActionListener<List<BlobMetadata>> actionListener = new LatchedActionListener<List<BlobMetadata>>(new ActionListener<List<BlobMetadata>>(this){

            public void onResponse(List<BlobMetadata> blobMetadata) {
                sortedBlobList.addAll(blobMetadata.stream().map(BlobMetadata::name).collect(Collectors.toList()));
            }

            public void onFailure(Exception e) {
                exception.set(e);
            }
        }, latch);
        try {
            this.blobContainer.listBlobsByPrefixInSortedOrder(filenamePrefix, limit, BlobContainer.BlobNameSortOrder.LEXICOGRAPHIC, actionListener);
            latch.await();
        }
        catch (InterruptedException e) {
            throw new IOException("Exception in listFilesByPrefixInLexicographicOrder with prefix: " + filenamePrefix, e);
        }
        if (exception.get() != null) {
            throw new IOException((Throwable)exception.get());
        }
        return sortedBlobList;
    }

    public InputStream getBlobStream(String fileName) throws IOException {
        return this.blobContainer.readBlob(fileName);
    }

    public void deleteFile(String name) throws IOException {
        this.blobContainer.deleteBlobsIgnoringIfNotExists(Collections.singletonList(name));
    }

    public IndexOutput createOutput(String name, IOContext context) {
        return new RemoteIndexOutput(name, this.blobContainer);
    }

    public IndexInput openInput(String name, IOContext context) throws IOException {
        return this.openInput(name, this.fileLength(name), context);
    }

    public IndexInput openBlockInput(String name, long position, long length, long fileLength, IOContext context) throws IOException {
        try {
            return this.getBlockInput(name, position, length, fileLength);
        }
        catch (Exception e) {
            logger.error("Exception while reading blob for file: " + name + " for path " + String.valueOf(this.blobContainer.path()));
            throw e;
        }
    }

    public IndexInput openInput(String name, long fileLength, IOContext context) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = this.blobContainer.readBlob(name);
            UnaryOperator<InputStream> rateLimiter = this.downloadRateLimiterProvider.get(name);
            return new RemoteIndexInput(name, (InputStream)rateLimiter.apply(inputStream), fileLength);
        }
        catch (Exception e) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception closeEx) {
                    e.addSuppressed(closeEx);
                }
            }
            logger.error("Exception while reading blob for file: " + name + " for path " + String.valueOf(this.blobContainer.path()));
            throw e;
        }
    }

    public void close() throws IOException {
    }

    public long fileLength(String name) throws IOException {
        List<BlobMetadata> metadata = this.blobContainer.listBlobsByPrefixInSortedOrder(name, 1, BlobContainer.BlobNameSortOrder.LEXICOGRAPHIC);
        if (metadata.size() == 1 && metadata.get(0).name().equals(name)) {
            return metadata.get(0).length();
        }
        throw new NoSuchFileException(name);
    }

    public Set<String> getPendingDeletions() throws IOException {
        throw new UnsupportedOperationException();
    }

    public IndexOutput createTempOutput(String prefix, String suffix, IOContext context) {
        throw new UnsupportedOperationException();
    }

    public void sync(Collection<String> names) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void syncMetaData() {
        throw new UnsupportedOperationException();
    }

    public void rename(String source, String dest) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Lock obtainLock(String name) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void delete() throws IOException {
        this.blobContainer.delete();
    }

    public boolean copyFrom(Directory from, String src, String remoteFileName, IOContext context, Runnable postUploadRunner, ActionListener<Void> listener, boolean lowPriorityUpload) {
        if (this.blobContainer instanceof AsyncMultiStreamBlobContainer) {
            try {
                this.uploadBlob(from, src, remoteFileName, context, postUploadRunner, listener, lowPriorityUpload);
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
            return true;
        }
        return false;
    }

    private void uploadBlob(Directory from, String src, String remoteFileName, IOContext ioContext, Runnable postUploadRunner, ActionListener<Void> listener, boolean lowPriorityUpload) throws Exception {
        assert (ioContext != IOContext.READONCE) : "Remote upload will fail with IoContext.READONCE";
        long expectedChecksum = this.calculateChecksumOfChecksum(from, src);
        IndexInput indexInput = from.openInput(src, ioContext);
        try {
            long contentLength = indexInput.length();
            boolean remoteIntegrityEnabled = false;
            BlobContainer blobContainer = this.getBlobContainer();
            if (blobContainer instanceof AsyncMultiStreamBlobContainer) {
                AsyncMultiStreamBlobContainer asyncContainer = (AsyncMultiStreamBlobContainer)blobContainer;
                remoteIntegrityEnabled = asyncContainer.remoteIntegrityCheckSupported();
            }
            lowPriorityUpload = lowPriorityUpload || contentLength > ByteSizeUnit.GB.toBytes(15L);
            RemoteTransferContainer.OffsetRangeInputStreamSupplier offsetRangeInputStreamSupplier = lowPriorityUpload ? (size, position) -> (OffsetRangeInputStream)this.lowPriorityUploadRateLimiter.apply(new OffsetRangeIndexInputStream(indexInput.clone(), size, position)) : (size, position) -> (OffsetRangeInputStream)this.uploadRateLimiter.apply(new OffsetRangeIndexInputStream(indexInput.clone(), size, position));
            RemoteTransferContainer remoteTransferContainer = new RemoteTransferContainer(src, remoteFileName, contentLength, true, lowPriorityUpload ? WritePriority.LOW : WritePriority.NORMAL, offsetRangeInputStreamSupplier, expectedChecksum, remoteIntegrityEnabled);
            ActionListener completionListener = ActionListener.wrap(resp -> {
                try {
                    postUploadRunner.run();
                    listener.onResponse(null);
                }
                catch (Exception e) {
                    logger.error(() -> new ParameterizedMessage("Exception in segment postUpload for file [{}]", (Object)src), (Throwable)e);
                    listener.onFailure(e);
                }
            }, ex -> {
                logger.error(() -> new ParameterizedMessage("Failed to upload blob {}", (Object)src), (Throwable)ex);
                IOException corruptIndexException = ExceptionsHelper.unwrapCorruption((Throwable)ex);
                if (corruptIndexException != null) {
                    listener.onFailure((Exception)corruptIndexException);
                    return;
                }
                Throwable throwable = ExceptionsHelper.unwrap((Throwable)ex, (Class[])new Class[]{CorruptFileException.class});
                if (throwable != null) {
                    CorruptFileException corruptFileException = (CorruptFileException)throwable;
                    listener.onFailure((Exception)((Object)new CorruptIndexException(corruptFileException.getMessage(), corruptFileException.getFileName())));
                    return;
                }
                listener.onFailure(ex);
            });
            completionListener = ActionListener.runBefore((ActionListener)completionListener, () -> {
                try {
                    remoteTransferContainer.close();
                }
                catch (Exception e) {
                    logger.warn("Error occurred while closing streams", (Throwable)e);
                }
            });
            completionListener = ActionListener.runAfter((ActionListener)completionListener, () -> {
                try {
                    indexInput.close();
                }
                catch (IOException e) {
                    logger.warn("Error occurred while closing index input", (Throwable)e);
                }
            });
            WriteContext writeContext = remoteTransferContainer.createWriteContext();
            ((AsyncMultiStreamBlobContainer)this.blobContainer).asyncBlobUpload(writeContext, (ActionListener<Void>)completionListener);
        }
        catch (Exception e) {
            logger.warn("Exception while calling asyncBlobUpload, closing IndexInput to avoid leak");
            indexInput.close();
            throw e;
        }
    }

    private long calculateChecksumOfChecksum(Directory directory, String file) throws IOException {
        IndexInput indexInput = directory.openInput(file, IOContext.READONCE);
        try {
            long l = RemoteTransferContainer.checksumOfChecksum(indexInput, 8);
            return l;
        }
        catch (Exception e) {
            throw new ChecksumCombinationException("Potentially corrupted file: Checksum combination failed while combining stored checksum and calculated checksum of stored checksum in segment file: " + file + ", directory: " + String.valueOf(directory), file, e);
        }
        finally {
            if (indexInput != null) {
                try {
                    indexInput.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    private IndexInput getBlockInput(String name, long position, long length, long fileLength) throws IOException {
        byte[] bytes;
        if (position < 0L || length <= 0L || position + length > fileLength) {
            throw new IllegalArgumentException("Invalid values of block start and size");
        }
        try (InputStream inputStream = this.blobContainer.readBlob(name, position, length);){
            bytes = ((InputStream)this.downloadRateLimiterProvider.get(name).apply(inputStream)).readAllBytes();
        }
        return new ByteArrayIndexInput(name, bytes);
    }

    private boolean isMergedSegment(String remoteFilename) {
        return this.pendingDownloadMergedSegments != null && this.pendingDownloadMergedSegments.containsValue(remoteFilename);
    }

    private class DownloadRateLimiterProvider {
        private final UnaryOperator<InputStream> downloadRateLimiter;
        private final UnaryOperator<InputStream> lowPriorityDownloadRateLimiter;

        DownloadRateLimiterProvider(UnaryOperator<InputStream> downloadRateLimiter, UnaryOperator<InputStream> lowPriorityDownloadRateLimiter) {
            this.downloadRateLimiter = downloadRateLimiter;
            this.lowPriorityDownloadRateLimiter = lowPriorityDownloadRateLimiter;
        }

        public UnaryOperator<InputStream> get(String filename) {
            if (RemoteDirectory.this.isMergedSegment(filename)) {
                return this.lowPriorityDownloadRateLimiter;
            }
            return this.downloadRateLimiter;
        }
    }
}

