/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.Function;
import org.opensearch.OpenSearchException;
import org.opensearch.action.admin.indices.alias.IndicesAliasesClusterStateUpdateRequest;
import org.opensearch.cluster.AckedClusterStateUpdateTask;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ack.AckedRequest;
import org.opensearch.cluster.ack.ClusterStateUpdateResponse;
import org.opensearch.cluster.metadata.AliasAction;
import org.opensearch.cluster.metadata.AliasValidator;
import org.opensearch.cluster.metadata.IndexAbstraction;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.metadata.MetadataDeleteIndexService;
import org.opensearch.cluster.service.ClusterManagerTask;
import org.opensearch.cluster.service.ClusterManagerTaskThrottler;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Priority;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.index.Index;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.IndexService;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.IndicesService;
import org.opensearch.indices.cluster.IndicesClusterStateService;

public class MetadataIndexAliasesService {
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final AliasValidator aliasValidator;
    private final MetadataDeleteIndexService deleteIndexService;
    private final NamedXContentRegistry xContentRegistry;
    private final ClusterManagerTaskThrottler.ThrottlingKey indexAliasTaskKey;

    @Inject
    public MetadataIndexAliasesService(ClusterService clusterService, IndicesService indicesService, AliasValidator aliasValidator, MetadataDeleteIndexService deleteIndexService, NamedXContentRegistry xContentRegistry) {
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.aliasValidator = aliasValidator;
        this.deleteIndexService = deleteIndexService;
        this.xContentRegistry = xContentRegistry;
        this.indexAliasTaskKey = clusterService.registerClusterManagerTask(ClusterManagerTask.INDEX_ALIASES, true);
    }

    public void indicesAliases(final IndicesAliasesClusterStateUpdateRequest request, ActionListener<ClusterStateUpdateResponse> listener) {
        this.clusterService.submitStateUpdateTask("index-aliases", new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>(this, Priority.URGENT, (AckedRequest)request, listener){
            final /* synthetic */ MetadataIndexAliasesService this$0;
            {
                this.this$0 = this$0;
                super(priority, request2, listener);
            }

            @Override
            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }

            @Override
            public ClusterManagerTaskThrottler.ThrottlingKey getClusterManagerThrottlingKey() {
                return this.this$0.indexAliasTaskKey;
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                return this.this$0.applyAliasActions(currentState, request.actions());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterState applyAliasActions(ClusterState currentState, Iterable<AliasAction> actions) {
        ArrayList indicesToClose = new ArrayList();
        HashMap indices = new HashMap();
        try {
            ClusterState updatedState;
            boolean changed = false;
            HashSet<Index> indicesToDelete = new HashSet<Index>();
            for (AliasAction action : actions) {
                if (!action.removeIndex()) continue;
                IndexMetadata index = currentState.metadata().getIndices().get(action.getIndex());
                if (index == null) {
                    throw new IndexNotFoundException(action.getIndex());
                }
                this.validateAliasTargetIsNotDSBackingIndex(currentState, action);
                indicesToDelete.add(index.getIndex());
                changed = true;
            }
            if (changed) {
                currentState = this.deleteIndexService.deleteIndices(currentState, indicesToDelete);
            }
            Metadata.Builder metadata = Metadata.builder(currentState.metadata());
            HashSet<String> maybeModifiedIndices = new HashSet<String>();
            for (AliasAction action : actions) {
                if (action.removeIndex()) continue;
                IndexMetadata index = metadata.get(action.getIndex());
                if (index == null) {
                    throw new IndexNotFoundException(action.getIndex());
                }
                this.validateAliasTargetIsNotDSBackingIndex(currentState, action);
                AliasAction.NewAliasValidator newAliasValidator = (alias, indexRouting, filter, writeIndex) -> {
                    Function<String, IndexMetadata> indexLookup = name -> metadata.get((String)name);
                    this.aliasValidator.validateAlias(alias, action.getIndex(), indexRouting, indexLookup);
                    if (Strings.hasLength((String)filter)) {
                        IndicesClusterStateService.AllocatedIndex<IndexShard> indexService = (IndexService)indices.get(index.getIndex().getName());
                        if (indexService == null) {
                            indexService = this.indicesService.indexService(index.getIndex());
                            if (indexService == null) {
                                try {
                                    indexService = this.indicesService.createIndex(index, Collections.emptyList(), false);
                                    indicesToClose.add(index.getIndex());
                                }
                                catch (IOException e) {
                                    throw new OpenSearchException("Failed to create temporary index for parsing the alias", (Throwable)e, new Object[0]);
                                }
                                ((IndexService)indexService).mapperService().merge(index, MapperService.MergeReason.MAPPING_RECOVERY);
                            }
                            indices.put(action.getIndex(), indexService);
                        }
                        this.aliasValidator.validateAliasFilter(alias, filter, ((IndexService)indexService).newQueryShardContext(0, null, () -> System.currentTimeMillis(), null), this.xContentRegistry);
                    }
                };
                if (!action.apply(newAliasValidator, metadata, index)) continue;
                changed = true;
                maybeModifiedIndices.add(index.getIndex().getName());
            }
            for (String maybeModifiedIndex : maybeModifiedIndices) {
                IndexMetadata currentIndexMetadata = currentState.metadata().index(maybeModifiedIndex);
                IndexMetadata newIndexMetadata = metadata.get(maybeModifiedIndex);
                if (currentIndexMetadata.getAliases().equals(newIndexMetadata.getAliases())) continue;
                assert (currentIndexMetadata.getAliasesVersion() == newIndexMetadata.getAliasesVersion());
                metadata.put(new IndexMetadata.Builder(newIndexMetadata).aliasesVersion(1L + currentIndexMetadata.getAliasesVersion()));
            }
            if (changed && !(updatedState = ClusterState.builder(currentState).metadata(metadata).build()).metadata().equalsAliases(currentState.metadata())) {
                ClusterState clusterState = updatedState;
                return clusterState;
            }
            ClusterState clusterState = currentState;
            return clusterState;
        }
        finally {
            for (Index index : indicesToClose) {
                this.indicesService.removeIndex(index, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.NO_LONGER_ASSIGNED, "created for alias processing");
            }
        }
    }

    private void validateAliasTargetIsNotDSBackingIndex(ClusterState currentState, AliasAction action) {
        IndexAbstraction indexAbstraction = (IndexAbstraction)currentState.metadata().getIndicesLookup().get(action.getIndex());
        assert (indexAbstraction != null) : "invalid cluster metadata. index [" + action.getIndex() + "] was not found";
        if (indexAbstraction.getParentDataStream() != null) {
            throw new IllegalArgumentException("The provided index [ " + action.getIndex() + "] is a backing index belonging to data stream [" + indexAbstraction.getParentDataStream().getName() + "]. Data streams and their backing indices don't support alias operations.");
        }
    }
}

