/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.tools.cli.fips.truststore;

import java.nio.file.Path;
import java.util.concurrent.Callable;
import org.opensearch.tools.cli.fips.truststore.CommonOptions;
import org.opensearch.tools.cli.fips.truststore.ConfigurationService;
import org.opensearch.tools.cli.fips.truststore.TrustStoreService;
import org.opensearch.tools.cli.fips.truststore.UserInteractionService;
import picocli.CommandLine;

@CommandLine.Command(name="system", description={"Use existing system PKCS11 trust store"}, mixinStandardHelpOptions=true)
public class SystemTrustStoreCommand
implements Callable<Integer> {
    @CommandLine.Spec
    protected CommandLine.Model.CommandSpec spec;
    @CommandLine.Mixin
    protected CommonOptions common;
    @CommandLine.Option(names={"--pkcs11-provider"}, description={"Specify PKCS11 provider name directly"})
    private String preselectedPKCS11Provider;

    @Override
    public final Integer call() {
        Path confPath = Path.of(System.getProperty("opensearch.path.conf"), new String[0]);
        ConfigurationService.verifyJvmOptionsFile(this.spec, this.common, confPath);
        return new TrustStoreService(UserInteractionService.getInstance()).useSystemTrustStore(this.spec, this.common, this.preselectedPKCS11Provider, confPath);
    }
}

