/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.transportv2;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.alerting.AlertingV2Utils;
import org.opensearch.alerting.actionv2.SearchMonitorV2Request;
import org.opensearch.alerting.core.settings.AlertingV2Settings;
import org.opensearch.alerting.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.alerting.settings.AlertingSettings;
import org.opensearch.alerting.transport.SecureTransportAction;
import org.opensearch.alerting.transportv2.TransportSearchMonitorV2ActionKt;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.alerting.util.AlertingException;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B9\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J&\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00022\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00030(H\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0018\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001aX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001aX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u0006)"}, d2={"Lorg/opensearch/alerting/transportv2/TransportSearchMonitorV2Action;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/alerting/actionv2/SearchMonitorV2Request;", "Lorg/opensearch/action/search/SearchResponse;", "Lorg/opensearch/alerting/transport/SecureTransportAction;", "transportService", "Lorg/opensearch/transport/TransportService;", "settings", "Lorg/opensearch/common/settings/Settings;", "client", "Lorg/opensearch/transport/client/Client;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "namedWriteableRegistry", "Lorg/opensearch/core/common/io/stream/NamedWriteableRegistry;", "<init>", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/common/settings/Settings;Lorg/opensearch/transport/client/Client;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/core/common/io/stream/NamedWriteableRegistry;)V", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "getClient", "()Lorg/opensearch/transport/client/Client;", "getNamedWriteableRegistry", "()Lorg/opensearch/core/common/io/stream/NamedWriteableRegistry;", "alertingV2Enabled", "", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "filterByEnabled", "getFilterByEnabled", "()Z", "setFilterByEnabled", "(Z)V", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "request", "actionListener", "Lorg/opensearch/core/action/ActionListener;", "opensearch-alerting"})
public final class TransportSearchMonitorV2Action
extends HandledTransportAction<SearchMonitorV2Request, SearchResponse>
implements SecureTransportAction {
    @NotNull
    private final Settings settings;
    @NotNull
    private final Client client;
    @NotNull
    private final NamedWriteableRegistry namedWriteableRegistry;
    private volatile Boolean alertingV2Enabled;
    private volatile boolean filterByEnabled;

    @Inject
    public TransportSearchMonitorV2Action(@NotNull TransportService transportService, @NotNull Settings settings, @NotNull Client client, @NotNull ClusterService clusterService, @NotNull ActionFilters actionFilters, @NotNull NamedWriteableRegistry namedWriteableRegistry) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)namedWriteableRegistry, (String)"namedWriteableRegistry");
        super("cluster:admin/opensearch/alerting/v2/monitor/search", transportService, actionFilters, SearchMonitorV2Request::new);
        this.settings = settings;
        this.client = client;
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.alertingV2Enabled = (Boolean)AlertingV2Settings.Companion.getALERTING_V2_ENABLED().get(this.settings);
        Object object = AlertingSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(this.settings);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        this.filterByEnabled = (Boolean)object;
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingV2Settings.Companion.getALERTING_V2_ENABLED(), arg_0 -> TransportSearchMonitorV2Action._init_$lambda$0(this, arg_0));
        this.listenFilterBySettingChange(clusterService);
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final NamedWriteableRegistry getNamedWriteableRegistry() {
        return this.namedWriteableRegistry;
    }

    @Override
    public boolean getFilterByEnabled() {
        return this.filterByEnabled;
    }

    @Override
    public void setFilterByEnabled(boolean bl) {
        this.filterByEnabled = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@NotNull Task task, @NotNull SearchMonitorV2Request request, @NotNull ActionListener<SearchResponse> actionListener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        if (!this.alertingV2Enabled.booleanValue()) {
            actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Alerting V2 is currently disabled, please enable it with the cluster setting: " + AlertingV2Settings.Companion.getALERTING_V2_ENABLED().getKey(), RestStatus.FORBIDDEN, new Object[0])));
            return;
        }
        SearchSourceBuilder searchSourceBuilder = request.getSearchRequest().source();
        BoolQueryBuilder queryBuilder = searchSourceBuilder.query() == null ? new BoolQueryBuilder() : QueryBuilders.boolQuery().must(searchSourceBuilder.query());
        queryBuilder.filter((QueryBuilder)QueryBuilders.existsQuery((String)"monitor_v2"));
        searchSourceBuilder.query((QueryBuilder)queryBuilder).seqNoAndPrimaryTerm(Boolean.valueOf(true)).version(Boolean.valueOf(true));
        User user = this.readUserFromThreadContext(this.client);
        AutoCloseable autoCloseable = (AutoCloseable)this.client.threadPool().getThreadContext().stashContext();
        Throwable throwable = null;
        try {
            ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
            boolean bl = false;
            if (user != null && this.doFilterForUser(user)) {
                TransportSearchMonitorV2ActionKt.access$getLog$p().info("Filtering result by: " + user.getBackendRoles());
                SearchSourceBuilder searchSourceBuilder2 = request.getSearchRequest().source();
                Intrinsics.checkNotNullExpressionValue((Object)searchSourceBuilder2, (String)"source(...)");
                OpenSearchExtensionsKt.addFilter((User)user, (SearchSourceBuilder)searchSourceBuilder2, (String)"monitor_v2.ppl_monitor.user.backend_roles.keyword");
            }
            this.client.search(request.getSearchRequest(), (ActionListener)new ActionListener<SearchResponse>(actionListener){
                final /* synthetic */ ActionListener<SearchResponse> $actionListener;
                {
                    this.$actionListener = $actionListener;
                }

                public void onResponse(SearchResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    this.$actionListener.onResponse((Object)response2);
                }

                public void onFailure(Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (AlertingV2Utils.INSTANCE.isIndexNotFoundException(e)) {
                        TransportSearchMonitorV2ActionKt.access$getLog$p().error("Index not found while searching monitor", (Throwable)e);
                        SearchResponse emptyResponse = AlertingV2Utils.INSTANCE.getEmptySearchResponse();
                        this.$actionListener.onResponse((Object)emptyResponse);
                    } else {
                        TransportSearchMonitorV2ActionKt.access$getLog$p().error("Unexpected error while searching monitor", (Throwable)e);
                        this.$actionListener.onFailure((Exception)AlertingException.Companion.wrap(e));
                    }
                }
            });
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    public void listenFilterBySettingChange(@NotNull ClusterService clusterService) {
        SecureTransportAction.super.listenFilterBySettingChange(clusterService);
    }

    @Override
    @Nullable
    public User readUserFromThreadContext(@NotNull Client client) {
        return SecureTransportAction.super.readUserFromThreadContext(client);
    }

    @Override
    public boolean doFilterForUser(@Nullable User user) {
        return SecureTransportAction.super.doFilterForUser(user);
    }

    @Override
    public boolean isAdmin(@Nullable User user) {
        return SecureTransportAction.super.isAdmin(user);
    }

    @Override
    public <T> boolean validateUserBackendRoles(@Nullable User user, @NotNull ActionListener<T> actionListener) {
        return SecureTransportAction.super.validateUserBackendRoles(user, actionListener);
    }

    @Override
    public <T> boolean checkUserPermissionsWithResource(@Nullable User requesterUser, @Nullable User resourceUser, @NotNull ActionListener<T> actionListener, @NotNull String resourceType, @NotNull String resourceId) {
        return SecureTransportAction.super.checkUserPermissionsWithResource(requesterUser, resourceUser, actionListener, resourceType, resourceId);
    }

    private static final void _init_$lambda$0(TransportSearchMonitorV2Action this$0, Boolean it) {
        this$0.alertingV2Enabled = it;
    }
}

