/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.transportv2;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.alerting.AlertingV2Utils;
import org.opensearch.alerting.actionv2.GetMonitorV2Request;
import org.opensearch.alerting.actionv2.GetMonitorV2Response;
import org.opensearch.alerting.core.settings.AlertingV2Settings;
import org.opensearch.alerting.modelv2.MonitorV2;
import org.opensearch.alerting.settings.AlertingSettings;
import org.opensearch.alerting.transport.SecureTransportAction;
import org.opensearch.alerting.transportv2.TransportGetMonitorV2ActionKt;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.alerting.model.ScheduledJob;
import org.opensearch.commons.alerting.util.AlertingException;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B9\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J&\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00022\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00030(H\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0018\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001aX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001cR$\u0010\u001d\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001aX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001c\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u0006)"}, d2={"Lorg/opensearch/alerting/transportv2/TransportGetMonitorV2Action;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/alerting/actionv2/GetMonitorV2Request;", "Lorg/opensearch/alerting/actionv2/GetMonitorV2Response;", "Lorg/opensearch/alerting/transport/SecureTransportAction;", "transportService", "Lorg/opensearch/transport/TransportService;", "client", "Lorg/opensearch/transport/client/Client;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "settings", "Lorg/opensearch/common/settings/Settings;", "<init>", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/transport/client/Client;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/core/xcontent/NamedXContentRegistry;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/common/settings/Settings;)V", "getClient", "()Lorg/opensearch/transport/client/Client;", "getXContentRegistry", "()Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "alertingV2Enabled", "", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "filterByEnabled", "getFilterByEnabled", "()Ljava/lang/Boolean;", "setFilterByEnabled", "(Ljava/lang/Boolean;)V", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "request", "actionListener", "Lorg/opensearch/core/action/ActionListener;", "opensearch-alerting"})
public final class TransportGetMonitorV2Action
extends HandledTransportAction<GetMonitorV2Request, GetMonitorV2Response>
implements SecureTransportAction {
    @NotNull
    private final Client client;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    @NotNull
    private final ClusterService clusterService;
    private volatile Boolean alertingV2Enabled;
    private volatile Boolean filterByEnabled;

    @Inject
    public TransportGetMonitorV2Action(@NotNull TransportService transportService, @NotNull Client client, @NotNull ActionFilters actionFilters, @NotNull NamedXContentRegistry xContentRegistry, @NotNull ClusterService clusterService, @NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super("cluster:admin/opensearch/alerting/v2/monitor/get", transportService, actionFilters, GetMonitorV2Request::new);
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        this.alertingV2Enabled = (Boolean)AlertingV2Settings.Companion.getALERTING_V2_ENABLED().get(settings);
        this.filterByEnabled = (Boolean)AlertingSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingV2Settings.Companion.getALERTING_V2_ENABLED(), arg_0 -> TransportGetMonitorV2Action._init_$lambda$0(this, arg_0));
        this.listenFilterBySettingChange(this.clusterService);
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    public Boolean getFilterByEnabled() {
        return this.filterByEnabled;
    }

    public void setFilterByEnabled(Boolean bl) {
        this.filterByEnabled = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@NotNull Task task, @NotNull GetMonitorV2Request request, @NotNull ActionListener<GetMonitorV2Response> actionListener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        if (!this.alertingV2Enabled.booleanValue()) {
            actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Alerting V2 is currently disabled, please enable it with the cluster setting: " + AlertingV2Settings.Companion.getALERTING_V2_ENABLED().getKey(), RestStatus.FORBIDDEN, new Object[0])));
            return;
        }
        GetRequest getRequest = new GetRequest(".opendistro-alerting-config", request.getMonitorV2Id()).version(request.getVersion()).fetchSourceContext(request.getSrcContext());
        User user = this.readUserFromThreadContext(this.client);
        if (!this.validateUserBackendRoles(user, actionListener)) {
            return;
        }
        AutoCloseable autoCloseable = (AutoCloseable)this.client.threadPool().getThreadContext().stashContext();
        Throwable throwable = null;
        try {
            ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
            boolean bl = false;
            this.client.get(getRequest, (ActionListener)new ActionListener<GetResponse>(actionListener, this, user, request){
                final /* synthetic */ ActionListener<GetMonitorV2Response> $actionListener;
                final /* synthetic */ TransportGetMonitorV2Action this$0;
                final /* synthetic */ User $user;
                final /* synthetic */ GetMonitorV2Request $request;
                {
                    this.$actionListener = $actionListener;
                    this.this$0 = $receiver;
                    this.$user = $user;
                    this.$request = $request;
                }

                public void onResponse(GetResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    if (!response2.isExists()) {
                        this.$actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("MonitorV2 not found.", RestStatus.NOT_FOUND, new Object[0])));
                        return;
                    }
                    if (response2.isSourceEmpty()) {
                        this.$actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("MonitorV2 found but was empty.", RestStatus.NO_CONTENT, new Object[0])));
                        return;
                    }
                    XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)this.this$0.getXContentRegistry(), (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)response2.getSourceAsBytesRef(), (MediaType)((MediaType)XContentType.JSON));
                    Intrinsics.checkNotNull((Object)xcp);
                    String string = response2.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                    ScheduledJob scheduledJob2 = ScheduledJob.Companion.parse(xcp, string, response2.getVersion());
                    Exception exception = AlertingV2Utils.INSTANCE.validateMonitorV2(scheduledJob2);
                    if (exception != null) {
                        Exception exception2 = exception;
                        ActionListener<GetMonitorV2Response> actionListener = this.$actionListener;
                        Exception it = exception2;
                        boolean bl = false;
                        actionListener.onFailure((Exception)AlertingException.Companion.wrap(it));
                        return;
                    }
                    Intrinsics.checkNotNull((Object)scheduledJob2, (String)"null cannot be cast to non-null type org.opensearch.alerting.modelv2.MonitorV2");
                    MonitorV2 monitorV2 = (MonitorV2)scheduledJob2;
                    if (!this.this$0.checkUserPermissionsWithResource(this.$user, monitorV2.getUser(), this.$actionListener, "monitor", this.$request.getMonitorV2Id())) {
                        return;
                    }
                    String string2 = response2.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getId(...)");
                    this.$actionListener.onResponse((Object)((Object)new GetMonitorV2Response(string2, response2.getVersion(), response2.getSeqNo(), response2.getPrimaryTerm(), monitorV2)));
                }

                public void onFailure(Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (AlertingV2Utils.INSTANCE.isIndexNotFoundException(e)) {
                        TransportGetMonitorV2ActionKt.access$getLog$p().error("Index not found while getting monitor V2", (Throwable)e);
                        this.$actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Monitor V2 not found. Backing index is missing.", RestStatus.NOT_FOUND, (Throwable)e, new Object[0])));
                    } else {
                        TransportGetMonitorV2ActionKt.access$getLog$p().error("Unexpected error while getting monitor", (Throwable)e);
                        this.$actionListener.onFailure((Exception)AlertingException.Companion.wrap(e));
                    }
                }
            });
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    public void listenFilterBySettingChange(@NotNull ClusterService clusterService) {
        SecureTransportAction.super.listenFilterBySettingChange(clusterService);
    }

    @Override
    @Nullable
    public User readUserFromThreadContext(@NotNull Client client) {
        return SecureTransportAction.super.readUserFromThreadContext(client);
    }

    @Override
    public boolean doFilterForUser(@Nullable User user) {
        return SecureTransportAction.super.doFilterForUser(user);
    }

    @Override
    public boolean isAdmin(@Nullable User user) {
        return SecureTransportAction.super.isAdmin(user);
    }

    @Override
    public <T> boolean validateUserBackendRoles(@Nullable User user, @NotNull ActionListener<T> actionListener) {
        return SecureTransportAction.super.validateUserBackendRoles(user, actionListener);
    }

    @Override
    public <T> boolean checkUserPermissionsWithResource(@Nullable User requesterUser, @Nullable User resourceUser, @NotNull ActionListener<T> actionListener, @NotNull String resourceType, @NotNull String resourceId) {
        return SecureTransportAction.super.checkUserPermissionsWithResource(requesterUser, resourceUser, actionListener, resourceType, resourceId);
    }

    private static final void _init_$lambda$0(TransportGetMonitorV2Action this$0, Boolean it) {
        this$0.alertingV2Enabled = it;
    }
}

