/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.transportv2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.apache.lucene.search.TotalHits;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.alerting.actionv2.GetAlertsV2Request;
import org.opensearch.alerting.actionv2.GetAlertsV2Response;
import org.opensearch.alerting.core.settings.AlertingV2Settings;
import org.opensearch.alerting.modelv2.AlertV2;
import org.opensearch.alerting.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.alerting.settings.AlertingSettings;
import org.opensearch.alerting.transport.SecureTransportAction;
import org.opensearch.alerting.transportv2.TransportGetAlertsV2ActionKt;
import org.opensearch.alerting.util.AlertingUtilsKt;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.alerting.model.Table;
import org.opensearch.commons.alerting.util.AlertingException;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.Operator;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.FieldSortBuilder;
import org.opensearch.search.sort.SortBuilder;
import org.opensearch.search.sort.SortBuilders;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004BA\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J&\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00022\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00030,H\u0014J.\u0010-\u001a\u00020'2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00030,2\b\u00102\u001a\u0004\u0018\u000103J$\u00104\u001a\u00020'2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00030,R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0018\u0010\u001d\u001a\n \u001f*\u0004\u0018\u00010\u001e0\u001eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010 R$\u0010!\u001a\n \u001f*\u0004\u0018\u00010\u001e0\u001eX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010 \u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%\u00a8\u00065"}, d2={"Lorg/opensearch/alerting/transportv2/TransportGetAlertsV2Action;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/alerting/actionv2/GetAlertsV2Request;", "Lorg/opensearch/alerting/actionv2/GetAlertsV2Response;", "Lorg/opensearch/alerting/transport/SecureTransportAction;", "transportService", "Lorg/opensearch/transport/TransportService;", "client", "Lorg/opensearch/transport/client/Client;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "settings", "Lorg/opensearch/common/settings/Settings;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "namedWriteableRegistry", "Lorg/opensearch/core/common/io/stream/NamedWriteableRegistry;", "<init>", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/transport/client/Client;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/common/settings/Settings;Lorg/opensearch/core/xcontent/NamedXContentRegistry;Lorg/opensearch/core/common/io/stream/NamedWriteableRegistry;)V", "getClient", "()Lorg/opensearch/transport/client/Client;", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "getXContentRegistry", "()Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "getNamedWriteableRegistry", "()Lorg/opensearch/core/common/io/stream/NamedWriteableRegistry;", "alertingV2Enabled", "", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "filterByEnabled", "getFilterByEnabled", "()Ljava/lang/Boolean;", "setFilterByEnabled", "(Ljava/lang/Boolean;)V", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "getAlertsV2Request", "actionListener", "Lorg/opensearch/core/action/ActionListener;", "getAlerts", "alertIndex", "", "searchSourceBuilder", "Lorg/opensearch/search/builder/SearchSourceBuilder;", "user", "Lorg/opensearch/commons/authuser/User;", "search", "opensearch-alerting"})
@SourceDebugExtension(value={"SMAP\nTransportGetAlertsV2Action.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransportGetAlertsV2Action.kt\norg/opensearch/alerting/transportv2/TransportGetAlertsV2Action\n+ 2 AlertingUtils.kt\norg/opensearch/alerting/util/AlertingUtilsKt\n*L\n1#1,212:1\n173#2,8:213\n*S KotlinDebug\n*F\n+ 1 TransportGetAlertsV2Action.kt\norg/opensearch/alerting/transportv2/TransportGetAlertsV2Action\n*L\n145#1:213,8\n*E\n"})
public final class TransportGetAlertsV2Action
extends HandledTransportAction<GetAlertsV2Request, GetAlertsV2Response>
implements SecureTransportAction {
    @NotNull
    private final Client client;
    @NotNull
    private final Settings settings;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    @NotNull
    private final NamedWriteableRegistry namedWriteableRegistry;
    private volatile Boolean alertingV2Enabled;
    private volatile Boolean filterByEnabled;

    @Inject
    public TransportGetAlertsV2Action(@NotNull TransportService transportService, @NotNull Client client, @NotNull ClusterService clusterService, @NotNull ActionFilters actionFilters, @NotNull Settings settings, @NotNull NamedXContentRegistry xContentRegistry, @NotNull NamedWriteableRegistry namedWriteableRegistry) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        Intrinsics.checkNotNullParameter((Object)namedWriteableRegistry, (String)"namedWriteableRegistry");
        super("cluster:admin/opensearch/alerting/v2/alerts/get", transportService, actionFilters, GetAlertsV2Request::new);
        this.client = client;
        this.settings = settings;
        this.xContentRegistry = xContentRegistry;
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.alertingV2Enabled = (Boolean)AlertingV2Settings.Companion.getALERTING_V2_ENABLED().get(this.settings);
        this.filterByEnabled = (Boolean)AlertingSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(this.settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingV2Settings.Companion.getALERTING_V2_ENABLED(), arg_0 -> TransportGetAlertsV2Action._init_$lambda$0(this, arg_0));
        this.listenFilterBySettingChange(clusterService);
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    @NotNull
    public final NamedWriteableRegistry getNamedWriteableRegistry() {
        return this.namedWriteableRegistry;
    }

    public Boolean getFilterByEnabled() {
        return this.filterByEnabled;
    }

    public void setFilterByEnabled(Boolean bl) {
        this.filterByEnabled = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@NotNull Task task, @NotNull GetAlertsV2Request getAlertsV2Request, @NotNull ActionListener<GetAlertsV2Response> actionListener) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)getAlertsV2Request), (String)"getAlertsV2Request");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        if (!this.alertingV2Enabled.booleanValue()) {
            actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Alerting V2 is currently disabled, please enable it with the cluster setting: " + AlertingV2Settings.Companion.getALERTING_V2_ENABLED().getKey(), RestStatus.FORBIDDEN, new Object[0])));
            return;
        }
        User user = this.readUserFromThreadContext(this.client);
        Table tableProp = getAlertsV2Request.getTable();
        FieldSortBuilder sortBuilder = (FieldSortBuilder)SortBuilders.fieldSort((String)tableProp.getSortString()).order(SortOrder.fromString((String)tableProp.getSortOrder()));
        CharSequence charSequence = tableProp.getMissing();
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            sortBuilder.missing((Object)tableProp.getMissing());
        }
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        if (!Intrinsics.areEqual((Object)getAlertsV2Request.getSeverityLevel(), (Object)"ALL")) {
            queryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"severity", (String)getAlertsV2Request.getSeverityLevel()));
        }
        if (!((object = (Collection)getAlertsV2Request.getMonitorV2Ids()) == null || object.isEmpty())) {
            queryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)"monitor_v2_id", (Collection)getAlertsV2Request.getMonitorV2Ids()));
        }
        if (!((object = (CharSequence)tableProp.getSearchString()) == null || StringsKt.isBlank((CharSequence)object))) {
            queryBuilder.must((QueryBuilder)QueryBuilders.queryStringQuery((String)tableProp.getSearchString()).defaultOperator(Operator.AND).field("monitor_v2_name").field("trigger_v2_name"));
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().version(Boolean.valueOf(true)).seqNoAndPrimaryTerm(Boolean.valueOf(true)).query((QueryBuilder)queryBuilder).sort((SortBuilder)sortBuilder).size(tableProp.getSize()).from(tableProp.getStartIndex());
        ThreadContext.StoredContext $this$use$iv = this.client.threadPool().getThreadContext().stashContext();
        boolean $i$f$use = false;
        Throwable exception$iv = null;
        try {
            ThreadContext.StoredContext it = $this$use$iv;
            boolean bl = false;
            Job job = BuildersKt.launch$default((CoroutineScope)TransportGetAlertsV2ActionKt.access$getScope$p(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, searchSourceBuilder, actionListener, user, null){
                int label;
                final /* synthetic */ TransportGetAlertsV2Action this$0;
                final /* synthetic */ SearchSourceBuilder $searchSourceBuilder;
                final /* synthetic */ ActionListener<GetAlertsV2Response> $actionListener;
                final /* synthetic */ User $user;
                {
                    this.this$0 = $receiver;
                    this.$searchSourceBuilder = $searchSourceBuilder;
                    this.$actionListener = $actionListener;
                    this.$user = $user;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            try {
                                SearchSourceBuilder searchSourceBuilder = this.$searchSourceBuilder;
                                Intrinsics.checkNotNull((Object)searchSourceBuilder);
                                this.this$0.getAlerts(".opensearch-alerting-v2-alerts", searchSourceBuilder, this.$actionListener, this.$user);
                            }
                            catch (Exception t) {
                                TransportGetAlertsV2ActionKt.access$getLog$p().error("Failed to get alerts", (Throwable)t);
                                if (t instanceof AlertingException) {
                                    this.$actionListener.onFailure(t);
                                }
                                this.$actionListener.onFailure((Exception)AlertingException.Companion.wrap(t));
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
        catch (Throwable e$iv) {
            exception$iv = e$iv;
            throw e$iv;
        }
        finally {
            AlertingUtilsKt.closeFinally($this$use$iv, exception$iv);
        }
    }

    public final void getAlerts(@NotNull String alertIndex, @NotNull SearchSourceBuilder searchSourceBuilder, @NotNull ActionListener<GetAlertsV2Response> actionListener, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)alertIndex, (String)"alertIndex");
        Intrinsics.checkNotNullParameter((Object)searchSourceBuilder, (String)"searchSourceBuilder");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        try {
            if (user != null && this.doFilterForUser(user)) {
                TransportGetAlertsV2ActionKt.access$getLog$p().info("Filtering result by: " + user.getBackendRoles());
                OpenSearchExtensionsKt.addFilter((User)user, (SearchSourceBuilder)searchSourceBuilder, (String)"monitor_v2_user.backend_roles.keyword");
            }
            this.search(alertIndex, searchSourceBuilder, actionListener);
        }
        catch (IOException ex) {
            actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)ex));
        }
    }

    public final void search(@NotNull String alertIndex, @NotNull SearchSourceBuilder searchSourceBuilder, @NotNull ActionListener<GetAlertsV2Response> actionListener) {
        Intrinsics.checkNotNullParameter((Object)alertIndex, (String)"alertIndex");
        Intrinsics.checkNotNullParameter((Object)searchSourceBuilder, (String)"searchSourceBuilder");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        String[] stringArray = new String[]{alertIndex};
        SearchRequest searchRequest = new SearchRequest().indices(stringArray).source(searchSourceBuilder);
        this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(actionListener, this){
            final /* synthetic */ ActionListener<GetAlertsV2Response> $actionListener;
            final /* synthetic */ TransportGetAlertsV2Action this$0;
            {
                this.$actionListener = $actionListener;
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public void onResponse(SearchResponse response2) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                TotalHits totalHits = response2.getHits().getTotalHits();
                Integer totalAlertCount = totalHits != null ? Integer.valueOf((int)totalHits.value()) : null;
                SearchHits searchHits = response2.getHits();
                Intrinsics.checkNotNullExpressionValue((Object)searchHits, (String)"getHits(...)");
                Iterable iterable = (Iterable)searchHits;
                TransportGetAlertsV2Action transportGetAlertsV2Action = this.this$0;
                boolean $i$f$map = false;
                void var7_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void hit;
                    SearchHit searchHit = (SearchHit)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)transportGetAlertsV2Action.getXContentRegistry(), (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)hit.getSourceRef(), (MediaType)((MediaType)XContentType.JSON));
                    Intrinsics.checkNotNull((Object)xcp);
                    String string = hit.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                    AlertV2 alertV2 = AlertV2.Companion.parse(xcp, string, hit.getVersion());
                    collection.add(alertV2);
                }
                List alerts = (List)destination$iv$iv;
                this.$actionListener.onResponse((Object)((Object)new GetAlertsV2Response(alerts, totalAlertCount)));
            }

            public void onFailure(Exception t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                this.$actionListener.onFailure(t);
            }
        });
    }

    @Override
    public void listenFilterBySettingChange(@NotNull ClusterService clusterService) {
        SecureTransportAction.super.listenFilterBySettingChange(clusterService);
    }

    @Override
    @Nullable
    public User readUserFromThreadContext(@NotNull Client client) {
        return SecureTransportAction.super.readUserFromThreadContext(client);
    }

    @Override
    public boolean doFilterForUser(@Nullable User user) {
        return SecureTransportAction.super.doFilterForUser(user);
    }

    @Override
    public boolean isAdmin(@Nullable User user) {
        return SecureTransportAction.super.isAdmin(user);
    }

    @Override
    public <T> boolean validateUserBackendRoles(@Nullable User user, @NotNull ActionListener<T> actionListener) {
        return SecureTransportAction.super.validateUserBackendRoles(user, actionListener);
    }

    @Override
    public <T> boolean checkUserPermissionsWithResource(@Nullable User requesterUser, @Nullable User resourceUser, @NotNull ActionListener<T> actionListener, @NotNull String resourceType, @NotNull String resourceId) {
        return SecureTransportAction.super.checkUserPermissionsWithResource(requesterUser, resourceUser, actionListener, resourceType, resourceId);
    }

    private static final void _init_$lambda$0(TransportGetAlertsV2Action this$0, Boolean it) {
        this$0.alertingV2Enabled = it;
    }
}

