/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.transport;

import java.io.Closeable;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.alerting.action.GetEmailAccountRequest;
import org.opensearch.alerting.action.GetEmailAccountResponse;
import org.opensearch.alerting.model.destination.email.EmailAccount;
import org.opensearch.alerting.settings.DestinationSettings;
import org.opensearch.alerting.util.AlertingUtilsKt;
import org.opensearch.alerting.util.DestinationType;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.alerting.util.AlertingException;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B9\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J&\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00022\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\"H\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\"\u0010\u0018\u001a\u0016\u0012\u0004\u0012\u00020\u001a \u001b*\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00190\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/opensearch/alerting/transport/TransportGetEmailAccountAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/alerting/action/GetEmailAccountRequest;", "Lorg/opensearch/alerting/action/GetEmailAccountResponse;", "transportService", "Lorg/opensearch/transport/TransportService;", "client", "Lorg/opensearch/transport/client/Client;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "settings", "Lorg/opensearch/common/settings/Settings;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "<init>", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/transport/client/Client;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/common/settings/Settings;Lorg/opensearch/core/xcontent/NamedXContentRegistry;)V", "getClient", "()Lorg/opensearch/transport/client/Client;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "getXContentRegistry", "()Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "allowList", "", "", "kotlin.jvm.PlatformType", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "getEmailAccountRequest", "actionListener", "Lorg/opensearch/core/action/ActionListener;", "opensearch-alerting"})
@SourceDebugExtension(value={"SMAP\nTransportGetEmailAccountAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransportGetEmailAccountAction.kt\norg/opensearch/alerting/transport/TransportGetEmailAccountAction\n+ 2 AlertingUtils.kt\norg/opensearch/alerting/util/AlertingUtilsKt\n*L\n1#1,116:1\n173#2,8:117\n*S KotlinDebug\n*F\n+ 1 TransportGetEmailAccountAction.kt\norg/opensearch/alerting/transport/TransportGetEmailAccountAction\n*L\n76#1:117,8\n*E\n"})
public final class TransportGetEmailAccountAction
extends HandledTransportAction<GetEmailAccountRequest, GetEmailAccountResponse> {
    @NotNull
    private final Client client;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    private volatile List<String> allowList;

    @Inject
    public TransportGetEmailAccountAction(@NotNull TransportService transportService, @NotNull Client client, @NotNull ActionFilters actionFilters, @NotNull ClusterService clusterService, @NotNull Settings settings, @NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        super("cluster:admin/opendistro/alerting/destination/email_account/get", transportService, actionFilters, GetEmailAccountRequest::new);
        this.client = client;
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        this.allowList = (List)DestinationSettings.Companion.getALLOW_LIST().get(settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(DestinationSettings.Companion.getALLOW_LIST(), arg_0 -> TransportGetEmailAccountAction._init_$lambda$0(this, arg_0));
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@NotNull Task task, @NotNull GetEmailAccountRequest getEmailAccountRequest, @NotNull ActionListener<GetEmailAccountResponse> actionListener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)getEmailAccountRequest), (String)"getEmailAccountRequest");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        if (!this.allowList.contains(DestinationType.EMAIL.getValue())) {
            actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("This API is blocked since Destination type [" + DestinationType.EMAIL + "] is not allowed", RestStatus.FORBIDDEN, new Object[0])));
            return;
        }
        GetRequest getRequest = new GetRequest(".opendistro-alerting-config", getEmailAccountRequest.getEmailAccountID()).version(getEmailAccountRequest.getVersion()).fetchSourceContext(getEmailAccountRequest.getSrcContext());
        ThreadContext.StoredContext $this$use$iv = this.client.threadPool().getThreadContext().stashContext();
        boolean $i$f$use = false;
        Throwable exception$iv = null;
        try {
            ThreadContext.StoredContext it = $this$use$iv;
            boolean bl = false;
            this.client.get(getRequest, (ActionListener)new ActionListener<GetResponse>(actionListener, this){
                final /* synthetic */ ActionListener<GetEmailAccountResponse> $actionListener;
                final /* synthetic */ TransportGetEmailAccountAction this$0;
                {
                    this.$actionListener = $actionListener;
                    this.this$0 = $receiver;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onResponse(GetResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    if (!response2.isExists()) {
                        this.$actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Email Account not found.", RestStatus.NOT_FOUND, new Object[0])));
                        return;
                    }
                    EmailAccount emailAccount = null;
                    if (!response2.isSourceEmpty()) {
                        Closeable closeable = (Closeable)XContentHelper.createParser((NamedXContentRegistry)this.this$0.getXContentRegistry(), (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)response2.getSourceAsBytesRef(), (MediaType)((MediaType)XContentType.JSON));
                        Throwable throwable = null;
                        try {
                            XContentParser xcp = (XContentParser)closeable;
                            boolean bl = false;
                            Intrinsics.checkNotNull((Object)xcp);
                            String string = response2.getId();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                            emailAccount = EmailAccount.Companion.parseWithType(xcp, string, response2.getVersion());
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                    }
                    String string = response2.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                    this.$actionListener.onResponse((Object)((Object)new GetEmailAccountResponse(string, response2.getVersion(), response2.getSeqNo(), response2.getPrimaryTerm(), RestStatus.OK, emailAccount)));
                }

                public void onFailure(Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.$actionListener.onFailure(e);
                }
            });
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            exception$iv = e$iv;
            throw e$iv;
        }
        finally {
            AlertingUtilsKt.closeFinally($this$use$iv, exception$iv);
        }
    }

    private static final void _init_$lambda$0(TransportGetEmailAccountAction this$0, List it) {
        this$0.allowList = it;
    }
}

