/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.resthandler;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionRequest;
import org.opensearch.alerting.AlertingPlugin;
import org.opensearch.alerting.util.RestHandlerUtilsKt;
import org.opensearch.commons.alerting.action.AlertingActions;
import org.opensearch.commons.alerting.action.GetWorkflowRequest;
import org.opensearch.core.action.ActionListener;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.transport.client.node.NodeClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/opensearch/alerting/resthandler/RestGetWorkflowAction;", "Lorg/opensearch/rest/BaseRestHandler;", "<init>", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "getName", "", "routes", "", "Lorg/opensearch/rest/RestHandler$Route;", "prepareRequest", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/opensearch/rest/RestRequest;", "client", "Lorg/opensearch/transport/client/node/NodeClient;", "opensearch-alerting"})
public final class RestGetWorkflowAction
extends BaseRestHandler {
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());

    @NotNull
    public String getName() {
        return "get_workflow_action";
    }

    @NotNull
    public List<RestHandler.Route> routes() {
        return CollectionsKt.listOf((Object)new RestHandler.Route(RestRequest.Method.GET, AlertingPlugin.WORKFLOW_BASE_URI + "/{workflowID}"));
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.log.debug(request.method() + " " + AlertingPlugin.WORKFLOW_BASE_URI + "/{workflowID}");
        String workflowId = request.param("workflowID");
        if (workflowId == null || ((CharSequence)workflowId).length() == 0) {
            throw new IllegalArgumentException("missing id");
        }
        FetchSourceContext srcContext = RestHandlerUtilsKt.context(request);
        if (request.method() == RestRequest.Method.HEAD) {
            srcContext = FetchSourceContext.DO_NOT_FETCH_SOURCE;
        }
        RestRequest.Method method = request.method();
        Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method(...)");
        GetWorkflowRequest getWorkflowRequest = new GetWorkflowRequest(workflowId, method);
        return arg_0 -> RestGetWorkflowAction.prepareRequest$lambda$0(client, getWorkflowRequest, arg_0);
    }

    private static final void prepareRequest$lambda$0(NodeClient $client, GetWorkflowRequest $getWorkflowRequest, RestChannel channel) {
        $client.execute(AlertingActions.GET_WORKFLOW_ACTION_TYPE, (ActionRequest)$getWorkflowRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

