/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.alerting.chainedAlertCondition.parsers.ChainedAlertExpressionParser;
import org.opensearch.alerting.chainedAlertCondition.resolvers.ChainedAlertRPNResolver;
import org.opensearch.alerting.model.AlertContext;
import org.opensearch.alerting.script.BucketLevelTriggerExecutionContext;
import org.opensearch.alerting.script.ChainedAlertTriggerExecutionContext;
import org.opensearch.alerting.script.QueryLevelTriggerExecutionContext;
import org.opensearch.alerting.script.TriggerScript;
import org.opensearch.alerting.triggercondition.parsers.TriggerExpressionParser;
import org.opensearch.alerting.util.AlertingUtilsKt;
import org.opensearch.alerting.util.CrossClusterMonitorUtils;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.commons.alerting.model.AggregationResultBucket;
import org.opensearch.commons.alerting.model.Alert;
import org.opensearch.commons.alerting.model.BucketLevelTrigger;
import org.opensearch.commons.alerting.model.BucketLevelTriggerRunResult;
import org.opensearch.commons.alerting.model.ChainedAlertTrigger;
import org.opensearch.commons.alerting.model.ChainedAlertTriggerRunResult;
import org.opensearch.commons.alerting.model.ClusterMetricsTriggerRunResult;
import org.opensearch.commons.alerting.model.DocLevelQuery;
import org.opensearch.commons.alerting.model.DocumentLevelTrigger;
import org.opensearch.commons.alerting.model.DocumentLevelTriggerRunResult;
import org.opensearch.commons.alerting.model.Monitor;
import org.opensearch.commons.alerting.model.QueryLevelTrigger;
import org.opensearch.commons.alerting.model.QueryLevelTriggerRunResult;
import org.opensearch.commons.alerting.model.Workflow;
import org.opensearch.commons.alerting.model.WorkflowRunContext;
import org.opensearch.script.Script;
import org.opensearch.script.ScriptService;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.support.AggregationPath;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u0016\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0018J\u001e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u0011J&\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!J0\u0010\"\u001a\u00020#2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020$2\u0018\u0010%\u001a\u0014\u0012\u0004\u0012\u00020'\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0(0&J>\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020,2\u0006\u0010\u001c\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020)0(2\u0018\u0010/\u001a\u0014\u0012\u0004\u0012\u00020)\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0(0&J\u001e\u00100\u001a\u0002012\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u0002022\u0006\u0010\u0010\u001a\u000203J\"\u00104\u001a\b\u0012\u0004\u0012\u00020)052\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u00010&H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/opensearch/alerting/TriggerService;", "", "scriptService", "Lorg/opensearch/script/ScriptService;", "<init>", "(Lorg/opensearch/script/ScriptService;)V", "getScriptService", "()Lorg/opensearch/script/ScriptService;", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "ALWAYS_RUN", "Lorg/opensearch/script/Script;", "NEVER_RUN", "isQueryLevelTriggerActionable", "", "ctx", "Lorg/opensearch/alerting/script/QueryLevelTriggerExecutionContext;", "result", "Lorg/opensearch/commons/alerting/model/QueryLevelTriggerRunResult;", "workflowRunContext", "Lorg/opensearch/commons/alerting/model/WorkflowRunContext;", "isChainedAlertTriggerActionable", "Lorg/opensearch/alerting/script/ChainedAlertTriggerExecutionContext;", "Lorg/opensearch/commons/alerting/model/ChainedAlertTriggerRunResult;", "runQueryLevelTrigger", "monitor", "Lorg/opensearch/commons/alerting/model/Monitor;", "trigger", "Lorg/opensearch/commons/alerting/model/QueryLevelTrigger;", "runClusterMetricsTrigger", "Lorg/opensearch/commons/alerting/model/ClusterMetricsTriggerRunResult;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "runDocLevelTrigger", "Lorg/opensearch/commons/alerting/model/DocumentLevelTriggerRunResult;", "Lorg/opensearch/commons/alerting/model/DocumentLevelTrigger;", "queryToDocIds", "", "Lorg/opensearch/commons/alerting/model/DocLevelQuery;", "", "", "runChainedAlertTrigger", "workflow", "Lorg/opensearch/commons/alerting/model/Workflow;", "Lorg/opensearch/commons/alerting/model/ChainedAlertTrigger;", "alertGeneratingMonitors", "monitorIdToAlertIdsMap", "runBucketLevelTrigger", "Lorg/opensearch/commons/alerting/model/BucketLevelTriggerRunResult;", "Lorg/opensearch/commons/alerting/model/BucketLevelTrigger;", "Lorg/opensearch/alerting/script/BucketLevelTriggerExecutionContext;", "getBucketKeyValuesList", "", "bucket", "opensearch-alerting"})
@SourceDebugExtension(value={"SMAP\nTriggerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TriggerService.kt\norg/opensearch/alerting/TriggerService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,237:1\n1#2:238\n216#3,2:239\n1869#4,2:241\n1869#4,2:243\n1563#4:245\n1634#4,3:246\n*S KotlinDebug\n*F\n+ 1 TriggerService.kt\norg/opensearch/alerting/TriggerService\n*L\n98#1:239,2\n170#1:241,2\n200#1:243,2\n230#1:245\n230#1:246,3\n*E\n"})
public final class TriggerService {
    @NotNull
    private final ScriptService scriptService;
    private final Logger logger;
    @NotNull
    private final Script ALWAYS_RUN;
    @NotNull
    private final Script NEVER_RUN;

    public TriggerService(@NotNull ScriptService scriptService) {
        Intrinsics.checkNotNullParameter((Object)scriptService, (String)"scriptService");
        this.scriptService = scriptService;
        this.logger = LogManager.getLogger(TriggerService.class);
        this.ALWAYS_RUN = new Script("return true");
        this.NEVER_RUN = new Script("return false");
    }

    @NotNull
    public final ScriptService getScriptService() {
        return this.scriptService;
    }

    public final boolean isQueryLevelTriggerActionable(@NotNull QueryLevelTriggerExecutionContext ctx, @NotNull QueryLevelTriggerRunResult result, @Nullable WorkflowRunContext workflowRunContext) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        WorkflowRunContext workflowRunContext2 = workflowRunContext;
        boolean bl = workflowRunContext2 != null ? workflowRunContext2.getAuditDelegateMonitorAlerts() : false;
        if (bl) {
            return false;
        }
        AlertContext alertContext = ctx.getAlert();
        boolean suppress = (alertContext != null && (alertContext = alertContext.getAlert()) != null ? alertContext.getState() : null) == Alert.State.ACKNOWLEDGED && result.getError() == null && ctx.getError() == null;
        return result.getTriggered() && !suppress;
    }

    public final boolean isChainedAlertTriggerActionable(@NotNull ChainedAlertTriggerExecutionContext ctx, @NotNull ChainedAlertTriggerRunResult result) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Alert alert = ctx.getAlert();
        boolean suppress = (alert != null ? alert.getState() : null) == Alert.State.ACKNOWLEDGED && result.getError() == null && ctx.getError() == null;
        return result.getTriggered() && !suppress;
    }

    @NotNull
    public final QueryLevelTriggerRunResult runQueryLevelTrigger(@NotNull Monitor monitor, @NotNull QueryLevelTrigger trigger, @NotNull QueryLevelTriggerExecutionContext ctx) {
        QueryLevelTriggerRunResult queryLevelTriggerRunResult;
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        try {
            TriggerScript.Factory factory = (TriggerScript.Factory)this.scriptService.compile(trigger.getCondition(), TriggerScript.Companion.getCONTEXT());
            Map map = trigger.getCondition().getParams();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getParams(...)");
            boolean triggered = factory.newInstance(map).execute(ctx);
            queryLevelTriggerRunResult = new QueryLevelTriggerRunResult(trigger.getName(), triggered, null, null, 8, null);
        }
        catch (Exception e) {
            this.logger.info("Error running script for monitor " + monitor.getId() + ", trigger: " + trigger.getId(), (Throwable)e);
            queryLevelTriggerRunResult = new QueryLevelTriggerRunResult(trigger.getName(), true, e, null, 8, null);
        }
        return queryLevelTriggerRunResult;
    }

    @NotNull
    public final ClusterMetricsTriggerRunResult runClusterMetricsTrigger(@NotNull Monitor monitor, @NotNull QueryLevelTrigger trigger, @NotNull QueryLevelTriggerExecutionContext ctx, @NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        ClusterMetricsTriggerRunResult runResult = null;
        try {
            Map map;
            List<Map<String, Object>> list = ctx.getResults();
            int n = 0;
            if (n < list.size()) {
                map = list.get(n);
            } else {
                int it = n;
                boolean bl = false;
                map = MapsKt.emptyMap();
            }
            Map inputResults = map;
            boolean triggered = false;
            List clusterTriggerResults = new ArrayList();
            if (CrossClusterMonitorUtils.Companion.isRemoteMonitor(monitor, clusterService)) {
                Map $this$forEach$iv = inputResults;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry clusterResult = element$iv = iterator.next();
                    boolean bl = false;
                    Map.Entry entry = clusterResult;
                    QueryLevelTriggerExecutionContext clusterTriggerCtx = QueryLevelTriggerExecutionContext.copy$default(ctx, null, null, CollectionsKt.listOf((Object)MapsKt.mapOf((Pair)new Pair(entry.getKey(), entry.getValue()))), null, null, null, null, 123, null);
                    TriggerScript.Factory factory = (TriggerScript.Factory)this.scriptService.compile(trigger.getCondition(), TriggerScript.Companion.getCONTEXT());
                    Map map2 = trigger.getCondition().getParams();
                    Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getParams(...)");
                    boolean clusterTriggered = factory.newInstance(map2).execute(clusterTriggerCtx);
                    if (!clusterTriggered) continue;
                    triggered = clusterTriggered;
                    clusterTriggerResults.add(new ClusterMetricsTriggerRunResult.ClusterTriggerResult((String)clusterResult.getKey(), clusterTriggered));
                }
            } else {
                TriggerScript.Factory factory = (TriggerScript.Factory)this.scriptService.compile(trigger.getCondition(), TriggerScript.Companion.getCONTEXT());
                Map map3 = trigger.getCondition().getParams();
                Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"getParams(...)");
                triggered = factory.newInstance(map3).execute(ctx);
                if (triggered) {
                    String string = clusterService.getClusterName().value();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value(...)");
                    clusterTriggerResults.add(new ClusterMetricsTriggerRunResult.ClusterTriggerResult(string, triggered));
                }
            }
            runResult = new ClusterMetricsTriggerRunResult(trigger.getName(), triggered, null, null, clusterTriggerResults, 8, null);
        }
        catch (Exception e) {
            this.logger.info("Error running script for monitor " + monitor.getId() + ", trigger: " + trigger.getId(), (Throwable)e);
            runResult = new ClusterMetricsTriggerRunResult(trigger.getName(), true, e, null, null, 24, null);
        }
        return runResult;
    }

    @NotNull
    public final DocumentLevelTriggerRunResult runDocLevelTrigger(@NotNull Monitor monitor, @NotNull DocumentLevelTrigger trigger, @NotNull Map<DocLevelQuery, ? extends Set<String>> queryToDocIds) {
        DocumentLevelTriggerRunResult documentLevelTriggerRunResult;
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        Intrinsics.checkNotNullParameter(queryToDocIds, (String)"queryToDocIds");
        try {
            List triggeredDocs = new ArrayList();
            if (trigger.getCondition().getIdOrCode().equals(this.ALWAYS_RUN.getIdOrCode())) {
                for (Set<String> set : queryToDocIds.values()) {
                    triggeredDocs.addAll((Collection)set);
                }
            } else if (!trigger.getCondition().getIdOrCode().equals(this.NEVER_RUN.getIdOrCode())) {
                String string = trigger.getCondition().getIdOrCode();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdOrCode(...)");
                triggeredDocs = CollectionsKt.toMutableList((Collection)new TriggerExpressionParser(string).parse().evaluate(queryToDocIds));
            }
            documentLevelTriggerRunResult = new DocumentLevelTriggerRunResult(trigger.getName(), triggeredDocs, null, null, 8, null);
        }
        catch (Exception e) {
            this.logger.info("Error running script for monitor " + monitor.getId() + ", trigger: " + trigger.getId(), (Throwable)e);
            documentLevelTriggerRunResult = new DocumentLevelTriggerRunResult(trigger.getName(), CollectionsKt.emptyList(), e, null, 8, null);
        }
        return documentLevelTriggerRunResult;
    }

    @NotNull
    public final ChainedAlertTriggerRunResult runChainedAlertTrigger(@NotNull Workflow workflow, @NotNull ChainedAlertTrigger trigger, @NotNull Set<String> alertGeneratingMonitors, @NotNull Map<String, ? extends Set<String>> monitorIdToAlertIdsMap) {
        ChainedAlertTriggerRunResult chainedAlertTriggerRunResult;
        Intrinsics.checkNotNullParameter((Object)workflow, (String)"workflow");
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        Intrinsics.checkNotNullParameter(alertGeneratingMonitors, (String)"alertGeneratingMonitors");
        Intrinsics.checkNotNullParameter(monitorIdToAlertIdsMap, (String)"monitorIdToAlertIdsMap");
        Set associatedAlertIds = new LinkedHashSet();
        try {
            String string = trigger.getCondition().getIdOrCode();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdOrCode(...)");
            ChainedAlertRPNResolver parsedTriggerCondition = new ChainedAlertExpressionParser(string).parse();
            boolean evaluate = parsedTriggerCondition.evaluate(alertGeneratingMonitors);
            if (evaluate) {
                Set<String> monitorIdsInTriggerCondition = parsedTriggerCondition.getMonitorIds(parsedTriggerCondition);
                Iterable $this$forEach$iv = monitorIdsInTriggerCondition;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    associatedAlertIds.addAll(monitorIdToAlertIdsMap.getOrDefault(it, SetsKt.emptySet()));
                }
            }
            chainedAlertTriggerRunResult = new ChainedAlertTriggerRunResult(trigger.getName(), evaluate, null, null, associatedAlertIds, 8, null);
        }
        catch (Exception e) {
            this.logger.error("Error running chained alert trigger script for workflow " + workflow.getId() + ", trigger: " + trigger.getId(), (Throwable)e);
            chainedAlertTriggerRunResult = new ChainedAlertTriggerRunResult(trigger.getName(), false, e, null, SetsKt.emptySet(), 8, null);
        }
        return chainedAlertTriggerRunResult;
    }

    @NotNull
    public final BucketLevelTriggerRunResult runBucketLevelTrigger(@NotNull Monitor monitor, @NotNull BucketLevelTrigger trigger, @NotNull BucketLevelTriggerExecutionContext ctx) {
        BucketLevelTriggerRunResult bucketLevelTriggerRunResult;
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        try {
            Object object = ctx.getResults().get(0).get("aggregations");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.HashMap<*, *>");
            Map map = (HashMap)object;
            Object v = map.get(trigger.getId());
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type java.util.HashMap<*, *>");
            Map map2 = (HashMap)v;
            Object v2 = map2.get("bucket_indices");
            Intrinsics.checkNotNull(v2, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
            List bucketIndices = (List)v2;
            Object object2 = ctx.getResults().get(0).get("aggregations");
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type java.util.HashMap<*, *>");
            Object object3 = (HashMap)object2;
            map = object3.get(trigger.getId());
            Intrinsics.checkNotNull((Object)map, (String)"null cannot be cast to non-null type java.util.HashMap<*, *>");
            map = (HashMap)map;
            object3 = "parent_bucket_path";
            map2 = map.get(object3);
            Intrinsics.checkNotNull((Object)map2, (String)"null cannot be cast to non-null type kotlin.String");
            String parentBucketPath = (String)((Object)map2);
            AggregationPath aggregationPath = AggregationPath.parse((String)parentBucketPath);
            HashMap parentAgg = null;
            Object object4 = ctx.getResults().get(0).get("aggregations");
            Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type java.util.HashMap<*, *>");
            parentAgg = (HashMap)object4;
            List list = aggregationPath.getPathElementsAsStringList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPathElementsAsStringList(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String sub_agg = (String)element$iv;
                boolean bl = false;
                Object v3 = ((Map)parentAgg).get(sub_agg);
                Intrinsics.checkNotNull(v3, (String)"null cannot be cast to non-null type java.util.HashMap<*, *>");
                parentAgg = (HashMap)v3;
            }
            Object v4 = ((Map)parentAgg).get(Aggregation.CommonFields.BUCKETS.getPreferredName());
            Intrinsics.checkNotNull(v4, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
            List buckets = (List)v4;
            Map selectedBuckets = new LinkedHashMap();
            for (Object bucketIndex : bucketIndices) {
                Intrinsics.checkNotNull((Object)bucketIndex, (String)"null cannot be cast to non-null type kotlin.Int");
                Object e = buckets.get((Integer)bucketIndex);
                Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                Map bucketDict = (Map)e;
                List<String> bucketKeyValuesList = this.getBucketKeyValuesList(bucketDict);
                AggregationResultBucket aggResultBucket = new AggregationResultBucket(parentBucketPath, bucketKeyValuesList, bucketDict);
                selectedBuckets.put(AlertingUtilsKt.getBucketKeysHash(aggResultBucket), aggResultBucket);
            }
            bucketLevelTriggerRunResult = new BucketLevelTriggerRunResult(trigger.getName(), null, selectedBuckets, null, 8, null);
        }
        catch (Exception e) {
            this.logger.info("Error running trigger [" + trigger.getId() + "] for monitor [" + monitor.getId() + "]", (Throwable)e);
            bucketLevelTriggerRunResult = new BucketLevelTriggerRunResult(trigger.getName(), e, MapsKt.emptyMap(), null, 8, null);
        }
        return bucketLevelTriggerRunResult;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getBucketKeyValuesList(Map<String, ? extends Object> bucket) {
        String keyField = Aggregation.CommonFields.KEY.getPreferredName();
        List keyValuesList = new ArrayList();
        if (bucket.get(keyField) instanceof List && bucket.containsKey(Aggregation.CommonFields.KEY_AS_STRING.getPreferredName())) {
            Object object = bucket.get(Aggregation.CommonFields.KEY_AS_STRING.getPreferredName());
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            v1 = keyValuesList.add((String)object);
        } else if (bucket.get(keyField) instanceof String) {
            Object object = bucket.get(keyField);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            v1 = keyValuesList.add((String)object);
        } else if (bucket.get(keyField) instanceof Integer) {
            v1 = keyValuesList.add(String.valueOf(bucket.get(keyField)));
        } else if (bucket.get(keyField) instanceof Map) {
            void $this$mapTo$iv$iv;
            Object object = bucket.get(keyField);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
            Iterable $this$map$iv = ((Map)object).values();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(keyValuesList.add(it.toString()));
            }
            v1 = (List)destination$iv$iv;
        } else {
            throw new IllegalArgumentException("Unexpected format for key in bucket [" + bucket + "]");
        }
        return keyValuesList;
    }
}

