/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.transport;

import java.io.IOException;
import java.util.List;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.broadcast.node.TransportBroadcastByNodeAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.ShardsIterator;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.support.DefaultShardOperationFailedException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.indices.IndicesService;
import org.opensearch.neuralsearch.sparse.NeuralSparseIndexShard;
import org.opensearch.neuralsearch.transport.NeuralSparseWarmupRequest;
import org.opensearch.neuralsearch.transport.NeuralSparseWarmupResponse;
import org.opensearch.neuralsearch.transport.TransportUtils;
import org.opensearch.transport.TransportService;

public class NeuralSparseWarmupTransportAction
extends TransportBroadcastByNodeAction<NeuralSparseWarmupRequest, NeuralSparseWarmupResponse, TransportBroadcastByNodeAction.EmptyResult> {
    private final IndicesService indicesService;

    @Inject
    public NeuralSparseWarmupTransportAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/neural_sparse_warmup_action", clusterService, transportService, actionFilters, indexNameExpressionResolver, NeuralSparseWarmupRequest::new, "seismic_thread_pool");
        this.indicesService = indicesService;
    }

    protected TransportBroadcastByNodeAction.EmptyResult readShardResult(StreamInput in) throws IOException {
        return TransportBroadcastByNodeAction.EmptyResult.readEmptyResultFrom((StreamInput)in);
    }

    protected NeuralSparseWarmupResponse newResponse(NeuralSparseWarmupRequest request, int totalShards, int successfulShards, int failedShards, List<TransportBroadcastByNodeAction.EmptyResult> emptyResults, List<DefaultShardOperationFailedException> shardFailures, ClusterState clusterState) {
        return new NeuralSparseWarmupResponse(totalShards, successfulShards, failedShards, shardFailures);
    }

    protected NeuralSparseWarmupRequest readRequestFrom(StreamInput in) throws IOException {
        return new NeuralSparseWarmupRequest(in);
    }

    protected TransportBroadcastByNodeAction.EmptyResult shardOperation(NeuralSparseWarmupRequest request, ShardRouting shardRouting) throws IOException {
        NeuralSparseIndexShard neuralSparseIndexShard = new NeuralSparseIndexShard(this.indicesService.indexServiceSafe(shardRouting.shardId().getIndex()).getShard(shardRouting.shardId().id()));
        neuralSparseIndexShard.warmUp();
        return TransportBroadcastByNodeAction.EmptyResult.INSTANCE;
    }

    protected ShardsIterator shards(ClusterState state, NeuralSparseWarmupRequest request, String[] concreteIndices) {
        return state.routingTable().allShards(concreteIndices);
    }

    protected ClusterBlockException checkGlobalBlock(ClusterState state, NeuralSparseWarmupRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    protected ClusterBlockException checkRequestBlock(ClusterState state, NeuralSparseWarmupRequest request, String[] concreteIndices) {
        TransportUtils.validateSparseIndices(state, concreteIndices, "neural_sparse_warmup_action");
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, concreteIndices);
    }
}

