/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.connector.MLCreateConnectorAction;
import org.opensearch.ml.common.transport.connector.MLCreateConnectorInput;
import org.opensearch.ml.common.transport.connector.MLCreateConnectorRequest;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestRequestFilter;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

public class RestMLCreateConnectorAction
extends BaseRestHandler
implements RestRequestFilter {
    private static final String ML_CREATE_CONNECTOR_ACTION = "ml_create_connector_action";
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLCreateConnectorAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_CREATE_CONNECTOR_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/connectors/_create", "/_plugins/_ml")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLCreateConnectorRequest mlCreateConnectorRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLCreateConnectorAction.INSTANCE, (ActionRequest)mlCreateConnectorRequest, (ActionListener)new RestToXContentListener(channel));
    }

    @VisibleForTesting
    MLCreateConnectorRequest getRequest(RestRequest request) throws IOException {
        if (!this.mlFeatureEnabledSetting.isRemoteInferenceEnabled()) {
            throw new IllegalStateException("Remote Inference is currently disabled. To enable it, update the setting \"plugins.ml_commons.remote_inference_enabled\" to true.");
        }
        if (!request.hasContent()) {
            throw new IOException("Create Connector request has empty body");
        }
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        MLCreateConnectorInput mlCreateConnectorInput = MLCreateConnectorInput.parse((XContentParser)parser);
        String tenantId = TenantAwareHelper.getTenantID(this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), request);
        mlCreateConnectorInput.setTenantId(tenantId);
        return new MLCreateConnectorRequest(mlCreateConnectorInput);
    }

    public Set<String> getFilteredFields() {
        return Set.of("credential", "*.Authorization");
    }
}

