/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.model_group;

import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.action.handler.MLSearchHandler;
import org.opensearch.ml.common.ResourceSharingClientAccessor;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.search.MLSearchActionRequest;
import org.opensearch.ml.helper.ModelAccessControlHelper;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.remote.metadata.client.SearchDataObjectRequest;
import org.opensearch.remote.metadata.common.SdkClientUtils;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.security.spi.resources.client.ResourceSharingClient;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class SearchModelGroupTransportAction
extends HandledTransportAction<MLSearchActionRequest, SearchResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(SearchModelGroupTransportAction.class);
    Client client;
    SdkClient sdkClient;
    ClusterService clusterService;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;
    ModelAccessControlHelper modelAccessControlHelper;

    @Inject
    public SearchModelGroupTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, SdkClient sdkClient, ClusterService clusterService, ModelAccessControlHelper modelAccessControlHelper, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/opensearch/ml/model_groups/search", transportService, actionFilters, MLSearchActionRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.clusterService = clusterService;
        this.modelAccessControlHelper = modelAccessControlHelper;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, MLSearchActionRequest request, ActionListener<SearchResponse> actionListener) {
        User user = RestActionUtils.getUserContext(this.client);
        ActionListener<SearchResponse> listener = MLSearchHandler.wrapRestActionListener(actionListener, "Fail to search");
        String tenantId = request.getTenantId();
        if (!TenantAwareHelper.validateTenantId(this.mlFeatureEnabledSetting, tenantId, actionListener)) {
            return;
        }
        this.preProcessRoleAndPerformSearch((SearchRequest)request, tenantId, user, listener);
    }

    private void preProcessRoleAndPerformSearch(SearchRequest request, String tenantId, User user, ActionListener<SearchResponse> listener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore());
            ActionListener doubleWrappedListener = ActionListener.wrap(arg_0 -> ((ActionListener)wrappedListener).onResponse(arg_0), e -> RestActionUtils.wrapListenerToHandleSearchIndexNotFound(e, (ActionListener<SearchResponse>)wrappedListener));
            if (ModelAccessControlHelper.shouldUseResourceAuthz("ml-model-group")) {
                this.addAccessibleModelGroupsFilterAndSearch(tenantId, request, (ActionListener<SearchResponse>)doubleWrappedListener);
                return;
            }
            if (!this.modelAccessControlHelper.skipModelAccessControl(user)) {
                this.modelAccessControlHelper.addUserBackendRolesFilter(user, request.source());
                log.debug("Filtering result by {}", (Object)user.getBackendRoles());
            }
            this.search(tenantId, request, (ActionListener<SearchResponse>)doubleWrappedListener);
        }
        catch (Exception e2) {
            log.error("Failed to search", (Throwable)e2);
            listener.onFailure(e2);
        }
    }

    private void addAccessibleModelGroupsFilterAndSearch(String tenantId, SearchRequest request, ActionListener<SearchResponse> wrappedListener) {
        SearchSourceBuilder sourceBuilder = request.source() != null ? request.source() : new SearchSourceBuilder();
        ResourceSharingClient rsc = ResourceSharingClientAccessor.getInstance().getResourceSharingClient();
        rsc.getAccessibleResourceIds("ml-model-group", ActionListener.wrap(ids -> {
            sourceBuilder.query(this.modelAccessControlHelper.mergeWithAccessFilter(sourceBuilder.query(), (Set<String>)ids));
            request.source(sourceBuilder);
            this.search(tenantId, request, wrappedListener);
        }, e -> {
            sourceBuilder.query(this.modelAccessControlHelper.mergeWithAccessFilter(sourceBuilder.query(), Collections.emptySet()));
            request.source(sourceBuilder);
            this.search(tenantId, request, wrappedListener);
        }));
    }

    private void search(String tenantId, SearchRequest request, ActionListener<SearchResponse> listener) {
        SearchDataObjectRequest searchDataObjectRequest = SearchDataObjectRequest.builder().indices(request.indices()).searchSourceBuilder(request.source()).tenantId(tenantId).build();
        this.sdkClient.searchDataObjectAsync(searchDataObjectRequest).whenComplete(SdkClientUtils.wrapSearchCompletion(listener, (Class[])new Class[0]));
    }
}

