/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.mcpserver;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.HashMap;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.action.mcpserver.McpStatelessServerHolder;
import org.opensearch.ml.action.mcpserver.OpenSearchMcpStatelessServerTransportProvider;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.mcpserver.requests.server.MLMcpServerRequest;
import org.opensearch.ml.common.transport.mcpserver.responses.server.MLMcpServerResponse;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class TransportMcpServerAction
extends HandledTransportAction<ActionRequest, MLMcpServerResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(TransportMcpServerAction.class);
    MLFeatureEnabledSetting mlFeatureEnabledSetting;
    ObjectMapper objectMapper;
    McpStatelessServerHolder mcpStatelessServerHolder;

    @Inject
    public TransportMcpServerAction(TransportService transportService, ActionFilters actionFilters, MLFeatureEnabledSetting mlFeatureEnabledSetting, McpStatelessServerHolder mcpStatelessServerHolder) {
        super("cluster:admin/opensearch/ml/mcp/server", transportService, actionFilters, MLMcpServerRequest::new);
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
        this.objectMapper = new ObjectMapper();
        this.mcpStatelessServerHolder = mcpStatelessServerHolder;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLMcpServerResponse> listener) {
        try {
            McpSchema.JSONRPCMessage message;
            if (!this.mlFeatureEnabledSetting.isMcpServerEnabled()) {
                listener.onFailure((Exception)new OpenSearchException(MLCommonsSettings.ML_COMMONS_MCP_SERVER_DISABLED_MESSAGE, new Object[0]));
                return;
            }
            MLMcpServerRequest mlMcpServerRequest = MLMcpServerRequest.fromActionRequest((ActionRequest)request);
            OpenSearchMcpStatelessServerTransportProvider transportProvider = this.mcpStatelessServerHolder.getMcpStatelessServerTransportProvider();
            if (transportProvider == null) {
                log.error("MCP handler not ready - server initialization failed");
                this.handleError(null, -32000, "MCP transport provider not ready - server may not be properly initialized", listener);
                return;
            }
            try {
                message = McpSchema.deserializeJsonRpcMessage((ObjectMapper)this.objectMapper, (String)mlMcpServerRequest.getRequestBody());
            }
            catch (Exception e) {
                log.error("Parse error: " + e.getMessage(), (Throwable)e);
                this.handleError(null, -32700, "Parse error: " + e.getMessage(), listener);
                return;
            }
            if (message instanceof McpSchema.JSONRPCNotification) {
                listener.onResponse((Object)new MLMcpServerResponse(Boolean.valueOf(true), null, null));
                return;
            }
            Object id = message instanceof McpSchema.JSONRPCRequest ? ((McpSchema.JSONRPCRequest)message).id() : null;
            transportProvider.handleRequest(message).subscribe(response -> {
                try {
                    String responseJson = this.objectMapper.writeValueAsString(response);
                    listener.onResponse((Object)new MLMcpServerResponse(Boolean.valueOf(true), responseJson, null));
                }
                catch (Exception e) {
                    log.error("Response serialization failed: " + e.getMessage(), (Throwable)e);
                    this.handleError(id, -32603, "Response serialization failed: " + e.getMessage(), listener);
                }
            }, error -> {
                log.error("Internal server error: " + error.getMessage(), error);
                this.handleError(id, -32603, "Internal server error: " + error.getMessage(), listener);
            });
        }
        catch (Exception e) {
            log.error("Failed to handle stateless MCP request", (Throwable)e);
            this.handleError(null, -32603, "Internal server error: " + e.getMessage(), listener);
        }
    }

    private void handleError(Object id, int errorCode, String responseMessage, ActionListener<MLMcpServerResponse> listener) {
        HashMap<String, Object> errorMessage = new HashMap<String, Object>();
        errorMessage.put("message", responseMessage);
        errorMessage.put("id", id);
        errorMessage.put("error_code", errorCode);
        listener.onResponse((Object)new MLMcpServerResponse(Boolean.valueOf(false), null, errorMessage));
    }
}

