/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.util.List;
import java.util.Objects;
import software.amazon.awssdk.services.kms.KmsClient;

public class CreateAwsKmsMrkKeyringInput {
    private final String kmsKeyId;
    private final KmsClient kmsClient;
    private final List<String> grantTokens;

    protected CreateAwsKmsMrkKeyringInput(BuilderImpl builder) {
        this.kmsKeyId = builder.kmsKeyId();
        this.kmsClient = builder.kmsClient();
        this.grantTokens = builder.grantTokens();
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public KmsClient kmsClient() {
        return this.kmsClient;
    }

    public List<String> grantTokens() {
        return this.grantTokens;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String kmsKeyId;
        protected KmsClient kmsClient;
        protected List<String> grantTokens;

        protected BuilderImpl() {
        }

        protected BuilderImpl(CreateAwsKmsMrkKeyringInput model) {
            this.kmsKeyId = model.kmsKeyId();
            this.kmsClient = model.kmsClient();
            this.grantTokens = model.grantTokens();
        }

        @Override
        public Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        @Override
        public String kmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public Builder kmsClient(KmsClient kmsClient) {
            this.kmsClient = kmsClient;
            return this;
        }

        @Override
        public KmsClient kmsClient() {
            return this.kmsClient;
        }

        @Override
        public Builder grantTokens(List<String> grantTokens) {
            this.grantTokens = grantTokens;
            return this;
        }

        @Override
        public List<String> grantTokens() {
            return this.grantTokens;
        }

        @Override
        public CreateAwsKmsMrkKeyringInput build() {
            if (Objects.isNull(this.kmsKeyId())) {
                throw new IllegalArgumentException("Missing value for required field `kmsKeyId`");
            }
            if (Objects.isNull(this.kmsClient())) {
                throw new IllegalArgumentException("Missing value for required field `kmsClient`");
            }
            return new CreateAwsKmsMrkKeyringInput(this);
        }
    }

    public static interface Builder {
        public Builder kmsKeyId(String var1);

        public String kmsKeyId();

        public Builder kmsClient(KmsClient var1);

        public KmsClient kmsClient();

        public Builder grantTokens(List<String> var1);

        public List<String> grantTokens();

        public CreateAwsKmsMrkKeyringInput build();
    }
}

