/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.credentials.oss;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.AmazonSNSClientBuilder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.notifications.core.credentials.SnsClientFactory;
import org.opensearch.notifications.core.credentials.oss.CredentialsProviderFactory;
import org.opensearch.notifications.core.utils.SecurityAccess;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\t"}, d2={"Lorg/opensearch/notifications/core/credentials/oss/SnsClientFactoryImpl;", "Lorg/opensearch/notifications/core/credentials/SnsClientFactory;", "<init>", "()V", "createSnsClient", "Lcom/amazonaws/services/sns/AmazonSNS;", "region", "", "roleArn", "opensearch-notifications-core"})
public final class SnsClientFactoryImpl
implements SnsClientFactory {
    @NotNull
    public static final SnsClientFactoryImpl INSTANCE = new SnsClientFactoryImpl();

    private SnsClientFactoryImpl() {
    }

    @Override
    @NotNull
    public AmazonSNS createSnsClient(@NotNull String region, @Nullable String roleArn) {
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        AmazonSNS amazonSNS = SecurityAccess.INSTANCE.doPrivileged(() -> SnsClientFactoryImpl.createSnsClient$lambda$0(region, roleArn));
        Intrinsics.checkNotNullExpressionValue((Object)amazonSNS, (String)"doPrivileged(...)");
        return amazonSNS;
    }

    private static final AmazonSNS createSnsClient$lambda$0(String $region, String $roleArn) {
        AWSCredentialsProvider credentials = new CredentialsProviderFactory().getCredentialsProvider($region, $roleArn);
        return (AmazonSNS)((AmazonSNSClientBuilder)((AmazonSNSClientBuilder)AmazonSNSClientBuilder.standard().withRegion($region)).withCredentials(credentials)).build();
    }
}

