/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.client;

import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.notifications.core.setting.PluginSettings;
import org.opensearch.notifications.core.utils.HelpersKt;
import org.opensearch.notifications.spi.model.MessageContent;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/opensearch/notifications/core/client/EmailMessageValidator;", "", "<init>", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "isMessageSizeOverLimit", "", "message", "Lorg/opensearch/notifications/spi/model/MessageContent;", "opensearch-notifications-core"})
public final class EmailMessageValidator {
    @NotNull
    public static final EmailMessageValidator INSTANCE = new EmailMessageValidator();
    @NotNull
    private static final Lazy log$delegate = HelpersKt.logger(EmailMessageValidator.class);

    private EmailMessageValidator() {
    }

    private final Logger getLog() {
        Lazy lazy = log$delegate;
        return (Logger)lazy.getValue();
    }

    public final boolean isMessageSizeOverLimit(@NotNull MessageContent message) {
        int n;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (message.getFileData() != null && message.getFileName() != null) {
            int n2 = PluginSettings.INSTANCE.getEmailMinimumHeaderLength();
            String string = message.getFileData();
            Intrinsics.checkNotNull((Object)string);
            int n3 = n2 + string.length();
            String string2 = message.getFileName();
            Intrinsics.checkNotNull((Object)string2);
            n = n3 + string2.length();
        } else {
            n = 0;
        }
        int approxAttachmentLength = n;
        String string = message.getHtmlDescription();
        int approxEmailLength = PluginSettings.INSTANCE.getEmailMinimumHeaderLength() + message.getTitle().length() + message.getTextDescription().length() + (string != null ? string.length() : 0) + approxAttachmentLength;
        return approxEmailLength > PluginSettings.INSTANCE.getEmailSizeLimit();
    }
}

