/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core;

import java.security.AccessController;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.notifications.core.setting.PluginSettings;
import org.opensearch.notifications.core.transport.DestinationTransport;
import org.opensearch.notifications.core.transport.DestinationTransportProvider;
import org.opensearch.notifications.spi.NotificationCore;
import org.opensearch.notifications.spi.model.DestinationMessageResponse;
import org.opensearch.notifications.spi.model.MessageContent;
import org.opensearch.notifications.spi.model.destination.BaseDestination;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0016J\u0014\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/opensearch/notifications/core/NotificationCoreImpl;", "Lorg/opensearch/notifications/spi/NotificationCore;", "<init>", "()V", "sendMessage", "Lorg/opensearch/notifications/spi/model/DestinationMessageResponse;", "destination", "Lorg/opensearch/notifications/spi/model/destination/BaseDestination;", "message", "Lorg/opensearch/notifications/spi/model/MessageContent;", "referenceId", "", "getAllowedConfigTypes", "", "getPluginFeatures", "", "opensearch-notifications-core"})
public final class NotificationCoreImpl
implements NotificationCore {
    @NotNull
    public static final NotificationCoreImpl INSTANCE = new NotificationCoreImpl();

    private NotificationCoreImpl() {
    }

    @NotNull
    public DestinationMessageResponse sendMessage(@NotNull BaseDestination destination, @NotNull MessageContent message, @NotNull String referenceId) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        DestinationMessageResponse destinationMessageResponse = AccessController.doPrivileged(() -> NotificationCoreImpl.sendMessage$lambda$0(destination, message, referenceId));
        Intrinsics.checkNotNullExpressionValue((Object)destinationMessageResponse, (String)"doPrivileged(...)");
        return destinationMessageResponse;
    }

    @NotNull
    public List<String> getAllowedConfigTypes() {
        List list = AccessController.doPrivileged(NotificationCoreImpl::getAllowedConfigTypes$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"doPrivileged(...)");
        return list;
    }

    @NotNull
    public Map<String, String> getPluginFeatures() {
        Map map = AccessController.doPrivileged(NotificationCoreImpl::getPluginFeatures$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"doPrivileged(...)");
        return map;
    }

    private static final DestinationMessageResponse sendMessage$lambda$0(BaseDestination $destination, MessageContent $message, String $referenceId) {
        DestinationTransport<BaseDestination> destinationFactory = DestinationTransportProvider.INSTANCE.getTransport($destination.getDestinationType());
        return destinationFactory.sendMessage($destination, $message, $referenceId);
    }

    private static final List getAllowedConfigTypes$lambda$0() {
        return PluginSettings.INSTANCE.getAllowedConfigTypes();
    }

    private static final Map getPluginFeatures$lambda$0() {
        return MapsKt.mapOf((Pair)new Pair((Object)"tooltip_support", (Object)String.valueOf(PluginSettings.INSTANCE.getTooltipSupport())));
    }
}

