/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.parkservices;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.config.ForestMode;
import com.amazon.randomcutforest.config.TransformMethod;
import com.amazon.randomcutforest.parkservices.AnomalyDescriptor;
import com.amazon.randomcutforest.parkservices.IRCFComputeDescriptor;
import com.amazon.randomcutforest.parkservices.threshold.BasicThresholder;
import com.amazon.randomcutforest.returntypes.DiVector;
import java.util.Arrays;
import lombok.Generated;

public class PredictorCorrector {
    public static int DEFAULT_NUMBER_OF_MAX_ATTRIBUTORS = 5;
    public static double DEFAULT_REPEAT_ANOMALY_Z_FACTOR = 3.5;
    public static double DEFAULT_IGNORE_SIMILAR_FACTOR = 0.3;
    public static boolean DEFAULT_IGNORE_SIMILAR = false;
    protected double ignoreSimilarFactor = DEFAULT_IGNORE_SIMILAR_FACTOR;
    protected double triggerFactor = DEFAULT_REPEAT_ANOMALY_Z_FACTOR;
    protected boolean ignoreSimilar = DEFAULT_IGNORE_SIMILAR;
    protected int numberOfAttributors = DEFAULT_NUMBER_OF_MAX_ATTRIBUTORS;
    protected BasicThresholder thresholder;

    public PredictorCorrector(BasicThresholder thresholder) {
        this.thresholder = thresholder;
    }

    public BasicThresholder getThresholder() {
        return this.thresholder;
    }

    protected int maxContribution(DiVector diVector, int baseDimension, int startIndex) {
        int i;
        double val = 0.0;
        int index = startIndex;
        int position = diVector.getDimensions() + startIndex * baseDimension;
        for (i = 0; i < baseDimension; ++i) {
            val += diVector.getHighLowSum(i + position);
        }
        for (i = position + baseDimension; i < diVector.getDimensions(); i += baseDimension) {
            double sum = 0.0;
            for (int j = 0; j < baseDimension; ++j) {
                sum += diVector.getHighLowSum(i + j);
            }
            if (!(sum > val)) continue;
            val = sum;
            index = (i - diVector.getDimensions()) / baseDimension;
        }
        return index;
    }

    protected double[] getExpectedPoint(DiVector diVector, int position, int baseDimension, double[] point, RandomCutForest forest) {
        int[] likelyMissingIndices;
        if (baseDimension == 1) {
            likelyMissingIndices = new int[]{position};
        } else {
            int pick;
            double sum = 0.0;
            double[] values = new double[baseDimension];
            for (int i = 0; i < baseDimension; ++i) {
                values[i] = diVector.getHighLowSum(i + position);
                sum += values[i];
            }
            Arrays.sort(values);
            if (values[baseDimension - pick] < 0.1 * sum) {
                return null;
            }
            for (pick = 1; pick < baseDimension && values[baseDimension - pick - 1] >= 0.1 * sum; ++pick) {
            }
            if (pick > DEFAULT_NUMBER_OF_MAX_ATTRIBUTORS) {
                return null;
            }
            double cutoff = values[baseDimension - pick];
            likelyMissingIndices = new int[pick];
            int count = 0;
            for (int i = 0; i < baseDimension && count < pick; ++i) {
                if (!(diVector.getHighLowSum(i + position) >= cutoff) || count != 0 && !(diVector.getHighLowSum(i + position) > sum * 0.1)) continue;
                likelyMissingIndices[count++] = position + i;
            }
        }
        if ((double)likelyMissingIndices.length > 0.5 * (double)forest.getDimensions()) {
            return null;
        }
        return forest.imputeMissingValues(point, likelyMissingIndices.length, likelyMissingIndices);
    }

    protected boolean trigger(DiVector candidate, int gap, int baseDimension, DiVector ideal, boolean previousIsPotentialAnomaly, IRCFComputeDescriptor lastAnomalyDescriptor) {
        DiVector lastAnomalyAttribution = lastAnomalyDescriptor.getAttribution();
        double lastAnomalyScore = lastAnomalyDescriptor.getRCFScore();
        if (lastAnomalyAttribution == null) {
            return true;
        }
        CommonUtils.checkArgument((lastAnomalyAttribution.getDimensions() == candidate.getDimensions() ? 1 : 0) != 0, (String)" error in DiVectors");
        int dimensions = candidate.getDimensions();
        int difference = baseDimension * gap;
        if (difference < dimensions) {
            if (ideal == null) {
                double remainder = 0.0;
                for (int i = dimensions - difference; i < dimensions; ++i) {
                    remainder += candidate.getHighLowSum(i);
                }
                return this.thresholder.getAnomalyGrade(remainder * (double)dimensions / (double)difference, previousIsPotentialAnomaly, this.triggerFactor) > 0.0;
            }
            double differentialRemainder = 0.0;
            for (int i = dimensions - difference; i < dimensions; ++i) {
                differentialRemainder += Math.abs(candidate.low[i] - ideal.low[i]) + Math.abs(candidate.high[i] - ideal.high[i]);
            }
            return differentialRemainder > this.ignoreSimilarFactor * lastAnomalyScore && this.thresholder.getAnomalyGrade(differentialRemainder * (double)dimensions / (double)difference, previousIsPotentialAnomaly, this.triggerFactor) > 0.0;
        }
        if (!this.ignoreSimilar) {
            return true;
        }
        double sum = 0.0;
        for (int i = 0; i < dimensions; ++i) {
            sum += Math.abs(lastAnomalyAttribution.high[i] - candidate.high[i]) + Math.abs(lastAnomalyAttribution.low[i] - candidate.low[i]);
        }
        return sum > this.ignoreSimilarFactor * lastAnomalyScore;
    }

    double[] applyBasicCorrector(double[] point, int gap, int shingleSize, int baseDimensions, IRCFComputeDescriptor lastAnomalyDescriptor) {
        CommonUtils.checkArgument((gap >= 0 && gap <= shingleSize ? 1 : 0) != 0, (String)"incorrect invocation");
        double[] correctedPoint = Arrays.copyOf(point, point.length);
        double[] lastExpectedPoint = lastAnomalyDescriptor.getExpectedRCFPoint();
        double[] lastAnomalyPoint = lastAnomalyDescriptor.getRCFPoint();
        int lastRelativeIndex = lastAnomalyDescriptor.getRelativeIndex();
        if (gap < shingleSize) {
            System.arraycopy(lastExpectedPoint, gap * baseDimensions, correctedPoint, 0, point.length - gap * baseDimensions);
        }
        if (lastRelativeIndex == 0) {
            TransformMethod transformMethod = lastAnomalyDescriptor.getTransformMethod();
            if (transformMethod == TransformMethod.DIFFERENCE || transformMethod == TransformMethod.NORMALIZE_DIFFERENCE) {
                for (int y = 0; y < baseDimensions; ++y) {
                    int n = point.length - gap * baseDimensions + y;
                    correctedPoint[n] = correctedPoint[n] + (lastAnomalyPoint[point.length - baseDimensions + y] - lastExpectedPoint[point.length - baseDimensions + y]);
                }
            } else if (lastAnomalyDescriptor.getForestMode() == ForestMode.TIME_AUGMENTED) {
                int n = point.length - (gap - 1) * baseDimensions - 1;
                correctedPoint[n] = correctedPoint[n] + (lastAnomalyPoint[point.length - 1] - lastExpectedPoint[point.length - 1]);
            }
        }
        return correctedPoint;
    }

    protected AnomalyDescriptor detect(AnomalyDescriptor result, IRCFComputeDescriptor lastAnomalyDescriptor, RandomCutForest forest) {
        double[] correctedPoint;
        double correctedScore;
        double[] point = result.getRCFPoint();
        if (point == null) {
            return result;
        }
        double score = forest.getAnomalyScore(point);
        result.setRCFScore(score);
        result.setRCFPoint(point);
        long internalTimeStamp = result.getInternalTimeStamp();
        if (score == 0.0) {
            return result;
        }
        int shingleSize = result.getShingleSize();
        int baseDimensions = result.getDimension() / shingleSize;
        int startPosition = (shingleSize - 1) * baseDimensions;
        result.setThreshold(this.thresholder.threshold());
        boolean previousIsPotentialAnomaly = this.thresholder.isInPotentialAnomaly();
        if (this.thresholder.getAnomalyGrade(score, previousIsPotentialAnomaly) == 0.0) {
            result.setAnomalyGrade(0.0);
            result.setInHighScoreRegion(false);
            this.thresholder.update(score, score, 0.0, false);
            return result;
        }
        result.setInHighScoreRegion(true);
        int gap = (int)(internalTimeStamp - lastAnomalyDescriptor.getInternalTimeStamp());
        boolean reasonableForecast = result.isReasonableForecast();
        if (reasonableForecast && lastAnomalyDescriptor.getRCFPoint() != null && lastAnomalyDescriptor.getExpectedRCFPoint() != null && gap > 0 && gap <= shingleSize && this.thresholder.getAnomalyGrade(correctedScore = forest.getAnomalyScore(correctedPoint = this.applyBasicCorrector(point, gap, shingleSize, baseDimensions, lastAnomalyDescriptor)), true) == 0.0) {
            this.thresholder.update(score, correctedScore, 0.0, false);
            result.setExpectedRCFPoint(correctedPoint);
            result.setAnomalyGrade(0.0);
            return result;
        }
        DiVector attribution = forest.getAnomalyAttribution(point);
        double[] newPoint = null;
        double newScore = score;
        DiVector newAttribution = null;
        int index = this.maxContribution(attribution, baseDimensions, -shingleSize) + 1;
        if (!previousIsPotentialAnomaly && this.trigger(attribution, gap, baseDimensions, null, false, lastAnomalyDescriptor)) {
            result.setAnomalyGrade(this.thresholder.getAnomalyGrade(score, false));
            result.setStartOfAnomaly(true);
            this.thresholder.update(score, score, 0.0, true);
        } else {
            if (reasonableForecast && (newPoint = this.getExpectedPoint(attribution, startPosition, baseDimensions, point, forest)) != null) {
                newAttribution = forest.getAnomalyAttribution(newPoint);
                newScore = forest.getAnomalyScore(newPoint);
                result.setExpectedRCFPoint(newPoint);
            }
            if (this.trigger(attribution, gap, baseDimensions, newAttribution, previousIsPotentialAnomaly, lastAnomalyDescriptor) && score > newScore) {
                result.setAnomalyGrade(this.thresholder.getAnomalyGrade(score, previousIsPotentialAnomaly));
                index = 0;
                this.thresholder.update(score, newScore, 0.0, true);
            } else {
                this.thresholder.update(score, newScore, 0.0, true);
                result.setAnomalyGrade(0.0);
                return result;
            }
        }
        result.setAttribution(attribution);
        result.setRelativeIndex(index);
        if (reasonableForecast) {
            startPosition = shingleSize * baseDimensions + (result.getRelativeIndex() - 1) * baseDimensions;
            newPoint = this.getExpectedPoint(result.getAttribution(), startPosition, baseDimensions, point, forest);
        }
        result.setExpectedRCFPoint(newPoint);
        return result;
    }

    public void setZfactor(double factor) {
        this.thresholder.setZfactor(factor);
        this.triggerFactor = Math.max(factor, this.triggerFactor);
    }

    public void setLowerThreshold(double lower) {
        this.thresholder.setAbsoluteThreshold(lower);
    }

    public void setHorizon(double horizon) {
        this.thresholder.setHorizon(horizon);
    }

    public void setInitialThreshold(double initial) {
        this.thresholder.setInitialThreshold(initial);
    }

    @Generated
    public double getIgnoreSimilarFactor() {
        return this.ignoreSimilarFactor;
    }

    @Generated
    public double getTriggerFactor() {
        return this.triggerFactor;
    }

    @Generated
    public boolean isIgnoreSimilar() {
        return this.ignoreSimilar;
    }

    @Generated
    public int getNumberOfAttributors() {
        return this.numberOfAttributors;
    }

    @Generated
    public void setIgnoreSimilarFactor(double ignoreSimilarFactor) {
        this.ignoreSimilarFactor = ignoreSimilarFactor;
    }

    @Generated
    public void setTriggerFactor(double triggerFactor) {
        this.triggerFactor = triggerFactor;
    }

    @Generated
    public void setIgnoreSimilar(boolean ignoreSimilar) {
        this.ignoreSimilar = ignoreSimilar;
    }

    @Generated
    public void setNumberOfAttributors(int numberOfAttributors) {
        this.numberOfAttributors = numberOfAttributors;
    }

    @Generated
    public void setThresholder(BasicThresholder thresholder) {
        this.thresholder = thresholder;
    }
}

