/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.reindex.remote;

import java.util.Objects;

public final class RemoteVersion
implements Comparable<RemoteVersion> {
    private final int major;
    private final int minor;
    private final int revision;
    final boolean isOpenSearch;
    public static final RemoteVersion ELASTICSEARCH_0_20_5 = new RemoteVersion(0, 20, 5, false);
    public static final RemoteVersion ELASTICSEARCH_0_90_13 = new RemoteVersion(0, 90, 13, false);
    public static final RemoteVersion ELASTICSEARCH_1_0_0 = new RemoteVersion(1, 0, 0, false);
    public static final RemoteVersion ELASTICSEARCH_1_7_5 = new RemoteVersion(1, 7, 5, false);
    public static final RemoteVersion ELASTICSEARCH_2_0_0 = new RemoteVersion(2, 0, 0, false);
    public static final RemoteVersion ELASTICSEARCH_2_1_0 = new RemoteVersion(2, 1, 0, false);
    public static final RemoteVersion ELASTICSEARCH_2_3_3 = new RemoteVersion(2, 3, 3, false);
    public static final RemoteVersion ELASTICSEARCH_5_0_0 = new RemoteVersion(5, 0, 0, false);
    public static final RemoteVersion ELASTICSEARCH_6_0_0 = new RemoteVersion(6, 0, 0, false);
    public static final RemoteVersion ELASTICSEARCH_6_3_0 = new RemoteVersion(6, 3, 0, false);
    public static final RemoteVersion ELASTICSEARCH_7_0_0 = new RemoteVersion(7, 0, 0, false);
    public static final RemoteVersion OPENSEARCH_1_0_0 = new RemoteVersion(1, 0, 0, true);
    public static final RemoteVersion OPENSEARCH_2_0_0 = new RemoteVersion(2, 0, 0, true);
    public static final RemoteVersion OPENSEARCH_3_1_0 = new RemoteVersion(3, 1, 0, true);

    public RemoteVersion(int major, int minor, int revision, boolean isOpenSearch) {
        this.major = major;
        this.minor = minor;
        this.revision = revision;
        this.isOpenSearch = isOpenSearch;
    }

    public static RemoteVersion fromString(String version, boolean isOpenSearch) {
        if (version == null || version.trim().isEmpty()) {
            throw new IllegalArgumentException("Version string cannot be null or empty");
        }
        String cleanVersion = version.replace("-SNAPSHOT", "").replaceFirst("-(alpha\\d+|beta\\d+|rc\\d+)", "");
        String[] parts = cleanVersion.split("\\.");
        if (parts.length < 2) {
            throw new IllegalArgumentException("Invalid version format: " + version);
        }
        try {
            int major = Integer.parseInt(parts[0]);
            int minor = Integer.parseInt(parts[1]);
            int revision = parts.length > 2 ? Integer.parseInt(parts[2]) : 0;
            return new RemoteVersion(major, minor, revision, isOpenSearch);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid version format: " + version, e);
        }
    }

    public boolean before(RemoteVersion other) {
        return this.compareTo(other) < 0;
    }

    public boolean onOrAfter(RemoteVersion other) {
        return this.compareTo(other) >= 0;
    }

    public boolean onOrBefore(RemoteVersion other) {
        return this.compareTo(other) <= 0;
    }

    public boolean after(RemoteVersion other) {
        return this.compareTo(other) > 0;
    }

    @Override
    public int compareTo(RemoteVersion other) {
        if (other == null) {
            return 1;
        }
        if (this.isOpenSearch != other.isOpenSearch) {
            return this.isOpenSearch ? 1 : -1;
        }
        int result = Integer.compare(this.major, other.major);
        if (result != 0) {
            return result;
        }
        result = Integer.compare(this.minor, other.minor);
        if (result != 0) {
            return result;
        }
        return Integer.compare(this.revision, other.revision);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteVersion that = (RemoteVersion)obj;
        return this.major == that.major && this.minor == that.minor && this.revision == that.revision && Objects.equals(this.isOpenSearch, that.isOpenSearch);
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.revision, this.isOpenSearch);
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.revision;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getRevision() {
        return this.revision;
    }
}

