/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.resources.api.list;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.security.dlic.rest.api.Responses;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.resources.ResourcePluginInfo;
import org.opensearch.security.setting.OpensearchDynamicSetting;
import org.opensearch.transport.client.node.NodeClient;

public class ResourceTypesRestAction
extends BaseRestHandler {
    private static final Logger LOGGER = LogManager.getLogger(ResourceTypesRestAction.class);
    private final ResourcePluginInfo resourcePluginInfo;
    private final OpensearchDynamicSetting<Boolean> resourceSharingEnabledSetting;

    public ResourceTypesRestAction(ResourcePluginInfo resourcePluginInfo, OpensearchDynamicSetting<Boolean> resourceSharingEnabledSetting) {
        this.resourcePluginInfo = resourcePluginInfo;
        this.resourceSharingEnabledSetting = resourceSharingEnabledSetting;
    }

    public List<RestHandler.Route> routes() {
        return Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/types")), "/_plugins/_security/api/resource");
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!this.resourceSharingEnabledSetting.getDynamicSettingValue().booleanValue()) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.NOT_IMPLEMENTED, "Feature disabled."));
        }
        return channel -> {
            try (XContentBuilder builder = channel.newBuilder();){
                builder.startObject();
                builder.startArray("types");
                for (ResourcePluginInfo.ResourceDashboardInfo p : this.resourcePluginInfo.getResourceTypes()) {
                    p.toXContent(builder, ToXContent.EMPTY_PARAMS);
                }
                builder.endArray();
                builder.endObject();
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, builder));
            }
            catch (Exception e) {
                this.handleErrorResponse((RestChannel)channel, e);
            }
        };
    }

    private void handleErrorResponse(RestChannel channel, Exception e) {
        LOGGER.error("Error while processing request", (Throwable)e);
        String message = e.getMessage();
        if (e instanceof OpenSearchStatusException) {
            OpenSearchStatusException ex = (OpenSearchStatusException)e;
            Responses.response(channel, ex.status(), message);
        } else {
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, message));
        }
    }
}

