/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.security.configuration.ConfigurationRepository;
import org.opensearch.security.privileges.RoleMapper;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.securityconf.impl.v7.ConfigV7;
import org.opensearch.security.securityconf.impl.v7.RoleMappingsV7;
import org.opensearch.security.support.HostResolverMode;
import org.opensearch.security.support.WildcardMatcher;
import org.opensearch.security.user.User;

public class ConfigurableRoleMapper
implements RoleMapper {
    private static final Logger log = LogManager.getLogger(ConfigurableRoleMapper.class);
    private final AtomicReference<CompiledConfiguration> activeConfiguration = new AtomicReference();

    public ConfigurableRoleMapper(ConfigurationRepository configurationRepository, ResolutionMode resolutionMode) {
        if (configurationRepository != null) {
            configurationRepository.subscribeOnChange(configMap -> {
                HostResolverMode hostResolverMode = ConfigurableRoleMapper.getHostResolverMode(configurationRepository.getConfiguration(CType.CONFIG));
                SecurityDynamicConfiguration<RoleMappingsV7> rawRoleMappingConfiguration = configurationRepository.getConfiguration(CType.ROLESMAPPING);
                if (rawRoleMappingConfiguration == null) {
                    rawRoleMappingConfiguration = SecurityDynamicConfiguration.empty(CType.ROLESMAPPING);
                }
                this.activeConfiguration.set(new CompiledConfiguration(rawRoleMappingConfiguration, hostResolverMode, resolutionMode));
            });
        }
    }

    public ConfigurableRoleMapper(ConfigurationRepository configurationRepository, Settings settings) {
        this(configurationRepository, ResolutionMode.fromSettings(settings));
    }

    @Override
    public ImmutableSet<String> map(User user, TransportAddress caller) {
        CompiledConfiguration activeConfiguration = this.activeConfiguration.get();
        if (activeConfiguration != null) {
            return activeConfiguration.map(user, caller);
        }
        return ImmutableSet.of();
    }

    static HostResolverMode getHostResolverMode(SecurityDynamicConfiguration<ConfigV7> configConfig) {
        HostResolverMode defaultValue = HostResolverMode.IP_HOSTNAME;
        if (configConfig == null) {
            return defaultValue;
        }
        ConfigV7 config = configConfig.getCEntry(CType.CONFIG.name());
        if (config == null || config.dynamic == null) {
            return defaultValue;
        }
        return HostResolverMode.fromConfig(config.dynamic.hosts_resolver_mode);
    }

    static enum ResolutionMode {
        MAPPING_ONLY,
        BACKENDROLES_ONLY,
        BOTH;


        static ResolutionMode fromSettings(Settings settings) {
            try {
                return ResolutionMode.valueOf(settings.get("plugins.security.roles_mapping_resolution", MAPPING_ONLY.toString()).toUpperCase());
            }
            catch (Exception e) {
                log.error("Cannot apply roles mapping resolution", (Throwable)e);
                return MAPPING_ONLY;
            }
        }
    }

    static class CompiledConfiguration
    implements RoleMapper {
        private final ResolutionMode resolutionMode;
        private final HostResolverMode hostResolverMode;
        private ListMultimap<String, String> users;
        private ListMultimap<List<WildcardMatcher>, String> abars;
        private ListMultimap<String, String> bars;
        private ListMultimap<String, String> hosts;
        private List<WildcardMatcher> userMatchers;
        private List<WildcardMatcher> barMatchers;
        private List<WildcardMatcher> hostMatchers;

        CompiledConfiguration(SecurityDynamicConfiguration<RoleMappingsV7> rolemappings, HostResolverMode hostResolverMode, ResolutionMode resolutionMode) {
            this.hostResolverMode = hostResolverMode;
            this.resolutionMode = resolutionMode;
            this.users = ArrayListMultimap.create();
            this.abars = ArrayListMultimap.create();
            this.bars = ArrayListMultimap.create();
            this.hosts = ArrayListMultimap.create();
            for (Map.Entry<String, RoleMappingsV7> roleMap : rolemappings.getCEntries().entrySet()) {
                String roleMapKey = roleMap.getKey();
                RoleMappingsV7 roleMapValue = roleMap.getValue();
                for (String u : roleMapValue.getUsers()) {
                    this.users.put((Object)u, (Object)roleMapKey);
                }
                HashSet<String> abar = new HashSet<String>(roleMapValue.getAnd_backend_roles());
                if (!abar.isEmpty()) {
                    this.abars.put(WildcardMatcher.matchers(abar), (Object)roleMapKey);
                }
                for (String bar : roleMapValue.getBackend_roles()) {
                    this.bars.put((Object)bar, (Object)roleMapKey);
                }
                for (String host : roleMapValue.getHosts()) {
                    this.hosts.put((Object)host, (Object)roleMapKey);
                }
            }
            this.userMatchers = WildcardMatcher.matchers(this.users.keySet());
            this.barMatchers = WildcardMatcher.matchers(this.bars.keySet());
            this.hostMatchers = WildcardMatcher.matchers(this.hosts.keySet());
        }

        @Override
        public ImmutableSet<String> map(User user, TransportAddress caller) {
            if (user == null) {
                return ImmutableSet.of();
            }
            ImmutableSet.Builder result = ImmutableSet.builderWithExpectedSize((int)(user.getSecurityRoles().size() + user.getRoles().size()));
            result.addAll(user.getSecurityRoles());
            if (this.resolutionMode == ResolutionMode.BOTH || this.resolutionMode == ResolutionMode.BACKENDROLES_ONLY) {
                result.addAll(user.getRoles());
            }
            if (this.resolutionMode == ResolutionMode.BOTH || this.resolutionMode == ResolutionMode.MAPPING_ONLY) {
                for (String p2 : WildcardMatcher.getAllMatchingPatterns(this.userMatchers, user.getName())) {
                    result.addAll((Iterable)this.users.get((Object)p2));
                }
                for (String p2 : WildcardMatcher.getAllMatchingPatterns(this.barMatchers, user.getRoles())) {
                    result.addAll((Iterable)this.bars.get((Object)p2));
                }
                for (Object patterns : this.abars.keySet()) {
                    if (!patterns.stream().allMatch(p -> p.matchAny((Collection<String>)user.getRoles()))) continue;
                    result.addAll((Iterable)this.abars.get(patterns));
                }
                if (caller != null) {
                    String ipAddress = caller.getAddress();
                    for (String p3 : WildcardMatcher.getAllMatchingPatterns(this.hostMatchers, ipAddress)) {
                        result.addAll((Iterable)this.hosts.get((Object)p3));
                    }
                    if (caller.address() != null && (this.hostResolverMode == HostResolverMode.IP_HOSTNAME || this.hostResolverMode == HostResolverMode.IP_HOSTNAME_LOOKUP)) {
                        String hostName = caller.address().getHostString();
                        for (String p4 : WildcardMatcher.getAllMatchingPatterns(this.hostMatchers, hostName)) {
                            result.addAll((Iterable)this.hosts.get((Object)p4));
                        }
                    }
                    if (caller.address() != null && this.hostResolverMode == HostResolverMode.IP_HOSTNAME_LOOKUP) {
                        String resolvedHostName = caller.address().getHostName();
                        for (String p4 : WildcardMatcher.getAllMatchingPatterns(this.hostMatchers, resolvedHostName)) {
                            result.addAll((Iterable)this.hosts.get((Object)p4));
                        }
                    }
                }
            }
            return result.build();
        }
    }
}

