/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.time.Duration;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.jspecify.annotations.Nullable;
import reactor.core.CoreSubscriber;
import reactor.core.Exceptions;
import reactor.core.Scannable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.core.publisher.SourceProducer;

final class MonoSingleCallable<T>
extends Mono<T>
implements Callable<T>,
SourceProducer<T> {
    final Callable<? extends @Nullable T> callable;
    final @Nullable T defaultValue;

    MonoSingleCallable(Callable<? extends @Nullable T> source) {
        this.callable = Objects.requireNonNull(source, "source");
        this.defaultValue = null;
    }

    MonoSingleCallable(Callable<? extends T> source, T defaultValue) {
        this.callable = Objects.requireNonNull(source, "source");
        this.defaultValue = Objects.requireNonNull(defaultValue, "defaultValue");
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        Operators.MonoInnerProducerBase<T> sds = new Operators.MonoInnerProducerBase<T>(actual);
        actual.onSubscribe(sds);
        if (sds.isCancelled()) {
            return;
        }
        try {
            T t = this.callable.call();
            if (t != null) {
                sds.complete(t);
            } else if (this.defaultValue != null) {
                sds.complete(this.defaultValue);
            } else {
                actual.onError(new NoSuchElementException("Source was empty"));
            }
        }
        catch (Throwable e) {
            actual.onError(Operators.onOperatorError(e, actual.currentContext()));
        }
    }

    @Override
    public T block() {
        return this.block(Duration.ZERO);
    }

    @Override
    public T block(Duration m) {
        T v;
        try {
            v = this.callable.call();
        }
        catch (Throwable e) {
            throw Exceptions.propagate(e);
        }
        if (v != null) {
            return v;
        }
        if (this.defaultValue != null) {
            return this.defaultValue;
        }
        throw new NoSuchElementException("Source was empty");
    }

    @Override
    public T call() throws Exception {
        T v = this.callable.call();
        if (v != null) {
            return v;
        }
        if (this.defaultValue != null) {
            return this.defaultValue;
        }
        throw new NoSuchElementException("Source was empty");
    }

    @Override
    public @Nullable Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return SourceProducer.super.scanUnsafe(key);
    }
}

