/*
 * Decompiled with CFR 0.152.
 */
package ciir.umass.edu.learning;

import ciir.umass.edu.learning.DataPoint;
import ciir.umass.edu.utilities.Sorter;
import java.util.List;

public class RankList {
    protected DataPoint[] rl = null;

    public RankList(List<DataPoint> rl) {
        this.rl = new DataPoint[rl.size()];
        for (int i = 0; i < rl.size(); ++i) {
            this.rl[i] = rl.get(i);
        }
    }

    public RankList(RankList rl) {
        this.rl = new DataPoint[rl.size()];
        for (int i = 0; i < rl.size(); ++i) {
            this.rl[i] = rl.get(i);
        }
    }

    public RankList(RankList rl, int[] idx) {
        this.rl = new DataPoint[rl.size()];
        for (int i = 0; i < idx.length; ++i) {
            this.rl[i] = rl.get(idx[i]);
        }
    }

    public RankList(RankList rl, int[] idx, int offset) {
        this.rl = new DataPoint[rl.size()];
        for (int i = 0; i < idx.length; ++i) {
            this.rl[i] = rl.get(idx[i] - offset);
        }
    }

    public String getID() {
        return this.get(0).getID();
    }

    public int size() {
        return this.rl.length;
    }

    public DataPoint get(int k) {
        return this.rl[k];
    }

    public void set(int k, DataPoint p) {
        this.rl[k] = p;
    }

    public RankList getCorrectRanking() {
        double[] score = new double[this.rl.length];
        for (int i = 0; i < this.rl.length; ++i) {
            score[i] = this.rl[i].getLabel();
        }
        int[] idx = Sorter.sort(score, false);
        return new RankList(this, idx);
    }

    public RankList getRanking(short fid) {
        double[] score = new double[this.rl.length];
        for (int i = 0; i < this.rl.length; ++i) {
            score[i] = this.rl[i].getFeatureValue(fid);
        }
        int[] idx = Sorter.sort(score, false);
        return new RankList(this, idx);
    }
}

