/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.httpclient;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.amazon.awssdk.http.async.AsyncExecuteRequest;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;

public class MLValidatableAsyncHttpClient
implements SdkAsyncHttpClient {
    @Generated
    private static final Logger log = LogManager.getLogger(MLValidatableAsyncHttpClient.class);
    private final SdkAsyncHttpClient delegate;
    private final boolean connectorPrivateIpEnabled;

    protected MLValidatableAsyncHttpClient(SdkAsyncHttpClient client, boolean connectorPrivateIpEnabled) {
        this.delegate = client;
        this.connectorPrivateIpEnabled = connectorPrivateIpEnabled;
    }

    public CompletableFuture<Void> execute(AsyncExecuteRequest request) {
        String protocol = request.request().protocol();
        String host = request.request().host();
        int port = request.request().port();
        try {
            this.validate(protocol, host, port, this.connectorPrivateIpEnabled);
            return this.delegate.execute(request);
        }
        catch (Exception e) {
            log.error("Failed to validate request!", (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public void close() {
        this.delegate.close();
    }

    public void validate(String protocol, String host, int port, boolean connectorPrivateIpEnabled) throws UnknownHostException {
        if (protocol != null && !"http".equalsIgnoreCase(protocol) && !"https".equalsIgnoreCase(protocol)) {
            log.error("Remote inference protocol is not http or https: {}", (Object)protocol);
            throw new IllegalArgumentException("Protocol is not http or https: " + protocol);
        }
        if (port == -1) {
            port = protocol == null || "http".equals(protocol.toLowerCase(Locale.getDefault())) ? 80 : 443;
        }
        if (port < 0 || port > 65536) {
            log.error("Remote inference port out of range: {}", (Object)port);
            throw new IllegalArgumentException("Port out of range: " + port);
        }
        this.validateIp(host, connectorPrivateIpEnabled);
    }

    private void validateIp(String hostName, boolean connectorPrivateIpEnabled) throws UnknownHostException {
        InetAddress[] addresses = InetAddress.getAllByName(hostName);
        if (!connectorPrivateIpEnabled && this.hasPrivateIpAddress(addresses)) {
            log.error("Remote inference host name has private ip address: {}", (Object)hostName);
            throw new IllegalArgumentException("Remote inference host name has private ip address: " + hostName);
        }
    }

    private boolean hasPrivateIpAddress(InetAddress[] ipAddress) {
        for (InetAddress ip : ipAddress) {
            if (!(ip instanceof Inet4Address)) continue;
            byte[] bytes = ip.getAddress();
            if (bytes.length != 4) {
                return true;
            }
            if (!this.isPrivateIPv4(bytes)) continue;
            return true;
        }
        return Arrays.stream(ipAddress).anyMatch(x -> x.isSiteLocalAddress() || x.isLoopbackAddress() || x.isAnyLocalAddress());
    }

    private boolean isPrivateIPv4(byte[] bytes) {
        int first = bytes[0] & 0xFF;
        int second = bytes[1] & 0xFF;
        return first == 10 || first == 172 && second >= 16 && second <= 31 || first == 192 && second == 168 || first == 169 && second == 254;
    }
}

