/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.memoryoptsearch.faiss;

import java.io.IOException;
import lombok.Generated;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.store.IndexInput;
import org.opensearch.knn.memoryoptsearch.faiss.MMapVectorValues;

public class MMapByteVectorValues
extends ByteVectorValues
implements MMapVectorValues {
    private final IndexInput indexInput;
    private final long oneVectorByteSize;
    private final long baseOffset;
    private final int dimension;
    private final int totalNumberOfVectors;
    private final long[] addressAndSize;
    private byte[] buffer;

    public MMapByteVectorValues(IndexInput indexInput, long oneVectorByteSize, long baseOffset, int dimension, int totalNumberOfVectors, long[] addressAndSize) {
        this.indexInput = indexInput;
        this.oneVectorByteSize = oneVectorByteSize;
        this.baseOffset = baseOffset;
        this.dimension = dimension;
        this.totalNumberOfVectors = totalNumberOfVectors;
        if (addressAndSize == null || addressAndSize.length == 0) {
            throw new IllegalArgumentException("Empty `addressAndSize` was provided in " + MMapByteVectorValues.class.getSimpleName() + ". Is null?=" + (addressAndSize == null));
        }
        this.addressAndSize = addressAndSize;
    }

    public byte[] vectorValue(int internalVectorId) throws IOException {
        this.indexInput.seek(this.baseOffset + (long)internalVectorId * this.oneVectorByteSize);
        if (this.buffer == null) {
            this.buffer = new byte[(int)this.oneVectorByteSize];
        }
        this.indexInput.readBytes(this.buffer, 0, this.buffer.length);
        return this.buffer;
    }

    public int dimension() {
        return this.dimension;
    }

    public int size() {
        return this.totalNumberOfVectors;
    }

    public ByteVectorValues copy() throws IOException {
        return new MMapByteVectorValues(this.indexInput.clone(), this.oneVectorByteSize, this.baseOffset, this.dimension, this.totalNumberOfVectors, this.addressAndSize);
    }

    @Override
    @Generated
    public long[] getAddressAndSize() {
        return this.addressAndSize;
    }
}

