/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.dynamodb.model;

import java.util.Objects;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.BeaconStyle;

public class StandardBeacon {
    private final String name;
    private final int length;
    private final String loc;
    private final BeaconStyle style;

    protected StandardBeacon(BuilderImpl builder) {
        this.name = builder.name();
        this.length = builder.length();
        this.loc = builder.loc();
        this.style = builder.style();
    }

    public String name() {
        return this.name;
    }

    public int length() {
        return this.length;
    }

    public String loc() {
        return this.loc;
    }

    public BeaconStyle style() {
        return this.style;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String name;
        protected int length;
        private boolean _lengthSet = false;
        protected String loc;
        protected BeaconStyle style;

        protected BuilderImpl() {
        }

        protected BuilderImpl(StandardBeacon model) {
            this.name = model.name();
            this.length = model.length();
            this._lengthSet = true;
            this.loc = model.loc();
            this.style = model.style();
        }

        @Override
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Builder length(int length) {
            this.length = length;
            this._lengthSet = true;
            return this;
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public Builder loc(String loc) {
            this.loc = loc;
            return this;
        }

        @Override
        public String loc() {
            return this.loc;
        }

        @Override
        public Builder style(BeaconStyle style) {
            this.style = style;
            return this;
        }

        @Override
        public BeaconStyle style() {
            return this.style;
        }

        @Override
        public StandardBeacon build() {
            if (Objects.isNull(this.name())) {
                throw new IllegalArgumentException("Missing value for required field `name`");
            }
            if (!this._lengthSet) {
                throw new IllegalArgumentException("Missing value for required field `length`");
            }
            if (this._lengthSet && this.length() < 1) {
                throw new IllegalArgumentException("`length` must be greater than or equal to 1");
            }
            if (this._lengthSet && this.length() > 63) {
                throw new IllegalArgumentException("`length` must be less than or equal to 63.");
            }
            if (Objects.nonNull(this.loc()) && this.loc().length() < 1) {
                throw new IllegalArgumentException("The size of `loc` must be greater than or equal to 1");
            }
            return new StandardBeacon(this);
        }
    }

    public static interface Builder {
        public Builder name(String var1);

        public String name();

        public Builder length(int var1);

        public int length();

        public Builder loc(String var1);

        public String loc();

        public Builder style(BeaconStyle var1);

        public BeaconStyle style();

        public StandardBeacon build();
    }
}

