/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.dynamodb.model;

import java.util.Objects;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.AsSet;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.PartOnly;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.Shared;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.SharedSet;

public class BeaconStyle {
    private final PartOnly partOnly;
    private final Shared shared;
    private final AsSet asSet;
    private final SharedSet sharedSet;

    protected BeaconStyle(BuilderImpl builder) {
        this.partOnly = builder.partOnly();
        this.shared = builder.shared();
        this.asSet = builder.asSet();
        this.sharedSet = builder.sharedSet();
    }

    public PartOnly partOnly() {
        return this.partOnly;
    }

    public Shared shared() {
        return this.shared;
    }

    public AsSet asSet() {
        return this.asSet;
    }

    public SharedSet sharedSet() {
        return this.sharedSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected PartOnly partOnly;
        protected Shared shared;
        protected AsSet asSet;
        protected SharedSet sharedSet;

        protected BuilderImpl() {
        }

        protected BuilderImpl(BeaconStyle model) {
            this.partOnly = model.partOnly();
            this.shared = model.shared();
            this.asSet = model.asSet();
            this.sharedSet = model.sharedSet();
        }

        @Override
        public Builder partOnly(PartOnly partOnly) {
            this.partOnly = partOnly;
            return this;
        }

        @Override
        public PartOnly partOnly() {
            return this.partOnly;
        }

        @Override
        public Builder shared(Shared shared) {
            this.shared = shared;
            return this;
        }

        @Override
        public Shared shared() {
            return this.shared;
        }

        @Override
        public Builder asSet(AsSet asSet) {
            this.asSet = asSet;
            return this;
        }

        @Override
        public AsSet asSet() {
            return this.asSet;
        }

        @Override
        public Builder sharedSet(SharedSet sharedSet) {
            this.sharedSet = sharedSet;
            return this;
        }

        @Override
        public SharedSet sharedSet() {
            return this.sharedSet;
        }

        @Override
        public BeaconStyle build() {
            if (!this.onlyOneNonNull()) {
                throw new IllegalArgumentException("`BeaconStyle` is a Union. A Union MUST have one and only one value set.");
            }
            return new BeaconStyle(this);
        }

        private boolean onlyOneNonNull() {
            Object[] allValues = new Object[]{this.partOnly, this.shared, this.asSet, this.sharedSet};
            boolean haveOneNonNull = false;
            for (Object o : allValues) {
                if (!Objects.nonNull(o)) continue;
                if (haveOneNonNull) {
                    return false;
                }
                haveOneNonNull = true;
            }
            return haveOneNonNull;
        }
    }

    public static interface Builder {
        public Builder partOnly(PartOnly var1);

        public PartOnly partOnly();

        public Builder shared(Shared var1);

        public Shared shared();

        public Builder asSet(AsSet var1);

        public AsSet asSet();

        public Builder sharedSet(SharedSet var1);

        public SharedSet sharedSet();

        public BeaconStyle build();
    }
}

