/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.dynamodb.itemencryptor.model;

import java.util.Map;
import java.util.Objects;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.itemencryptor.model.ParsedHeader;

public class EncryptItemOutput {
    private final Map<String, AttributeValue> encryptedItem;
    private final ParsedHeader parsedHeader;

    protected EncryptItemOutput(BuilderImpl builder) {
        this.encryptedItem = builder.encryptedItem();
        this.parsedHeader = builder.parsedHeader();
    }

    public Map<String, AttributeValue> encryptedItem() {
        return this.encryptedItem;
    }

    public ParsedHeader parsedHeader() {
        return this.parsedHeader;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected Map<String, AttributeValue> encryptedItem;
        protected ParsedHeader parsedHeader;

        protected BuilderImpl() {
        }

        protected BuilderImpl(EncryptItemOutput model) {
            this.encryptedItem = model.encryptedItem();
            this.parsedHeader = model.parsedHeader();
        }

        @Override
        public Builder encryptedItem(Map<String, AttributeValue> encryptedItem) {
            this.encryptedItem = encryptedItem;
            return this;
        }

        @Override
        public Map<String, AttributeValue> encryptedItem() {
            return this.encryptedItem;
        }

        @Override
        public Builder parsedHeader(ParsedHeader parsedHeader) {
            this.parsedHeader = parsedHeader;
            return this;
        }

        @Override
        public ParsedHeader parsedHeader() {
            return this.parsedHeader;
        }

        @Override
        public EncryptItemOutput build() {
            if (Objects.isNull(this.encryptedItem())) {
                throw new IllegalArgumentException("Missing value for required field `encryptedItem`");
            }
            return new EncryptItemOutput(this);
        }
    }

    public static interface Builder {
        public Builder encryptedItem(Map<String, AttributeValue> var1);

        public Map<String, AttributeValue> encryptedItem();

        public Builder parsedHeader(ParsedHeader var1);

        public ParsedHeader parsedHeader();

        public EncryptItemOutput build();
    }
}

