/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.transport;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.join.ScoreMode;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.alerting.model.Table;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.search.sort.FieldSortBuilder;
import org.opensearch.search.sort.SortBuilder;
import org.opensearch.search.sort.SortBuilders;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.securityanalytics.model.threatintel.IocFinding;
import org.opensearch.securityanalytics.settings.SecurityAnalyticsSettings;
import org.opensearch.securityanalytics.threatIntel.action.GetIocFindingsRequest;
import org.opensearch.securityanalytics.threatIntel.action.GetIocFindingsResponse;
import org.opensearch.securityanalytics.threatIntel.iocscan.dao.IocFindingService;
import org.opensearch.securityanalytics.transport.SecureTransportAction;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class TransportGetIocFindingsAction
extends HandledTransportAction<GetIocFindingsRequest, GetIocFindingsResponse>
implements SecureTransportAction {
    private final IocFindingService iocFindingService;
    private final ClusterService clusterService;
    private final Settings settings;
    private final NamedXContentRegistry xContentRegistry;
    private final ThreadPool threadPool;
    private volatile Boolean filterByEnabled;

    @Inject
    public TransportGetIocFindingsAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, Settings settings, NamedXContentRegistry xContentRegistry, Client client) {
        super("cluster:admin/opensearch/securityanalytics/threatintel/iocs/findings/get", transportService, actionFilters, GetIocFindingsRequest::new);
        this.settings = settings;
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        this.threadPool = client.threadPool();
        this.iocFindingService = new IocFindingService(client, this.clusterService, xContentRegistry);
        this.filterByEnabled = (Boolean)SecurityAnalyticsSettings.FILTER_BY_BACKEND_ROLES.get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(SecurityAnalyticsSettings.FILTER_BY_BACKEND_ROLES, this::setFilterByEnabled);
    }

    protected void doExecute(Task task, GetIocFindingsRequest request, final ActionListener<GetIocFindingsResponse> actionListener) {
        List<String> iocIds;
        User user = this.readUserFromThreadContext(this.threadPool);
        String validateBackendRoleMessage = this.validateUserBackendRoles(user, this.filterByEnabled);
        if (!"".equals(validateBackendRoleMessage)) {
            actionListener.onFailure((Exception)new OpenSearchStatusException("Do not have permissions to resource", RestStatus.FORBIDDEN, new Object[0]));
            return;
        }
        this.threadPool.getThreadContext().stashContext();
        Table tableProp = request.getTable();
        FieldSortBuilder sortBuilder = (FieldSortBuilder)SortBuilders.fieldSort((String)tableProp.getSortString()).order(SortOrder.fromString((String)tableProp.getSortOrder()));
        if (tableProp.getMissing() != null && !tableProp.getMissing().isBlank()) {
            sortBuilder.missing((Object)tableProp.getMissing());
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().sort((SortBuilder)sortBuilder).size(tableProp.getSize()).from(tableProp.getStartIndex()).fetchSource(new FetchSourceContext(true, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY)).seqNoAndPrimaryTerm(Boolean.valueOf(true)).version(Boolean.valueOf(true));
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        List<String> findingIds = request.getFindingIds();
        if (findingIds != null && !findingIds.isEmpty()) {
            BoolQueryBuilder findingIdsFilter = QueryBuilders.boolQuery();
            findingIds.forEach(it -> findingIdsFilter.should((QueryBuilder)QueryBuilders.matchQuery((String)"_id", (Object)it)));
            queryBuilder.filter((QueryBuilder)findingIdsFilter);
        }
        if ((iocIds = request.getIocIds()) != null && !iocIds.isEmpty()) {
            BoolQueryBuilder iocIdQueryBuilder = QueryBuilders.boolQuery();
            iocIds.forEach(it -> iocIdQueryBuilder.should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"ioc_feed_ids.ioc_id", (Object)it)));
            queryBuilder.filter((QueryBuilder)iocIdQueryBuilder);
        }
        Instant startTime = request.getStartTime();
        Instant endTime = request.getEndTime();
        if (startTime != null && endTime != null) {
            long startTimeMillis = startTime.toEpochMilli();
            long endTimeMillis = endTime.toEpochMilli();
            RangeQueryBuilder timeRangeQuery = QueryBuilders.rangeQuery((String)"timestamp").from((Object)startTimeMillis).to((Object)endTimeMillis);
            queryBuilder.filter((QueryBuilder)timeRangeQuery);
        }
        if (tableProp.getSearchString() != null && !tableProp.getSearchString().isBlank()) {
            queryBuilder.should((QueryBuilder)QueryBuilders.queryStringQuery((String)tableProp.getSearchString())).should((QueryBuilder)QueryBuilders.nestedQuery((String)"queries", (QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.queryStringQuery((String)tableProp.getSearchString())), (ScoreMode)ScoreMode.Avg));
        }
        searchSourceBuilder.query((QueryBuilder)queryBuilder).trackTotalHits(true);
        this.threadPool.getThreadContext().stashContext();
        this.iocFindingService.search(searchSourceBuilder, new ActionListener<SearchResponse>(this){
            final /* synthetic */ TransportGetIocFindingsAction this$0;
            {
                this.this$0 = this$0;
            }

            public void onResponse(SearchResponse searchResponse) {
                try {
                    long totalIocFindingsCount = searchResponse.getHits().getTotalHits().value();
                    ArrayList<IocFinding> iocFindings = new ArrayList<IocFinding>();
                    for (SearchHit hit : searchResponse.getHits()) {
                        XContentParser xcp = XContentType.JSON.xContent().createParser(this.this$0.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, hit.getSourceAsString());
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
                        IocFinding iocFinding = IocFinding.parse(xcp);
                        iocFindings.add(iocFinding);
                    }
                    actionListener.onResponse((Object)new GetIocFindingsResponse((int)totalIocFindingsCount, iocFindings));
                }
                catch (Exception ex) {
                    this.onFailure(ex);
                }
            }

            public void onFailure(Exception e) {
                if (e instanceof IndexNotFoundException) {
                    actionListener.onResponse((Object)new GetIocFindingsResponse(0, List.of()));
                    return;
                }
                actionListener.onFailure(e);
            }
        });
    }

    private void setFilterByEnabled(boolean filterByEnabled) {
        this.filterByEnabled = filterByEnabled;
    }
}

