/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.action;

import java.io.IOException;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.securityanalytics.model.CustomLogType;

public class IndexCustomLogTypeResponse
extends ActionResponse
implements ToXContentObject {
    public static final String CUSTOM_LOG_TYPES_FIELD = "logType";
    private String id;
    private Long version;
    private RestStatus status;
    private CustomLogType customLogType;

    public IndexCustomLogTypeResponse(String id, Long version, RestStatus status, CustomLogType customLogType) {
        this.id = id;
        this.version = version;
        this.status = status;
        this.customLogType = customLogType;
    }

    public IndexCustomLogTypeResponse(StreamInput sin) throws IOException {
        this(sin.readString(), sin.readLong(), (RestStatus)sin.readEnum(RestStatus.class), CustomLogType.readFrom(sin));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeLong(this.version.longValue());
        out.writeEnum((Enum)this.status);
        this.customLogType.writeTo(out);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field("_id", this.id).field("_version", this.version).field(CUSTOM_LOG_TYPES_FIELD, (ToXContent)this.customLogType).endObject();
    }

    public String getId() {
        return this.id;
    }
}

