/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.workflow;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.exception.WorkflowStepException;
import org.opensearch.flowframework.indices.FlowFrameworkIndicesHandler;
import org.opensearch.flowframework.util.ParseUtils;
import org.opensearch.flowframework.workflow.WorkflowData;
import org.opensearch.flowframework.workflow.WorkflowStep;
import org.opensearch.ml.client.MachineLearningNodeClient;
import org.opensearch.ml.common.AccessMode;
import org.opensearch.ml.common.transport.model_group.MLRegisterModelGroupInput;
import org.opensearch.ml.common.transport.model_group.MLRegisterModelGroupResponse;

public class RegisterModelGroupStep
implements WorkflowStep {
    private static final Logger logger = LogManager.getLogger(RegisterModelGroupStep.class);
    private final MachineLearningNodeClient mlClient;
    private final FlowFrameworkIndicesHandler flowFrameworkIndicesHandler;
    public static final String NAME = "register_model_group";

    public RegisterModelGroupStep(MachineLearningNodeClient mlClient, FlowFrameworkIndicesHandler flowFrameworkIndicesHandler) {
        this.mlClient = mlClient;
        this.flowFrameworkIndicesHandler = flowFrameworkIndicesHandler;
    }

    @Override
    public PlainActionFuture<WorkflowData> execute(final String currentNodeId, final WorkflowData currentNodeInputs, Map<String, WorkflowData> outputs, Map<String, String> previousNodeInputs, Map<String, String> params, final String tenantId) {
        final PlainActionFuture registerModelGroupFuture = PlainActionFuture.newFuture();
        ActionListener<MLRegisterModelGroupResponse> actionListener = new ActionListener<MLRegisterModelGroupResponse>(this){
            final /* synthetic */ RegisterModelGroupStep this$0;
            {
                this.this$0 = this$0;
            }

            public void onResponse(MLRegisterModelGroupResponse mlRegisterModelGroupResponse) {
                logger.info("Model group registration successful");
                ActionListener resourceListener = ActionListener.wrap(r -> {
                    HashMap<String, Object> content = new HashMap<String, Object>(r.getContent());
                    content.put("model_group_status", mlRegisterModelGroupResponse.getStatus());
                    registerModelGroupFuture.onResponse((Object)new WorkflowData(content, r.getWorkflowId(), r.getNodeId()));
                }, arg_0 -> ((PlainActionFuture)registerModelGroupFuture).onFailure(arg_0));
                this.this$0.flowFrameworkIndicesHandler.addResourceToStateIndex(currentNodeInputs, currentNodeId, this.this$0.getName(), mlRegisterModelGroupResponse.getModelGroupId(), tenantId, (ActionListener<WorkflowData>)resourceListener);
            }

            public void onFailure(Exception ex) {
                Exception e = WorkflowStepException.getSafeException(ex);
                String errorMessage = e == null ? "Failed to register model group" : e.getMessage();
                logger.error(errorMessage, (Throwable)e);
                registerModelGroupFuture.onFailure((Exception)((Object)new WorkflowStepException(errorMessage, ExceptionsHelper.status((Throwable)e))));
            }
        };
        Set<String> requiredKeys = Set.of("name");
        Set<String> optionalKeys = Set.of("description", "backend_roles", "access_mode", "add_all_backend_roles");
        try {
            Map<String, Object> inputs = ParseUtils.getInputsFromPreviousSteps(requiredKeys, optionalKeys, currentNodeInputs, outputs, previousNodeInputs, params);
            String modelGroupName = (String)inputs.get("name");
            String description = (String)inputs.get("description");
            List<String> backendRoles = this.getBackendRoles(inputs);
            AccessMode modelAccessMode = null;
            if (inputs.containsKey("access_mode")) {
                modelAccessMode = AccessMode.from((String)inputs.get("access_mode").toString().toLowerCase(Locale.ROOT));
            }
            Boolean isAddAllBackendRoles = ParseUtils.parseIfExists(inputs, "add_all_backend_roles", Boolean.class);
            MLRegisterModelGroupInput.MLRegisterModelGroupInputBuilder builder = MLRegisterModelGroupInput.builder();
            builder.name(modelGroupName);
            builder.tenantId(tenantId);
            if (description != null) {
                builder.description(description);
            }
            if (!CollectionUtils.isEmpty(backendRoles)) {
                builder.backendRoles(backendRoles);
            }
            if (modelAccessMode != null) {
                builder.modelAccessMode(modelAccessMode);
            }
            if (isAddAllBackendRoles != null) {
                builder.isAddAllBackendRoles(isAddAllBackendRoles);
            }
            MLRegisterModelGroupInput mlInput = builder.build();
            this.mlClient.registerModelGroup(mlInput, (ActionListener)actionListener);
        }
        catch (IllegalArgumentException iae) {
            registerModelGroupFuture.onFailure((Exception)((Object)new WorkflowStepException(iae.getMessage(), RestStatus.BAD_REQUEST)));
        }
        catch (FlowFrameworkException e) {
            registerModelGroupFuture.onFailure((Exception)((Object)e));
        }
        return registerModelGroupFuture;
    }

    @Override
    public String getName() {
        return NAME;
    }

    private List<String> getBackendRoles(Map<String, Object> content) {
        if (content.containsKey("backend_roles")) {
            return (List)content.get("backend_roles");
        }
        return Collections.emptyList();
    }
}

