/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.indices;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessageFactory;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.opensearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.flowframework.common.CommonValue;
import org.opensearch.flowframework.common.WorkflowResources;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.indices.FlowFrameworkIndex;
import org.opensearch.flowframework.model.ProvisioningProgress;
import org.opensearch.flowframework.model.ResourceCreated;
import org.opensearch.flowframework.model.State;
import org.opensearch.flowframework.model.Template;
import org.opensearch.flowframework.model.WorkflowState;
import org.opensearch.flowframework.util.EncryptorUtils;
import org.opensearch.flowframework.util.ParseUtils;
import org.opensearch.flowframework.workflow.WorkflowData;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.remote.metadata.client.DeleteDataObjectRequest;
import org.opensearch.remote.metadata.client.GetDataObjectRequest;
import org.opensearch.remote.metadata.client.PutDataObjectRequest;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.remote.metadata.client.UpdateDataObjectRequest;
import org.opensearch.remote.metadata.common.SdkClientUtils;
import org.opensearch.transport.client.Client;

public class FlowFrameworkIndicesHandler {
    private static final Logger logger = LogManager.getLogger(FlowFrameworkIndicesHandler.class);
    private final Client client;
    private final SdkClient sdkClient;
    private final ClusterService clusterService;
    private final EncryptorUtils encryptorUtils;
    private static final Map<String, AtomicBoolean> indexMappingUpdated = new HashMap<String, AtomicBoolean>();
    private static final Map<String, Object> indexSettings = Map.of("index.auto_expand_replicas", "0-1");
    private final NamedXContentRegistry xContentRegistry;
    private final boolean multiTenancyEnabled;
    private static final int RETRIES = 5;

    public FlowFrameworkIndicesHandler(Client client, SdkClient sdkClient, ClusterService clusterService, EncryptorUtils encryptorUtils, NamedXContentRegistry xContentRegistry, boolean multiTenancyEnabled) {
        this.client = client;
        this.sdkClient = sdkClient;
        this.clusterService = clusterService;
        this.encryptorUtils = encryptorUtils;
        for (FlowFrameworkIndex mlIndex : FlowFrameworkIndex.values()) {
            indexMappingUpdated.put(mlIndex.getIndexName(), new AtomicBoolean(false));
        }
        this.xContentRegistry = xContentRegistry;
        this.multiTenancyEnabled = multiTenancyEnabled;
    }

    public static String getGlobalContextMappings() throws IOException {
        return FlowFrameworkIndicesHandler.getIndexMappings("mappings/global-context.json");
    }

    public static String getWorkflowStateMappings() throws IOException {
        return FlowFrameworkIndicesHandler.getIndexMappings("mappings/workflow-state.json");
    }

    public static String getConfigIndexMappings() throws IOException {
        return FlowFrameworkIndicesHandler.getIndexMappings("mappings/config.json");
    }

    public void initGlobalContextIndexIfAbsent(ActionListener<Boolean> listener) {
        this.initFlowFrameworkIndexIfAbsent(FlowFrameworkIndex.GLOBAL_CONTEXT, listener);
    }

    public void initWorkflowStateIndexIfAbsent(ActionListener<Boolean> listener) {
        this.initFlowFrameworkIndexIfAbsent(FlowFrameworkIndex.WORKFLOW_STATE, listener);
    }

    public void initConfigIndexIfAbsent(ActionListener<Boolean> listener) {
        this.initFlowFrameworkIndexIfAbsent(FlowFrameworkIndex.CONFIG, listener);
    }

    public boolean doesIndexExist(String indexName) {
        return FlowFrameworkIndicesHandler.doesIndexExistMultitenant(this.clusterService, indexName, this.multiTenancyEnabled);
    }

    public static boolean doesIndexExistMultitenant(ClusterService cs, String index, boolean multiTenancy) {
        return multiTenancy || cs.state().metadata().hasIndex(index);
    }

    public void initFlowFrameworkIndexIfAbsent(FlowFrameworkIndex index, ActionListener<Boolean> listener) {
        String indexName = index.getIndexName();
        String mapping = index.getMapping();
        try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener internalListener = ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)threadContext).restore());
            if (!FlowFrameworkIndicesHandler.doesIndexExistMultitenant(this.clusterService, indexName, this.multiTenancyEnabled)) {
                ActionListener actionListener = ActionListener.wrap(r -> {
                    if (r.isAcknowledged()) {
                        logger.info("create index: {}", (Object)indexName);
                        internalListener.onResponse((Object)true);
                    } else {
                        internalListener.onResponse((Object)false);
                    }
                }, e -> {
                    String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to create index {}", (Object)indexName).getFormattedMessage();
                    logger.error(errorMessage, (Throwable)e);
                    internalListener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)e))));
                });
                CreateIndexRequest request = new CreateIndexRequest(indexName).mapping("{\"_doc\":" + mapping + "}").settings(indexSettings);
                this.client.admin().indices().create(request, actionListener);
            } else {
                logger.debug("index: {} is already created", (Object)indexName);
                if (indexMappingUpdated.containsKey(indexName) && !indexMappingUpdated.get(indexName).get()) {
                    this.shouldUpdateIndex(indexName, index.getVersion(), (ActionListener<Boolean>)ActionListener.wrap(r -> {
                        if (r.booleanValue()) {
                            this.client.admin().indices().putMapping(new PutMappingRequest().indices(new String[]{indexName}).source(mapping, (MediaType)XContentType.JSON), ActionListener.wrap(response -> {
                                if (response.isAcknowledged()) {
                                    UpdateSettingsRequest updateSettingRequest = new UpdateSettingsRequest();
                                    updateSettingRequest.indices(new String[]{indexName}).settings(indexSettings);
                                    this.client.admin().indices().updateSettings(updateSettingRequest, ActionListener.wrap(updateResponse -> {
                                        if (response.isAcknowledged()) {
                                            indexMappingUpdated.get(indexName).set(true);
                                            internalListener.onResponse((Object)true);
                                        } else {
                                            internalListener.onFailure((Exception)((Object)new FlowFrameworkException("Failed to update index setting for: " + indexName, RestStatus.INTERNAL_SERVER_ERROR)));
                                        }
                                    }, exception -> {
                                        String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to update index setting for: {}", (Object)indexName).getFormattedMessage();
                                        logger.error(errorMessage, (Throwable)exception);
                                        internalListener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)exception))));
                                    }));
                                } else {
                                    internalListener.onFailure((Exception)((Object)new FlowFrameworkException("Failed to update index: " + indexName, RestStatus.INTERNAL_SERVER_ERROR)));
                                }
                            }, exception -> {
                                String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to update index {}", (Object)indexName).getFormattedMessage();
                                logger.error(errorMessage, (Throwable)exception);
                                internalListener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)exception))));
                            }));
                        } else {
                            indexMappingUpdated.get(indexName).set(true);
                            internalListener.onResponse((Object)true);
                        }
                    }, e -> {
                        String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to update index mapping for {}", (Object)indexName).getFormattedMessage();
                        logger.error(errorMessage, (Throwable)e);
                        internalListener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)e))));
                    }));
                } else {
                    internalListener.onResponse((Object)true);
                }
            }
        }
        catch (Exception e2) {
            String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to init index {}", (Object)indexName).getFormattedMessage();
            logger.error(errorMessage, (Throwable)e2);
            listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)e2))));
        }
    }

    private void shouldUpdateIndex(String indexName, Integer newVersion, ActionListener<Boolean> listener) {
        Map metaMapping;
        Object schemaVersion;
        IndexMetadata indexMetaData = (IndexMetadata)this.clusterService.state().getMetadata().indices().get(indexName);
        if (indexMetaData == null) {
            listener.onResponse((Object)Boolean.FALSE);
            return;
        }
        Integer oldVersion = CommonValue.NO_SCHEMA_VERSION;
        Map indexMapping = indexMetaData.mapping().getSourceAsMap();
        Object meta = indexMapping.get("_meta");
        if (meta instanceof Map && (schemaVersion = (metaMapping = (Map)meta).get("schema_version")) instanceof Integer) {
            oldVersion = (Integer)schemaVersion;
        }
        listener.onResponse((Object)(newVersion > oldVersion ? 1 : 0));
    }

    public static String getIndexMappings(String mapping) throws IOException {
        return ParseUtils.resourceToString("/" + mapping);
    }

    public void putTemplateToGlobalContext(Template template, ActionListener<IndexResponse> listener) {
        this.initGlobalContextIndexIfAbsent((ActionListener<Boolean>)ActionListener.wrap(indexCreated -> {
            if (!indexCreated.booleanValue()) {
                listener.onFailure((Exception)((Object)new FlowFrameworkException("No response to create global_context index", RestStatus.INTERNAL_SERVER_ERROR)));
                return;
            }
            this.putOrReplaceTemplateInGlobalContextIndex(null, template, listener);
        }, e -> {
            logger.error("Failed to create global_context index");
            listener.onFailure(e);
        }));
    }

    private void putOrReplaceTemplateInGlobalContextIndex(String documentId, Template template, ActionListener<IndexResponse> listener) {
        PutDataObjectRequest request = ((PutDataObjectRequest.Builder)((PutDataObjectRequest.Builder)((PutDataObjectRequest.Builder)PutDataObjectRequest.builder().index(".plugins-flow-framework-templates")).id(documentId)).tenantId(template.getTenantId())).dataObject((ToXContentObject)this.encryptorUtils.encryptTemplateCredentials(template)).build();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.sdkClient.putDataObjectAsync(request).whenComplete((r, throwable) -> {
                context.restore();
                if (throwable == null) {
                    try {
                        IndexResponse indexResponse = IndexResponse.fromXContent((XContentParser)r.parser());
                        listener.onResponse((Object)indexResponse);
                    }
                    catch (IOException e) {
                        String errorMessage = "Failed to parse index response";
                        logger.error(errorMessage, (Throwable)e);
                        listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, RestStatus.INTERNAL_SERVER_ERROR)));
                    }
                } else {
                    Exception exception = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                    String errorMessage = "Failed to index template in global context index";
                    logger.error(errorMessage, (Throwable)exception);
                    listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)exception))));
                }
            });
        }
    }

    public void initializeConfigIndex(String tenantId, ActionListener<Boolean> listener) {
        this.initConfigIndexIfAbsent((ActionListener<Boolean>)ActionListener.wrap(indexCreated -> {
            if (!indexCreated.booleanValue()) {
                listener.onFailure((Exception)((Object)new FlowFrameworkException("No response to create config index", RestStatus.INTERNAL_SERVER_ERROR)));
                return;
            }
            this.encryptorUtils.initializeMasterKey(tenantId, listener);
        }, createIndexException -> {
            logger.error("Failed to create config index");
            listener.onFailure(createIndexException);
        }));
    }

    public void putInitialStateToWorkflowState(String workflowId, String tenantId, User user, ActionListener<IndexResponse> listener) {
        WorkflowState state = WorkflowState.builder().workflowId(workflowId).state(State.NOT_STARTED.name()).provisioningProgress(ProvisioningProgress.NOT_STARTED.name()).user(user).resourcesCreated(Collections.emptyList()).userOutputs(Collections.emptyMap()).tenantId(tenantId).build();
        this.initWorkflowStateIndexIfAbsent((ActionListener<Boolean>)ActionListener.wrap(indexCreated -> {
            if (!indexCreated.booleanValue()) {
                listener.onFailure((Exception)((Object)new FlowFrameworkException("No response to create workflow_state index", RestStatus.INTERNAL_SERVER_ERROR)));
                return;
            }
            PutDataObjectRequest putRequest = ((PutDataObjectRequest.Builder)((PutDataObjectRequest.Builder)((PutDataObjectRequest.Builder)PutDataObjectRequest.builder().index(".plugins-flow-framework-state")).id(workflowId)).tenantId(tenantId)).dataObject((ToXContentObject)state).build();
            try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                this.sdkClient.putDataObjectAsync(putRequest).whenComplete((r, throwable) -> {
                    context.restore();
                    if (throwable == null) {
                        try {
                            IndexResponse indexResponse = IndexResponse.fromXContent((XContentParser)r.parser());
                            listener.onResponse((Object)indexResponse);
                        }
                        catch (IOException e) {
                            logger.error("Failed to parse index response", (Throwable)e);
                            listener.onFailure((Exception)((Object)new FlowFrameworkException("Failed to parse index response", RestStatus.INTERNAL_SERVER_ERROR)));
                        }
                    } else {
                        Exception exception = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                        String errorMessage = "Failed to put state index document";
                        logger.error(errorMessage, (Throwable)exception);
                        listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)exception))));
                    }
                });
            }
        }, e -> {
            String errorMessage = "Failed to create workflow_state index";
            logger.error(errorMessage, (Throwable)e);
            listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)e))));
        }));
    }

    public void updateTemplateInGlobalContext(String documentId, Template template, ActionListener<IndexResponse> listener) {
        this.updateTemplateInGlobalContext(documentId, template, listener, false);
    }

    public void updateTemplateInGlobalContext(String documentId, Template template, ActionListener<IndexResponse> listener, boolean ignoreNotStartedCheck) {
        String tenantId = template.getTenantId();
        if (!this.doesIndexExist(".plugins-flow-framework-templates")) {
            String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to update template for workflow_id : {}, global context index does not exist.", (Object)documentId).getFormattedMessage();
            logger.error(errorMessage);
            listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, RestStatus.INTERNAL_SERVER_ERROR)));
            return;
        }
        this.doesTemplateExist(documentId, tenantId, templateExists -> {
            if (templateExists.booleanValue()) {
                this.getProvisioningProgress(documentId, tenantId, progress -> {
                    if (ignoreNotStartedCheck || ProvisioningProgress.NOT_STARTED.equals(progress.orElse(null))) {
                        this.putOrReplaceTemplateInGlobalContextIndex(documentId, template, listener);
                    } else {
                        String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("The template can not be updated unless its provisioning state is NOT_STARTED: {}. Deprovision the workflow to reset the state.", (Object)documentId).getFormattedMessage();
                        logger.error(errorMessage);
                        listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, RestStatus.BAD_REQUEST)));
                    }
                }, listener);
            } else {
                String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to get template: {}", (Object)documentId).getFormattedMessage();
                logger.error(errorMessage);
                listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, RestStatus.BAD_REQUEST)));
            }
        }, listener);
    }

    public <T> void doesTemplateExist(String documentId, String tenantId, Consumer<Boolean> booleanResultConsumer, ActionListener<T> listener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.getTemplate(documentId, tenantId, (ActionListener<GetResponse>)ActionListener.wrap(response -> booleanResultConsumer.accept(response.isExists()), exception -> {
                String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to get template {}", (Object)documentId).getFormattedMessage();
                logger.error(errorMessage);
                listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)exception))));
            }), context);
        }
    }

    public void getTemplate(String documentId, String tenantId, ActionListener<GetResponse> listener, ThreadContext.StoredContext context) {
        GetDataObjectRequest getRequest = ((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(".plugins-flow-framework-templates")).id(documentId)).tenantId(tenantId)).build();
        this.sdkClient.getDataObjectAsync(getRequest).whenComplete((r, throwable) -> {
            context.restore();
            if (throwable == null) {
                try {
                    GetResponse getResponse = GetResponse.fromXContent((XContentParser)r.parser());
                    listener.onResponse((Object)getResponse);
                }
                catch (IOException e) {
                    logger.error("Failed to parse get response", (Throwable)e);
                    listener.onFailure((Exception)((Object)new FlowFrameworkException("Failed to parse get response", RestStatus.INTERNAL_SERVER_ERROR)));
                }
            } else {
                Exception exception = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to get template {}", (Object)documentId).getFormattedMessage();
                logger.error(errorMessage, (Throwable)exception);
                listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)exception))));
            }
        });
    }

    public void getWorkflowState(String workflowId, String tenantId, ActionListener<WorkflowState> listener, ThreadContext.StoredContext context) {
        GetDataObjectRequest getRequest = ((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(".plugins-flow-framework-state")).id(workflowId)).tenantId(tenantId)).build();
        this.sdkClient.getDataObjectAsync(getRequest).whenComplete((r, throwable) -> {
            block15: {
                context.restore();
                if (throwable == null) {
                    try {
                        GetResponse getResponse = GetResponse.fromXContent((XContentParser)r.parser());
                        if (getResponse != null && getResponse.isExists()) {
                            try (XContentParser parser = ParseUtils.createXContentParserFromRegistry(this.xContentRegistry, getResponse.getSourceAsBytesRef());){
                                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                                WorkflowState workflowState = WorkflowState.parse(parser);
                                listener.onResponse((Object)workflowState);
                                break block15;
                            }
                            catch (Exception e) {
                                String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to parse workflowState: {}", (Object)getResponse.getId()).getFormattedMessage();
                                logger.error(errorMessage, (Throwable)e);
                                listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, RestStatus.INTERNAL_SERVER_ERROR)));
                            }
                            break block15;
                        }
                        listener.onFailure((Exception)((Object)new FlowFrameworkException("Fail to find workflow status of " + workflowId, RestStatus.NOT_FOUND)));
                    }
                    catch (Exception e) {
                        logger.error("Failed to parse get response", (Throwable)e);
                        listener.onFailure((Exception)((Object)new FlowFrameworkException("Failed to parse get response", RestStatus.INTERNAL_SERVER_ERROR)));
                    }
                } else {
                    Exception exception = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                    if (exception instanceof IndexNotFoundException) {
                        listener.onFailure((Exception)((Object)new FlowFrameworkException("Fail to find workflow status of " + workflowId, RestStatus.NOT_FOUND)));
                    } else {
                        String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to get workflow status of: {}", (Object)workflowId).getFormattedMessage();
                        logger.error(errorMessage, (Throwable)exception);
                        listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, RestStatus.NOT_FOUND)));
                    }
                }
            }
        });
    }

    public <T> void getProvisioningProgress(String workflowId, String tenantId, Consumer<Optional<ProvisioningProgress>> provisioningProgressConsumer, ActionListener<T> listener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.getWorkflowState(workflowId, tenantId, (ActionListener<WorkflowState>)ActionListener.wrap(workflowState -> provisioningProgressConsumer.accept(Optional.of(ProvisioningProgress.valueOf(workflowState.getProvisioningProgress()))), exception -> {
                if (exception instanceof FlowFrameworkException && ((FlowFrameworkException)((Object)((Object)exception))).getRestStatus() == RestStatus.NOT_FOUND) {
                    provisioningProgressConsumer.accept(Optional.empty());
                } else {
                    listener.onFailure(exception);
                }
            }), context);
        }
    }

    public <T> void canDeleteWorkflowStateDoc(String workflowId, String tenantId, boolean clearStatus, Consumer<Boolean> canDeleteStateConsumer, ActionListener<T> listener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.getWorkflowState(workflowId, tenantId, (ActionListener<WorkflowState>)ActionListener.wrap(workflowState -> canDeleteStateConsumer.accept((clearStatus || workflowState.resourcesCreated().isEmpty()) && !ProvisioningProgress.IN_PROGRESS.equals((Object)ProvisioningProgress.valueOf(workflowState.getProvisioningProgress()))), exception -> {
                if (exception instanceof FlowFrameworkException && ((FlowFrameworkException)((Object)((Object)exception))).getRestStatus() == RestStatus.NOT_FOUND) {
                    canDeleteStateConsumer.accept(Boolean.FALSE);
                } else {
                    listener.onFailure(exception);
                }
            }), context);
        }
    }

    public void updateFlowFrameworkSystemIndexDoc(String documentId, String tenantId, ToXContentObject updatedDocument, ActionListener<UpdateResponse> listener) {
        if (!this.doesIndexExist(".plugins-flow-framework-state")) {
            String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to update document {} due to missing {} index", (Object)documentId, (Object)".plugins-flow-framework-state").getFormattedMessage();
            logger.error(errorMessage);
            listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, RestStatus.BAD_REQUEST)));
        } else {
            try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                UpdateDataObjectRequest updateRequest = ((UpdateDataObjectRequest.Builder)((UpdateDataObjectRequest.Builder)((UpdateDataObjectRequest.Builder)UpdateDataObjectRequest.builder().index(".plugins-flow-framework-state")).id(documentId)).tenantId(tenantId)).dataObject(updatedDocument).retryOnConflict(5).build();
                this.sdkClient.updateDataObjectAsync(updateRequest).whenComplete((r, throwable) -> {
                    context.restore();
                    if (throwable == null) {
                        try {
                            UpdateResponse response = UpdateResponse.fromXContent((XContentParser)r.parser());
                            logger.info("Updated workflow state doc: {}", (Object)documentId);
                            listener.onResponse((Object)response);
                        }
                        catch (Exception e) {
                            logger.error("Failed to parse update response", (Throwable)e);
                            listener.onFailure((Exception)((Object)new FlowFrameworkException("Failed to parse update response", RestStatus.INTERNAL_SERVER_ERROR)));
                        }
                    } else {
                        Exception exception = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                        String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to update {} entry : {}", (Object)".plugins-flow-framework-state", (Object)documentId).getFormattedMessage();
                        logger.error(errorMessage, (Throwable)exception);
                        listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)exception))));
                    }
                });
            }
            catch (Exception e) {
                String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to update {} entry : {}", (Object)".plugins-flow-framework-state", (Object)documentId).getFormattedMessage();
                logger.error(errorMessage, (Throwable)e);
                listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)e))));
            }
        }
    }

    public void updateFlowFrameworkSystemIndexDoc(String documentId, String tenantId, Map<String, Object> updatedFields, ActionListener<UpdateResponse> listener) {
        if (!this.doesIndexExist(".plugins-flow-framework-state")) {
            String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to update document {} due to missing {} index", (Object)documentId, (Object)".plugins-flow-framework-state").getFormattedMessage();
            logger.error(errorMessage);
            listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, RestStatus.BAD_REQUEST)));
        } else {
            try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                HashMap<String, Object> updatedContent = new HashMap<String, Object>(updatedFields);
                UpdateDataObjectRequest updateRequest = ((UpdateDataObjectRequest.Builder)((UpdateDataObjectRequest.Builder)((UpdateDataObjectRequest.Builder)UpdateDataObjectRequest.builder().index(".plugins-flow-framework-state")).id(documentId)).tenantId(tenantId)).dataObject(updatedContent).retryOnConflict(5).build();
                this.sdkClient.updateDataObjectAsync(updateRequest).whenComplete((r, throwable) -> {
                    context.restore();
                    if (throwable == null) {
                        try {
                            UpdateResponse response = UpdateResponse.fromXContent((XContentParser)r.parser());
                            logger.info("Updated workflow state doc: {}", (Object)documentId);
                            listener.onResponse((Object)response);
                        }
                        catch (Exception e) {
                            logger.error("Failed to parse update response", (Throwable)e);
                            listener.onFailure((Exception)((Object)new FlowFrameworkException("Failed to parse update response", RestStatus.INTERNAL_SERVER_ERROR)));
                        }
                    } else {
                        Exception exception = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                        String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to update {} entry : {}", (Object)".plugins-flow-framework-state", (Object)documentId).getFormattedMessage();
                        logger.error(errorMessage, (Throwable)exception);
                        listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)exception))));
                    }
                });
            }
            catch (Exception e) {
                String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to update {} entry : {}", (Object)".plugins-flow-framework-state", (Object)documentId).getFormattedMessage();
                logger.error(errorMessage, (Throwable)e);
                listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)e))));
            }
        }
    }

    public void deleteFlowFrameworkSystemIndexDoc(String documentId, String tenantId, ActionListener<DeleteResponse> listener) {
        if (!this.doesIndexExist(".plugins-flow-framework-state")) {
            String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to delete document {} due to missing {} index", (Object)documentId, (Object)".plugins-flow-framework-state").getFormattedMessage();
            logger.error(errorMessage);
            listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, RestStatus.BAD_REQUEST)));
        } else {
            try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                DeleteDataObjectRequest deleteRequest = ((DeleteDataObjectRequest.Builder)((DeleteDataObjectRequest.Builder)((DeleteDataObjectRequest.Builder)DeleteDataObjectRequest.builder().index(".plugins-flow-framework-state")).id(documentId)).tenantId(tenantId)).build();
                this.sdkClient.deleteDataObjectAsync(deleteRequest).whenComplete((r, throwable) -> {
                    context.restore();
                    if (throwable == null) {
                        try {
                            DeleteResponse response = DeleteResponse.fromXContent((XContentParser)r.parser());
                            logger.info("Deleted workflow state doc: {}", (Object)documentId);
                            listener.onResponse((Object)response);
                        }
                        catch (Exception e) {
                            logger.error("Failed to parse delete response", (Throwable)e);
                            listener.onFailure((Exception)((Object)new FlowFrameworkException("Failed to parse delete response", RestStatus.INTERNAL_SERVER_ERROR)));
                        }
                    } else {
                        Exception exception = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                        String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to delete {} entry : {}", (Object)".plugins-flow-framework-state", (Object)documentId).getFormattedMessage();
                        logger.error(errorMessage, (Throwable)exception);
                        listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)exception))));
                    }
                });
            }
        }
    }

    public void addResourceToStateIndex(WorkflowData currentNodeInputs, String nodeId, String workflowStepName, String resourceId, String tenantId, ActionListener<WorkflowData> listener) {
        String workflowId = currentNodeInputs.getWorkflowId();
        if (!this.validateStateIndexExists(workflowId, listener)) {
            return;
        }
        String resourceName = WorkflowResources.getResourceByWorkflowStep(workflowStepName);
        ResourceCreated newResource = new ResourceCreated(workflowStepName, nodeId, resourceName, resourceId);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.getAndUpdateResourceInStateDocumentWithRetries(workflowId, tenantId, newResource, DocWriteRequest.OpType.INDEX, 5, (ActionListener<WorkflowData>)ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore()));
        }
    }

    public void deleteResourceFromStateIndex(String workflowId, String tenantId, ResourceCreated resourceToDelete, ActionListener<WorkflowData> listener) {
        if (!this.validateStateIndexExists(workflowId, listener)) {
            return;
        }
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.getAndUpdateResourceInStateDocumentWithRetries(workflowId, tenantId, resourceToDelete, DocWriteRequest.OpType.DELETE, 5, (ActionListener<WorkflowData>)ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore()));
        }
    }

    private boolean validateStateIndexExists(String workflowId, ActionListener<WorkflowData> listener) {
        if (!this.doesIndexExist(".plugins-flow-framework-state")) {
            String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to update state for {} due to missing {} index", (Object)workflowId, (Object)".plugins-flow-framework-state").getFormattedMessage();
            logger.error(errorMessage);
            listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, RestStatus.NOT_FOUND)));
            return false;
        }
        return true;
    }

    private void getAndUpdateResourceInStateDocumentWithRetries(String workflowId, String tenantId, ResourceCreated resource, DocWriteRequest.OpType operation, int retries, ActionListener<WorkflowData> listener) {
        GetDataObjectRequest getRequest = ((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(".plugins-flow-framework-state")).id(workflowId)).tenantId(tenantId)).build();
        this.sdkClient.getDataObjectAsync(getRequest).whenComplete((r, throwable) -> {
            if (throwable == null) {
                try {
                    GetResponse getResponse = GetResponse.fromXContent((XContentParser)r.parser());
                    this.handleStateGetResponse(workflowId, tenantId, resource, operation, retries, listener, getResponse);
                }
                catch (Exception e) {
                    logger.error("Failed to parse get response", (Throwable)e);
                    listener.onFailure((Exception)((Object)new FlowFrameworkException("Failed to parse get response", RestStatus.INTERNAL_SERVER_ERROR)));
                }
            } else {
                Exception ex = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                this.handleStateUpdateException(workflowId, tenantId, resource, operation, 0, listener, ex);
            }
        });
    }

    private void handleStateGetResponse(String workflowId, String tenantId, ResourceCreated resource, DocWriteRequest.OpType operation, int retries, ActionListener<WorkflowData> listener, GetResponse getResponse) {
        if (!getResponse.isExists()) {
            listener.onFailure((Exception)((Object)new FlowFrameworkException("Workflow state not found for " + workflowId, RestStatus.NOT_FOUND)));
            return;
        }
        try {
            WorkflowState currentState = WorkflowState.parse(getResponse.getSourceAsString());
            ArrayList<ResourceCreated> resourcesCreated = new ArrayList<ResourceCreated>(currentState.resourcesCreated());
            if (operation == DocWriteRequest.OpType.DELETE) {
                resourcesCreated.removeIf(r -> r.resourceMap().equals(resource.resourceMap()));
            } else {
                resourcesCreated.add(resource);
            }
            WorkflowState newState = WorkflowState.builder(currentState).resourcesCreated(resourcesCreated).build();
            UpdateDataObjectRequest updateRequest = ((UpdateDataObjectRequest.Builder)((UpdateDataObjectRequest.Builder)((UpdateDataObjectRequest.Builder)((UpdateDataObjectRequest.Builder)((UpdateDataObjectRequest.Builder)UpdateDataObjectRequest.builder().index(".plugins-flow-framework-state")).id(workflowId)).tenantId(tenantId)).dataObject((ToXContentObject)newState).ifSeqNo(getResponse.getSeqNo())).ifPrimaryTerm(getResponse.getPrimaryTerm())).build();
            this.sdkClient.updateDataObjectAsync(updateRequest).whenComplete((r, throwable) -> {
                if (throwable == null) {
                    this.handleStateUpdateSuccess(workflowId, resource, operation, listener);
                } else {
                    Exception e = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                    this.handleStateUpdateException(workflowId, tenantId, resource, operation, retries, listener, e);
                }
            });
        }
        catch (Exception e) {
            String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to parse workflow state response for {}", (Object)workflowId).getFormattedMessage();
            logger.error(errorMessage, (Throwable)e);
            listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, RestStatus.INTERNAL_SERVER_ERROR)));
        }
    }

    private void handleStateUpdateSuccess(String workflowId, ResourceCreated newResource, DocWriteRequest.OpType operation, ActionListener<WorkflowData> listener) {
        String resourceName = newResource.resourceType();
        String resourceId = newResource.resourceId();
        String nodeId = newResource.workflowStepId();
        logger.info("Updated resources created for {} on step {} to {} resource {} {}", (Object)workflowId, (Object)nodeId, (Object)(operation.equals((Object)DocWriteRequest.OpType.DELETE) ? "delete" : "add"), (Object)resourceName, (Object)resourceId);
        listener.onResponse((Object)new WorkflowData(Map.of(resourceName, resourceId), workflowId, nodeId));
    }

    private void handleStateUpdateException(String workflowId, String tenantId, ResourceCreated newResource, DocWriteRequest.OpType operation, int retries, ActionListener<WorkflowData> listener, Exception e) {
        if (e instanceof OpenSearchStatusException && ((OpenSearchStatusException)e).status() == RestStatus.CONFLICT && retries > 0) {
            this.getAndUpdateResourceInStateDocumentWithRetries(workflowId, tenantId, newResource, operation, retries - 1, listener);
            return;
        }
        String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to update workflow state for {} on step {} to {} resource {} {}", (Object)workflowId, (Object)newResource.workflowStepId(), (Object)(operation.equals((Object)DocWriteRequest.OpType.DELETE) ? "delete" : "add"), (Object)newResource.resourceType(), (Object)newResource.resourceId()).getFormattedMessage();
        logger.error(errorMessage, (Throwable)e);
        listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)e))));
    }

    static {
        for (FlowFrameworkIndex mlIndex : FlowFrameworkIndex.values()) {
            indexMappingUpdated.put(mlIndex.getIndexName(), new AtomicBoolean(false));
        }
    }
}

