/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.security.SecureRandom;
import org.bouncycastle.crypto.fips.FipsSecureRandom;
import org.bouncycastle.crypto.internal.KeyGenerationParameters;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class CipherKeyGenerator {
    protected SecureRandom random;
    protected int strength;

    CipherKeyGenerator() {
    }

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.random = keyGenerationParameters.getRandom();
        this.strength = (keyGenerationParameters.getStrength() + 7) / 8;
    }

    public byte[] generateKey() {
        byte[] byArray = new byte[this.strength];
        if (this.random instanceof FipsSecureRandom) {
            FipsSecureRandom fipsSecureRandom = (FipsSecureRandom)this.random;
            fipsSecureRandom.reseed();
            fipsSecureRandom.nextBytes(byArray);
        } else {
            this.random.nextBytes(byArray);
        }
        return byArray;
    }
}

