/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal;

import org.bouncycastle.crypto.internal.BlockCipher;
import org.bouncycastle.crypto.internal.BufferedBlockCipher;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.DataLengthException;
import org.bouncycastle.crypto.internal.InvalidCipherTextException;
import org.bouncycastle.crypto.internal.MultiBlockCipher;
import org.bouncycastle.crypto.internal.OutputLengthException;
import org.bouncycastle.crypto.internal.StreamCipher;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DefaultBufferedMultiBlockCipher
implements BufferedBlockCipher {
    protected byte[] buf;
    protected int bufOff;
    protected boolean forEncryption;
    protected MultiBlockCipher cipher;
    protected boolean partialBlockOkay;
    protected boolean pgpCFB;
    protected int blockSize;

    public DefaultBufferedMultiBlockCipher(MultiBlockCipher multiBlockCipher) {
        this.cipher = multiBlockCipher;
        this.blockSize = multiBlockCipher.getBlockSize();
        String string = multiBlockCipher.getAlgorithmName();
        int n = string.indexOf(47) + 1;
        boolean bl = this.pgpCFB = n > 0 && string.startsWith("PGP", n);
        this.partialBlockOkay = this.pgpCFB || multiBlockCipher instanceof StreamCipher ? true : n > 0 && string.startsWith("OpenPGP", n);
    }

    @Override
    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        this.forEncryption = bl;
        this.reset();
        this.cipher.init(bl, cipherParameters);
        this.buf = new byte[this.cipher.getMultiBlockSize()];
        this.bufOff = 0;
    }

    @Override
    public int getBlockSize() {
        return this.blockSize;
    }

    @Override
    public int getUpdateOutputSize(int n) {
        int n2 = n + this.bufOff;
        int n3 = this.pgpCFB ? (this.forEncryption ? n2 % this.buf.length - (this.blockSize + 2) : n2 % this.buf.length) : (this.partialBlockOkay ? 0 : n2 % this.buf.length);
        return n2 - n3;
    }

    @Override
    public int getOutputSize(int n) {
        int n2 = this.bufOff % this.blockSize;
        int n3 = this.bufOff / this.blockSize;
        if (this.pgpCFB && this.forEncryption) {
            return n + n3 * this.blockSize + n2 + (this.cipher.getBlockSize() + 2);
        }
        return n + n3 * this.blockSize + n2;
    }

    @Override
    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        if (n2 < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        int n4 = this.getUpdateOutputSize(n2);
        if (n4 > 0 && n3 + n4 > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        int n5 = 0;
        int n6 = this.buf.length - this.bufOff;
        if (n2 > n6) {
            int n7;
            if (this.bufOff != 0) {
                System.arraycopy(byArray, n, this.buf, this.bufOff, n6);
                n5 += this.cipher.processBlocks(this.buf, 0, this.buf.length / this.blockSize, byArray2, n3);
                this.bufOff = 0;
                n2 -= n6;
                n += n6;
            }
            if ((n7 = n2 / this.cipher.getMultiBlockSize() * (this.cipher.getMultiBlockSize() / this.blockSize)) > 0) {
                n5 += this.cipher.processBlocks(byArray, n, n7, byArray2, n3 + n5);
                int n8 = n7 * this.blockSize;
                n2 -= n8;
                n += n8;
            }
        }
        System.arraycopy(byArray, n, this.buf, this.bufOff, n2);
        this.bufOff += n2;
        if (this.bufOff == this.buf.length) {
            n5 += this.cipher.processBlocks(this.buf, 0, this.buf.length / this.blockSize, byArray2, n3 + n5);
            this.bufOff = 0;
        }
        return n5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doFinal(byte[] byArray, int n) throws DataLengthException, IllegalStateException, InvalidCipherTextException {
        try {
            int n2 = 0;
            if (n + this.bufOff > byArray.length) {
                throw new OutputLengthException("output buffer too short for doFinal()");
            }
            if (this.bufOff != 0) {
                if (!this.partialBlockOkay && this.bufOff % this.blockSize != 0) {
                    throw new DataLengthException("data not block size aligned");
                }
                this.cipher.processBlocks(this.buf, 0, (this.bufOff + this.blockSize - 1) / this.blockSize, this.buf, 0);
                n2 = this.bufOff;
                this.bufOff = 0;
                System.arraycopy(this.buf, 0, byArray, n, n2);
            }
            int n3 = n2;
            return n3;
        }
        finally {
            this.reset();
        }
    }

    @Override
    public void reset() {
        if (this.buf != null) {
            for (int i = 0; i < this.buf.length; ++i) {
                this.buf[i] = 0;
            }
        }
        this.bufOff = 0;
        this.cipher.reset();
    }

    public String toString() {
        return "DefaultBufferedMultiBlockCipher(" + this.cipher.toString() + ")";
    }
}

