/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.VersionType;
import org.opensearch.client.opensearch.core.MtermvectorsResponse;
import org.opensearch.client.opensearch.core.mtermvectors.MultiTermVectorsOperation;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class MtermvectorsRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, MtermvectorsRequest> {
    @Nonnull
    private final List<MultiTermVectorsOperation> docs;
    @Nullable
    private final Boolean fieldStatistics;
    @Nonnull
    private final List<String> fields;
    @Nonnull
    private final List<String> ids;
    @Nullable
    private final String index;
    @Nullable
    private final Boolean offsets;
    @Nullable
    private final Boolean payloads;
    @Nullable
    private final Boolean positions;
    @Nullable
    private final String preference;
    @Nullable
    private final Boolean realtime;
    @Nonnull
    private final List<String> routing;
    @Nullable
    private final Boolean termStatistics;
    @Nullable
    private final Long version;
    @Nullable
    private final VersionType versionType;
    public static final JsonpDeserializer<MtermvectorsRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MtermvectorsRequest::setupMtermvectorsRequestDeserializer);
    public static final Endpoint<MtermvectorsRequest, MtermvectorsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<MtermvectorsRequest, MtermvectorsResponse>(request -> "POST", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (request.index() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            return "/_mtermvectors";
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_mtermvectors");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, MtermvectorsResponse._DESERIALIZER);

    private MtermvectorsRequest(Builder builder) {
        super(builder);
        this.docs = ApiTypeHelper.unmodifiable(builder.docs);
        this.fieldStatistics = builder.fieldStatistics;
        this.fields = ApiTypeHelper.unmodifiable(builder.fields);
        this.ids = ApiTypeHelper.unmodifiable(builder.ids);
        this.index = builder.index;
        this.offsets = builder.offsets;
        this.payloads = builder.payloads;
        this.positions = builder.positions;
        this.preference = builder.preference;
        this.realtime = builder.realtime;
        this.routing = ApiTypeHelper.unmodifiable(builder.routing);
        this.termStatistics = builder.termStatistics;
        this.version = builder.version;
        this.versionType = builder.versionType;
    }

    public static MtermvectorsRequest of(Function<Builder, ObjectBuilder<MtermvectorsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<MultiTermVectorsOperation> docs() {
        return this.docs;
    }

    @Nullable
    public final Boolean fieldStatistics() {
        return this.fieldStatistics;
    }

    @Nonnull
    public final List<String> fields() {
        return this.fields;
    }

    @Nonnull
    public final List<String> ids() {
        return this.ids;
    }

    @Nullable
    public final String index() {
        return this.index;
    }

    @Nullable
    public final Boolean offsets() {
        return this.offsets;
    }

    @Nullable
    public final Boolean payloads() {
        return this.payloads;
    }

    @Nullable
    public final Boolean positions() {
        return this.positions;
    }

    @Nullable
    public final String preference() {
        return this.preference;
    }

    @Nullable
    public final Boolean realtime() {
        return this.realtime;
    }

    @Nonnull
    public final List<String> routing() {
        return this.routing;
    }

    @Nullable
    public final Boolean termStatistics() {
        return this.termStatistics;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    @Nullable
    public final VersionType versionType() {
        return this.versionType;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.docs)) {
            generator.writeKey("docs");
            generator.writeStartArray();
            for (MultiTermVectorsOperation multiTermVectorsOperation : this.docs) {
                multiTermVectorsOperation.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.ids)) {
            generator.writeKey("ids");
            generator.writeStartArray();
            for (String string : this.ids) {
                generator.write(string);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupMtermvectorsRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::docs, JsonpDeserializer.arrayDeserializer(MultiTermVectorsOperation._DESERIALIZER), "docs");
        op.add(Builder::ids, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "ids");
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.fieldStatistics != null) {
            params.put("field_statistics", String.valueOf(this.fieldStatistics));
        }
        if (ApiTypeHelper.isDefined(this.fields)) {
            params.put("fields", String.join((CharSequence)",", this.fields));
        }
        if (this.offsets != null) {
            params.put("offsets", String.valueOf(this.offsets));
        }
        if (this.payloads != null) {
            params.put("payloads", String.valueOf(this.payloads));
        }
        if (this.positions != null) {
            params.put("positions", String.valueOf(this.positions));
        }
        if (this.preference != null) {
            params.put("preference", this.preference);
        }
        if (this.realtime != null) {
            params.put("realtime", String.valueOf(this.realtime));
        }
        if (ApiTypeHelper.isDefined(this.routing)) {
            params.put("routing", String.join((CharSequence)",", this.routing));
        }
        if (this.termStatistics != null) {
            params.put("term_statistics", String.valueOf(this.termStatistics));
        }
        if (this.version != null) {
            params.put("version", String.valueOf(this.version));
        }
        if (this.versionType != null) {
            params.put("version_type", this.versionType.jsonValue());
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.docs);
        result = 31 * result + Objects.hashCode(this.fieldStatistics);
        result = 31 * result + Objects.hashCode(this.fields);
        result = 31 * result + Objects.hashCode(this.ids);
        result = 31 * result + Objects.hashCode(this.index);
        result = 31 * result + Objects.hashCode(this.offsets);
        result = 31 * result + Objects.hashCode(this.payloads);
        result = 31 * result + Objects.hashCode(this.positions);
        result = 31 * result + Objects.hashCode(this.preference);
        result = 31 * result + Objects.hashCode(this.realtime);
        result = 31 * result + Objects.hashCode(this.routing);
        result = 31 * result + Objects.hashCode(this.termStatistics);
        result = 31 * result + Objects.hashCode(this.version);
        result = 31 * result + Objects.hashCode(this.versionType);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MtermvectorsRequest other = (MtermvectorsRequest)o;
        return Objects.equals(this.docs, other.docs) && Objects.equals(this.fieldStatistics, other.fieldStatistics) && Objects.equals(this.fields, other.fields) && Objects.equals(this.ids, other.ids) && Objects.equals(this.index, other.index) && Objects.equals(this.offsets, other.offsets) && Objects.equals(this.payloads, other.payloads) && Objects.equals(this.positions, other.positions) && Objects.equals(this.preference, other.preference) && Objects.equals(this.realtime, other.realtime) && Objects.equals(this.routing, other.routing) && Objects.equals(this.termStatistics, other.termStatistics) && Objects.equals(this.version, other.version) && Objects.equals(this.versionType, other.versionType);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, MtermvectorsRequest> {
        @Nullable
        private List<MultiTermVectorsOperation> docs;
        @Nullable
        private Boolean fieldStatistics;
        @Nullable
        private List<String> fields;
        @Nullable
        private List<String> ids;
        @Nullable
        private String index;
        @Nullable
        private Boolean offsets;
        @Nullable
        private Boolean payloads;
        @Nullable
        private Boolean positions;
        @Nullable
        private String preference;
        @Nullable
        private Boolean realtime;
        @Nullable
        private List<String> routing;
        @Nullable
        private Boolean termStatistics;
        @Nullable
        private Long version;
        @Nullable
        private VersionType versionType;

        public Builder() {
        }

        private Builder(MtermvectorsRequest o) {
            super(o);
            this.docs = Builder._listCopy(o.docs);
            this.fieldStatistics = o.fieldStatistics;
            this.fields = Builder._listCopy(o.fields);
            this.ids = Builder._listCopy(o.ids);
            this.index = o.index;
            this.offsets = o.offsets;
            this.payloads = o.payloads;
            this.positions = o.positions;
            this.preference = o.preference;
            this.realtime = o.realtime;
            this.routing = Builder._listCopy(o.routing);
            this.termStatistics = o.termStatistics;
            this.version = o.version;
            this.versionType = o.versionType;
        }

        private Builder(Builder o) {
            super(o);
            this.docs = Builder._listCopy(o.docs);
            this.fieldStatistics = o.fieldStatistics;
            this.fields = Builder._listCopy(o.fields);
            this.ids = Builder._listCopy(o.ids);
            this.index = o.index;
            this.offsets = o.offsets;
            this.payloads = o.payloads;
            this.positions = o.positions;
            this.preference = o.preference;
            this.realtime = o.realtime;
            this.routing = Builder._listCopy(o.routing);
            this.termStatistics = o.termStatistics;
            this.version = o.version;
            this.versionType = o.versionType;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder docs(List<MultiTermVectorsOperation> list) {
            this.docs = Builder._listAddAll(this.docs, list);
            return this;
        }

        @Nonnull
        public final Builder docs(MultiTermVectorsOperation value, MultiTermVectorsOperation ... values) {
            this.docs = Builder._listAdd(this.docs, value, values);
            return this;
        }

        @Nonnull
        public final Builder docs(Function<MultiTermVectorsOperation.Builder, ObjectBuilder<MultiTermVectorsOperation>> fn) {
            return this.docs(fn.apply(new MultiTermVectorsOperation.Builder()).build(), new MultiTermVectorsOperation[0]);
        }

        @Nonnull
        public final Builder fieldStatistics(@Nullable Boolean value) {
            this.fieldStatistics = value;
            return this;
        }

        @Nonnull
        public final Builder fields(List<String> list) {
            this.fields = Builder._listAddAll(this.fields, list);
            return this;
        }

        @Nonnull
        public final Builder fields(String value, String ... values) {
            this.fields = Builder._listAdd(this.fields, value, values);
            return this;
        }

        @Nonnull
        public final Builder ids(List<String> list) {
            this.ids = Builder._listAddAll(this.ids, list);
            return this;
        }

        @Nonnull
        public final Builder ids(String value, String ... values) {
            this.ids = Builder._listAdd(this.ids, value, values);
            return this;
        }

        @Nonnull
        public final Builder index(@Nullable String value) {
            this.index = value;
            return this;
        }

        @Nonnull
        public final Builder offsets(@Nullable Boolean value) {
            this.offsets = value;
            return this;
        }

        @Nonnull
        public final Builder payloads(@Nullable Boolean value) {
            this.payloads = value;
            return this;
        }

        @Nonnull
        public final Builder positions(@Nullable Boolean value) {
            this.positions = value;
            return this;
        }

        @Nonnull
        public final Builder preference(@Nullable String value) {
            this.preference = value;
            return this;
        }

        @Nonnull
        public final Builder realtime(@Nullable Boolean value) {
            this.realtime = value;
            return this;
        }

        @Nonnull
        public final Builder routing(List<String> list) {
            this.routing = Builder._listAddAll(this.routing, list);
            return this;
        }

        @Nonnull
        public final Builder routing(String value, String ... values) {
            this.routing = Builder._listAdd(this.routing, value, values);
            return this;
        }

        @Nonnull
        public final Builder termStatistics(@Nullable Boolean value) {
            this.termStatistics = value;
            return this;
        }

        @Nonnull
        public final Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        @Nonnull
        public final Builder versionType(@Nullable VersionType value) {
            this.versionType = value;
            return this;
        }

        @Override
        @Nonnull
        public MtermvectorsRequest build() {
            this._checkSingleUse();
            return new MtermvectorsRequest(this);
        }
    }
}

