/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.allocation_explain;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ReservedSize
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ReservedSize> {
    @Nonnull
    private final String nodeId;
    @Nonnull
    private final String path;
    @Nonnull
    private final List<String> shards;
    private final long total;
    public static final JsonpDeserializer<ReservedSize> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ReservedSize::setupReservedSizeDeserializer);

    private ReservedSize(Builder builder) {
        this.nodeId = ApiTypeHelper.requireNonNull(builder.nodeId, this, "nodeId");
        this.path = ApiTypeHelper.requireNonNull(builder.path, this, "path");
        this.shards = ApiTypeHelper.unmodifiableRequired(builder.shards, (Object)this, "shards");
        this.total = ApiTypeHelper.requireNonNull(builder.total, this, "total");
    }

    public static ReservedSize of(Function<Builder, ObjectBuilder<ReservedSize>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final String nodeId() {
        return this.nodeId;
    }

    @Nonnull
    public final String path() {
        return this.path;
    }

    @Nonnull
    public final List<String> shards() {
        return this.shards;
    }

    public final long total() {
        return this.total;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("node_id");
        generator.write(this.nodeId);
        generator.writeKey("path");
        generator.write(this.path);
        generator.writeKey("shards");
        generator.writeStartArray();
        for (String item0 : this.shards) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("total");
        generator.write(this.total);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupReservedSizeDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::nodeId, JsonpDeserializer.stringDeserializer(), "node_id");
        op.add(Builder::path, JsonpDeserializer.stringDeserializer(), "path");
        op.add(Builder::shards, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "shards");
        op.add(Builder::total, JsonpDeserializer.longDeserializer(), "total");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.nodeId.hashCode();
        result = 31 * result + this.path.hashCode();
        result = 31 * result + this.shards.hashCode();
        result = 31 * result + Long.hashCode(this.total);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReservedSize other = (ReservedSize)o;
        return this.nodeId.equals(other.nodeId) && this.path.equals(other.path) && this.shards.equals(other.shards) && this.total == other.total;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ReservedSize> {
        private String nodeId;
        private String path;
        private List<String> shards;
        private Long total;

        public Builder() {
        }

        private Builder(ReservedSize o) {
            this.nodeId = o.nodeId;
            this.path = o.path;
            this.shards = Builder._listCopy(o.shards);
            this.total = o.total;
        }

        private Builder(Builder o) {
            this.nodeId = o.nodeId;
            this.path = o.path;
            this.shards = Builder._listCopy(o.shards);
            this.total = o.total;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder nodeId(String value) {
            this.nodeId = value;
            return this;
        }

        @Nonnull
        public final Builder path(String value) {
            this.path = value;
            return this;
        }

        @Nonnull
        public final Builder shards(List<String> list) {
            this.shards = Builder._listAddAll(this.shards, list);
            return this;
        }

        @Nonnull
        public final Builder shards(String value, String ... values) {
            this.shards = Builder._listAdd(this.shards, value, values);
            return this;
        }

        @Nonnull
        public final Builder total(long value) {
            this.total = value;
            return this;
        }

        @Override
        @Nonnull
        public ReservedSize build() {
            this._checkSingleUse();
            return new ReservedSize(this);
        }
    }
}

