/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ltr.transport;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.ltr.stats.LTRStat;
import org.opensearch.ltr.stats.LTRStats;
import org.opensearch.ltr.transport.LTRStatsNodeRequest;
import org.opensearch.ltr.transport.LTRStatsNodeResponse;
import org.opensearch.ltr.transport.LTRStatsNodesResponse;
import org.opensearch.ltr.transport.LTRStatsRequest;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportLTRStatsAction
extends TransportNodesAction<LTRStatsRequest, LTRStatsNodesResponse, LTRStatsNodeRequest, LTRStatsNodeResponse> {
    private final LTRStats ltrStats;

    @Inject
    public TransportLTRStatsAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, LTRStats ltrStats) {
        super("cluster:admin/ltr/stats", threadPool, clusterService, transportService, actionFilters, LTRStatsRequest::new, LTRStatsNodeRequest::new, "management", LTRStatsNodeResponse.class);
        this.ltrStats = ltrStats;
    }

    protected LTRStatsNodesResponse newResponse(LTRStatsRequest request, List<LTRStatsNodeResponse> nodeResponses, List<FailedNodeException> failures) {
        Set<String> statsToBeRetrieved = request.getStatsToBeRetrieved();
        Map<String, Object> clusterStats = this.ltrStats.getClusterStats().entrySet().stream().filter(e -> statsToBeRetrieved.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, e -> ((LTRStat)e.getValue()).getValue()));
        return new LTRStatsNodesResponse(this.clusterService.getClusterName(), nodeResponses, failures, clusterStats);
    }

    protected LTRStatsNodeRequest newNodeRequest(LTRStatsRequest request) {
        return new LTRStatsNodeRequest(request);
    }

    protected LTRStatsNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new LTRStatsNodeResponse(in);
    }

    protected LTRStatsNodeResponse nodeOperation(LTRStatsNodeRequest request) {
        LTRStatsRequest ltrStatsRequest = request.getLTRStatsNodesRequest();
        Set<String> statsToBeRetrieved = ltrStatsRequest.getStatsToBeRetrieved();
        Map<String, Object> statValues = this.ltrStats.getNodeStats().entrySet().stream().filter(e -> statsToBeRetrieved.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, e -> ((LTRStat)e.getValue()).getValue()));
        return new LTRStatsNodeResponse(this.clusterService.localNode(), statValues);
    }
}

